/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.model.oauth.ClientSecretRetentionPeriodType;
import com.pingidentity.admin.api.validator.CIBADefaultsValidator;
import com.pingidentity.admin.api.validator.ClientOfflineAccessRequireConsentPromptValidator;
import com.pingidentity.admin.api.validator.ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator;
import com.pingidentity.admin.api.validator.ClientSecretRetentionPeriodValidator;
import com.pingidentity.admin.api.validator.LockoutMaxMaliciousActionsValidator;
import com.pingidentity.admin.api.validator.OAuthClientDefaultsValidator;
import com.pingidentity.admin.api.validator.RefreshTokenRollingGracePeriodValidator;
import com.pingidentity.admin.api.validator.RefreshTokenRollingIntervalValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AbstractOAuthClientRefreshRollingIntervalTaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.OAuthClientTasklet;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.util.PersistentGrantSettingTimeUnitSelectionModel;
import com.pingidentity.util.RefreshTokenRollingIntervalTimeUnitSelectionModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class OAuthDynamicClientRegistrationDefaultsState
extends AbstractOAuthClientRefreshRollingIntervalTaskletState
implements Serializable {
    private static final long serialVersionUID = 20200505L;
    public static final String DEFAULT = "default";
    public static final String DEFAULT_LABEL = "Default";
    public static final String USE_GLOBAL_SETTING = "Use Global Setting";
    private boolean enforceReplayPrevention = false;
    private boolean requireSignedRequest;
    private String persistentGrantExpirationType = "SERVER_DEFAULT";
    private String persistentGrantExpirationTime;
    private String selectedPersistentGrantExpirationTimeUnit;
    private StringPairPropertySelectionModel persistentGrantExpirationTimeUnitList;
    private String persistentGrantIdleTimeoutType = "SERVER_DEFAULT";
    private String persistentGrantIdleTimeout;
    private String selectedPersistentGrantIdleTimeoutTimeUnit;
    private StringPairPropertySelectionModel persistentGrantIdleTimeoutTimeUnitList;
    private String selectedIdTokenSigningAlgorithm;
    private StringPairPropertySelectionModel idTokenSigningAlgorithmList;
    private String selectedTokenManagerId;
    private boolean restrictToDefaultAccessTokenManager = false;
    private StringPairPropertySelectionModel tokenManagerIdList;
    private Set<Cert> trustedCAs = new HashSet<Cert>();
    private Cert trustAllDummyCert;
    private Cert clientCertIssuer;
    private String selectedPolicyGroupId;
    private StringPairPropertySelectionModel policyGroupIdList;
    private String rolling = "default";
    private String deviceFlowSettingType = "SERVER_DEFAULT";
    private String userAuthzUrlOverride;
    private String pendingAuthzTimeoutOverride;
    private String devicePollingIntervalOverride;
    private Boolean bypassActivationCodeConfirmationOverride;
    private boolean requireProofKeyForCodeExchange;
    public static final String TITLE = "Client Configuration Defaults";
    private static final String DEFAULT_CERT_ISSUER = "--NONE-- (Client TLS Certificate Authentication Disabled)";
    private boolean displayAlgorithmWarning;
    private boolean cibaRequireSignedRequests;
    private String cibaPolicyId;
    private StringPairPropertySelectionModel cibaPolicyIdList;
    private String cibaPollingInterval;
    private String tokenExchangeProcessorPolicyId;
    private StringPairPropertySelectionModel tokenExchangeProcessorPolicyIdList;
    private String refreshTokenRollingGracePeriod = null;
    private String refreshTokenRollingGracePeriodType = "SERVER_DEFAULT";
    private boolean enableRetainClientSecret;
    private String clientSecretRetentionPeriodType = ClientSecretRetentionPeriodType.SERVER_DEFAULT.getId();
    private String clientSecretRetentionPeriod;
    private boolean requireJwtSecuredAuthorizationResponseMode;
    private String requireOfflineAccessScopeToIssueRefreshTokens = "SERVER_DEFAULT";
    private String offlineAccessRequireConsentPrompt = "SERVER_DEFAULT";
    private String lockoutMaxMaliciousActionsType = "SERVER_DEFAULT";
    private String lockoutMaxMaliciousActions = null;
    private final transient ClientSettingManager clientSettingManager;

    public OAuthDynamicClientRegistrationDefaultsState(IWizard owner, ClientSettingManager clientSettingManager) {
        super(owner);
        this.setMenuName(TITLE);
        this.clientSettingManager = clientSettingManager;
        this.init();
    }

    private void init() {
        boolean supportMilli = Boolean.parseBoolean(System.getProperty("enablePersistentGrantExpirationTimeUnitMilli", "false"));
        this.persistentGrantExpirationTimeUnitList = new PersistentGrantSettingTimeUnitSelectionModel(supportMilli);
        this.persistentGrantIdleTimeoutTimeUnitList = new PersistentGrantSettingTimeUnitSelectionModel(supportMilli);
        this.setRefreshRollingIntervalTimeUnitList(new RefreshTokenRollingIntervalTimeUnitSelectionModel());
        this.createIdTokenSigningAlgorithmList();
        this.createPolicyGroupIdList();
        this.createTokenManagerIdList();
        this.createTrustedCAList();
        this.createCibaPolicyIdList();
        this.createTokenExchangeProcessorPolicyIdList();
    }

    private void createIdTokenSigningAlgorithmList() {
        this.idTokenSigningAlgorithmList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        Map signingAlgos = OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac();
        for (Map.Entry entry : signingAlgos.entrySet()) {
            this.idTokenSigningAlgorithmList.add((String)entry.getValue(), entry.getKey());
        }
        this.idTokenSigningAlgorithmList.sort();
    }

    private void createPolicyGroupIdList() {
        this.policyGroupIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        OpenIdConnectProviderPolicy policy = connectProviderPolicyManager.getPolicy();
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policy.getPolicyGroups().values()) {
            this.policyGroupIdList.add(policyGroup.getName(), policyGroup.getPolicyId());
        }
    }

    private void createTrustedCAList() {
        try {
            Class<X509CertImpl> x509CertClazz = X509CertImpl.class;
            Constructor x509CertConstructor = x509CertClazz.getConstructor(X509CertInfo.class, AlgorithmId.class, byte[].class, byte[].class);
            this.trustAllDummyCert = new Cert("Trust Any", (X509Certificate)x509CertConstructor.newInstance(null, null, null, new byte[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.trustAllDummyCert = new Cert("Trust Any", (X509Certificate)new X509CertImpl());
        }
        this.trustedCAs.clear();
        TrustedCAsManager mgr = MgmtFactory.getTrustedCAsManager();
        this.trustedCAs = mgr.getTrustedCAs();
    }

    private void createTokenManagerIdList() {
        this.tokenManagerIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        Collection instances = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
        for (BearerAccessTokenMgmtPluginInstance instance : instances) {
            this.tokenManagerIdList.add(instance.getName(), instance.getId());
        }
    }

    public boolean isEnforceReplayPrevention() {
        return this.enforceReplayPrevention;
    }

    public void setEnforceReplayPrevention(boolean enforceReplayPrevention) {
        this.enforceReplayPrevention = enforceReplayPrevention;
    }

    public boolean isRequireSignedRequest() {
        return this.requireSignedRequest;
    }

    public void setRequireSignedRequest(boolean requireSignedRequest) {
        this.requireSignedRequest = requireSignedRequest;
    }

    public String getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(String persistentGrantExpirationType) {
        this.persistentGrantExpirationType = persistentGrantExpirationType;
    }

    public String getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(String persistentGrantExpirationTime) {
        this.persistentGrantExpirationTime = persistentGrantExpirationTime;
    }

    public String getSelectedPersistentGrantExpirationTimeUnit() {
        return this.selectedPersistentGrantExpirationTimeUnit;
    }

    public void setSelectedPersistentGrantExpirationTimeUnit(String selectedPersistentGrantExpirationTimeUnit) {
        this.selectedPersistentGrantExpirationTimeUnit = selectedPersistentGrantExpirationTimeUnit;
    }

    public StringPairPropertySelectionModel getPersistentGrantExpirationTimeUnitList() {
        return this.persistentGrantExpirationTimeUnitList;
    }

    public void setPersistentGrantExpirationTimeUnitList(StringPairPropertySelectionModel persistentGrantExpirationTimeUnitList) {
        this.persistentGrantExpirationTimeUnitList = persistentGrantExpirationTimeUnitList;
    }

    public String getPersistentGrantIdleTimeoutType() {
        return this.persistentGrantIdleTimeoutType;
    }

    public void setPersistentGrantIdleTimeoutType(String persistentGrantIdleTimeoutType) {
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
    }

    public String getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(String persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    public String getSelectedPersistentGrantIdleTimeoutTimeUnit() {
        return this.selectedPersistentGrantIdleTimeoutTimeUnit;
    }

    public void setSelectedPersistentGrantIdleTimeoutTimeUnit(String selectedPersistentGrantIdleTimeoutTimeUnit) {
        this.selectedPersistentGrantIdleTimeoutTimeUnit = selectedPersistentGrantIdleTimeoutTimeUnit;
    }

    public IPropertySelectionModel getPersistentGrantIdleTimeoutTimeUnitList() {
        return this.persistentGrantIdleTimeoutTimeUnitList;
    }

    public void setPersistentGrantIdleTimeoutTimeUnitList(StringPairPropertySelectionModel persistentGrantIdleTimeoutTimeUnitList) {
        this.persistentGrantIdleTimeoutTimeUnitList = persistentGrantIdleTimeoutTimeUnitList;
    }

    public String getSelectedIdTokenSigningAlgorithm() {
        return this.selectedIdTokenSigningAlgorithm;
    }

    public void setSelectedIdTokenSigningAlgorithm(String selectedIdTokenSigningAlgorithm) {
        this.selectedIdTokenSigningAlgorithm = selectedIdTokenSigningAlgorithm;
        this.toggleDisplayAlgorithmWarning();
    }

    public StringPairPropertySelectionModel getIdTokenSigningAlgorithmList() {
        return this.idTokenSigningAlgorithmList;
    }

    public void setIdTokenSigningAlgorithmList(StringPairPropertySelectionModel idTokenSigningAlgorithmList) {
        this.idTokenSigningAlgorithmList = idTokenSigningAlgorithmList;
    }

    public String getSelectedTokenManagerId() {
        return this.selectedTokenManagerId;
    }

    public void setSelectedTokenManagerId(String selectedTokenManagerId) {
        this.selectedTokenManagerId = selectedTokenManagerId;
    }

    public boolean isRestrictToDefaultAccessTokenManager() {
        return this.restrictToDefaultAccessTokenManager;
    }

    public void setRestrictToDefaultAccessTokenManager(boolean restrictToDefaultAccessTokenManager) {
        this.restrictToDefaultAccessTokenManager = restrictToDefaultAccessTokenManager;
    }

    public StringPairPropertySelectionModel getTokenManagerIdList() {
        return this.tokenManagerIdList;
    }

    public void setTokenManagerIdList(StringPairPropertySelectionModel tokenManagerIdList) {
        this.tokenManagerIdList = tokenManagerIdList;
    }

    public String getSelectedPolicyGroupId() {
        return this.selectedPolicyGroupId;
    }

    public void setSelectedPolicyGroupId(String selectedPolicyGroupId) {
        this.selectedPolicyGroupId = selectedPolicyGroupId;
    }

    public StringPairPropertySelectionModel getPolicyGroupIdList() {
        return this.policyGroupIdList;
    }

    public void setPolicyGroupIdList(StringPairPropertySelectionModel policyGroupIdList) {
        this.policyGroupIdList = policyGroupIdList;
    }

    public boolean isOverridePersistentGrantExpirationServerDefault() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantExpirationType);
    }

    public boolean isOverridePersistentGrantIdleTimeoutServerDefault() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantIdleTimeoutType);
    }

    public String getRolling() {
        return this.rolling;
    }

    public void setRolling(String rolling) {
        this.rolling = rolling;
    }

    public boolean isEnableOpenIdConnectIdp() {
        OpenIdConnectProviderPolicyManager connectProviderPolicyMgr = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return connectProviderPolicyMgr.getPolicy().isEnabled();
    }

    public boolean isEnableRetainClientSecret() {
        return this.enableRetainClientSecret;
    }

    public void setEnableRetainClientSecret(boolean enableRetainClientSecret) {
        this.enableRetainClientSecret = enableRetainClientSecret;
    }

    public String getClientSecretRetentionPeriodType() {
        return this.clientSecretRetentionPeriodType;
    }

    public void setClientSecretRetentionPeriodType(String clientSecretRetentionPeriodType) {
        this.clientSecretRetentionPeriodType = clientSecretRetentionPeriodType;
        ClientSecretRetentionPeriodType type = ClientSecretRetentionPeriodType.getType((String)clientSecretRetentionPeriodType);
        if (ClientSecretRetentionPeriodType.SERVER_DEFAULT.equals((Object)type)) {
            this.clientSecretRetentionPeriod = null;
        }
    }

    public String getClientSecretRetentionPeriod() {
        return this.clientSecretRetentionPeriod;
    }

    public void setClientSecretRetentionPeriod(String clientSecretRetentionPeriod) {
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
    }

    public boolean isOverrideClientSecretRetentionPeriodServerDefault() {
        ClientSecretRetentionPeriodType type = ClientSecretRetentionPeriodType.getType((String)this.clientSecretRetentionPeriodType);
        return ClientSecretRetentionPeriodType.OVERRIDE_SERVER_DEFAULT.equals((Object)type);
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.init();
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        this.enforceReplayPrevention = clientSetting.isEnforceReplayPrevention();
        this.rolling = clientSetting.getRefreshRolling() == null ? DEFAULT : clientSetting.getRefreshRolling();
        this.persistentGrantExpirationType = clientSetting.getPersistentGrantExpirationType() == null ? this.persistentGrantExpirationType : clientSetting.getPersistentGrantExpirationType();
        this.persistentGrantExpirationTime = clientSetting.getPersistentGrantExpirationTime() == null || clientSetting.getPersistentGrantExpirationTime() <= 0L ? this.persistentGrantExpirationTime : clientSetting.getPersistentGrantExpirationTime().toString();
        this.selectedPersistentGrantExpirationTimeUnit = clientSetting.getPersistentGrantExpirationTimeUnit();
        this.persistentGrantIdleTimeoutType = clientSetting.getPersistentGrantIdleTimeoutType() == null ? this.persistentGrantIdleTimeoutType : clientSetting.getPersistentGrantIdleTimeoutType();
        this.persistentGrantIdleTimeout = clientSetting.getPersistentGrantIdleTimeout() == null || clientSetting.getPersistentGrantIdleTimeout() <= 0L ? this.persistentGrantIdleTimeout : clientSetting.getPersistentGrantIdleTimeout().toString();
        this.selectedPersistentGrantIdleTimeoutTimeUnit = clientSetting.getPersistentGrantIdleTimeoutTimeUnit();
        this.setSelectedIdTokenSigningAlgorithm(clientSetting.getIdTokenSigningAlgorithm());
        this.selectedPolicyGroupId = clientSetting.getPolicyGroupId();
        this.requireSignedRequest = clientSetting.isRequireSignedRequests();
        this.selectedTokenManagerId = clientSetting.getDefaultAccessTokenManagerId();
        this.restrictToDefaultAccessTokenManager = clientSetting.isRestrictToDefaultAccessTokenManager();
        this.populateCertIssuer(clientSetting);
        this.deviceFlowSettingType = clientSetting.getDeviceFlowSettingType() != null ? clientSetting.getDeviceFlowSettingType() : "SERVER_DEFAULT";
        this.userAuthzUrlOverride = clientSetting.getUserAuthzUrlOverride();
        this.pendingAuthzTimeoutOverride = clientSetting.getPendingAuthzTimeoutOverride() != null ? String.valueOf(clientSetting.getPendingAuthzTimeoutOverride()) : null;
        this.devicePollingIntervalOverride = clientSetting.getDevicePollingIntervalOverride() != null ? String.valueOf(clientSetting.getDevicePollingIntervalOverride()) : null;
        this.bypassActivationCodeConfirmationOverride = clientSetting.getBypassActivationCodeConfirmationOverride();
        this.requireProofKeyForCodeExchange = clientSetting.isRequireProofKeyForCodeExchange();
        this.cibaRequireSignedRequests = clientSetting.isCibaRequireSignedRequests();
        this.cibaPolicyId = clientSetting.getCibaPolicyId();
        this.cibaPollingInterval = String.valueOf(clientSetting.getCibaPollingInterval());
        this.tokenExchangeProcessorPolicyId = clientSetting.getTokenExchangeProcessorPolicyId();
        this.refreshTokenRollingGracePeriodType = StringUtils.isNotBlank((String)clientSetting.getRefreshTokenRollingGracePeriodType()) ? clientSetting.getRefreshTokenRollingGracePeriodType() : "SERVER_DEFAULT";
        this.refreshTokenRollingGracePeriod = clientSetting.getRefreshTokenRollingGracePeriod() != null ? Integer.toString(clientSetting.getRefreshTokenRollingGracePeriod()) : null;
        this.populateRefreshTokenRollingInterval(clientSetting.getRefreshTokenRollingInterval(), clientSetting.getRefreshTokenRollingIntervalTimeUnit());
        this.enableRetainClientSecret = clientSetting.isRetainClientSecret();
        this.clientSecretRetentionPeriodType = StringUtils.isNotBlank((String)clientSetting.getClientSecretRetentionPeriodType()) ? clientSetting.getClientSecretRetentionPeriodType() : "SERVER_DEFAULT";
        this.clientSecretRetentionPeriod = clientSetting.getClientSecretRetentionPeriod() != null ? String.valueOf(clientSetting.getClientSecretRetentionPeriod()) : null;
        this.requireJwtSecuredAuthorizationResponseMode = clientSetting.getRequireJwtSecuredAuthorizationResponseMode();
        this.requireOfflineAccessScopeToIssueRefreshTokens = clientSetting.getRequireOfflineAccessScopeToIssueRefreshTokens();
        this.offlineAccessRequireConsentPrompt = clientSetting.getOfflineAccessRequireConsentPrompt();
        this.lockoutMaxMaliciousActionsType = StringUtils.isNotBlank((String)clientSetting.getLockoutMaxMaliciousActionsType()) ? clientSetting.getLockoutMaxMaliciousActionsType() : "SERVER_DEFAULT";
        this.lockoutMaxMaliciousActions = clientSetting.getLockoutMaxMaliciousActions() != null ? Integer.toString(clientSetting.getLockoutMaxMaliciousActions()) : null;
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    @Override
    public void onStateActivated() {
        this.enableRetainClientSecret = this.clientSettingManager.getClientSetting().isRetainClientSecret();
    }

    private void populateCertIssuer(ClientSetting clientSetting) {
        if ("Trust Any".equals(clientSetting.getClientCertIssuerDn())) {
            this.clientCertIssuer = this.trustAllDummyCert;
        } else {
            for (Cert cert : this.trustedCAs) {
                String trustedCASubjectDN = cert.getX509Certificate().getSubjectDN().getName();
                if (!trustedCASubjectDN.equals(clientSetting.getClientCertIssuerDn())) continue;
                this.clientCertIssuer = cert;
                break;
            }
        }
    }

    public void fillDomain(ClientSetting clientSetting) {
        clientSetting.setEnforceReplayPrevention(this.enforceReplayPrevention);
        if (!DEFAULT.equals(this.rolling)) {
            clientSetting.setRefreshRolling(this.rolling);
        } else {
            clientSetting.setRefreshRolling(null);
        }
        clientSetting.setPersistentGrantExpirationType(this.persistentGrantExpirationType);
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantExpirationType)) {
            clientSetting.setPersistentGrantExpirationTime(Long.valueOf(StringUtils.isEmpty((String)this.persistentGrantExpirationTime) || !ValidationUtil.isValidLong((String)this.persistentGrantExpirationTime) ? -1L : Long.parseLong(this.persistentGrantExpirationTime)));
            clientSetting.setPersistentGrantExpirationTimeUnit(this.selectedPersistentGrantExpirationTimeUnit == null ? "d" : this.selectedPersistentGrantExpirationTimeUnit);
        }
        clientSetting.setPersistentGrantIdleTimeoutType(this.persistentGrantIdleTimeoutType);
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.persistentGrantIdleTimeoutType)) {
            clientSetting.setPersistentGrantIdleTimeout(Long.valueOf(StringUtils.isEmpty((String)this.persistentGrantIdleTimeout) || !ValidationUtil.isValidLong((String)this.persistentGrantIdleTimeout) ? -1L : Long.parseLong(this.persistentGrantIdleTimeout)));
            clientSetting.setPersistentGrantIdleTimeoutTimeUnit(this.selectedPersistentGrantIdleTimeoutTimeUnit == null ? "d" : this.selectedPersistentGrantIdleTimeoutTimeUnit);
        }
        clientSetting.setPolicyGroupId(this.selectedPolicyGroupId);
        clientSetting.setIdTokenSigningAlgorithm(this.selectedIdTokenSigningAlgorithm);
        clientSetting.setRequireSignedRequests(this.requireSignedRequest);
        clientSetting.setDefaultAccessTokenManagerId(this.selectedTokenManagerId);
        clientSetting.setRestrictToDefaultAccessTokenManager(this.restrictToDefaultAccessTokenManager);
        clientSetting.setClientCertIssuerDn(this.getClientCertIssuerDN());
        clientSetting.setDeviceFlowSettingType(this.deviceFlowSettingType);
        clientSetting.setUserAuthzUrlOverride(this.userAuthzUrlOverride);
        clientSetting.setPendingAuthzTimeoutOverride(StringUtils.isNotBlank((String)this.pendingAuthzTimeoutOverride) ? Integer.valueOf(Integer.parseInt(this.pendingAuthzTimeoutOverride)) : null);
        clientSetting.setDevicePollingIntervalOverride(StringUtils.isNotBlank((String)this.devicePollingIntervalOverride) ? Integer.valueOf(Integer.parseInt(this.devicePollingIntervalOverride)) : null);
        clientSetting.setBypassActivationCodeConfirmationOverride(this.bypassActivationCodeConfirmationOverride);
        clientSetting.setRequireProofKeyForCodeExchange(this.requireProofKeyForCodeExchange);
        clientSetting.setCibaRequireSignedRequests(this.cibaRequireSignedRequests);
        clientSetting.setCibaPolicyId(this.cibaPolicyId);
        if (StringUtils.isNotBlank((String)this.cibaPollingInterval)) {
            clientSetting.setCibaPollingInterval(Integer.parseInt(this.cibaPollingInterval));
        }
        clientSetting.setTokenExchangeProcessorPolicyId(this.tokenExchangeProcessorPolicyId);
        clientSetting.setRefreshTokenRollingGracePeriodType(this.refreshTokenRollingGracePeriodType);
        if ("SERVER_DEFAULT".equals(this.refreshTokenRollingGracePeriodType)) {
            clientSetting.setRefreshTokenRollingGracePeriod(null);
        } else if (StringUtils.isNotBlank((String)this.refreshTokenRollingGracePeriod)) {
            clientSetting.setRefreshTokenRollingGracePeriod(Integer.valueOf(Integer.parseInt(this.refreshTokenRollingGracePeriod)));
        }
        clientSetting.setClientSecretRetentionPeriodType(this.clientSecretRetentionPeriodType);
        clientSetting.setClientSecretRetentionPeriod(StringUtils.isNotBlank((String)this.clientSecretRetentionPeriod) ? Integer.valueOf(Integer.parseInt(this.clientSecretRetentionPeriod)) : null);
        clientSetting.setRequireJwtSecuredAuthorizationResponseMode(Boolean.valueOf(this.requireJwtSecuredAuthorizationResponseMode));
        this.fillDomainRefreshTokenRolling(clientSetting);
        clientSetting.setRequireOfflineAccessScopeToIssueRefreshTokens(this.requireOfflineAccessScopeToIssueRefreshTokens);
        clientSetting.setOfflineAccessRequireConsentPrompt(this.offlineAccessRequireConsentPrompt);
        clientSetting.setLockoutMaxMaliciousActionsType(this.lockoutMaxMaliciousActionsType);
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.lockoutMaxMaliciousActionsType)) {
            clientSetting.setLockoutMaxMaliciousActions(StringUtils.isNotBlank((String)this.lockoutMaxMaliciousActions) ? Integer.valueOf(Integer.parseInt(this.lockoutMaxMaliciousActions)) : null);
        } else {
            this.lockoutMaxMaliciousActions = null;
            clientSetting.setLockoutMaxMaliciousActions(null);
        }
    }

    @Override
    protected void fillDomainRefreshTokenRolling(Object clientSettingObject) {
        ClientSetting clientSetting = (ClientSetting)clientSettingObject;
        String rollingIntervalType = this.getRefreshRollingIntervalType();
        if (rollingIntervalType == null || "SERVER_DEFAULT".equals(rollingIntervalType)) {
            clientSetting.setRefreshTokenRollingIntervalType("SERVER_DEFAULT");
            clientSetting.setRefreshTokenRollingInterval(null);
            clientSetting.setRefreshTokenRollingIntervalTimeUnit(null);
        } else if ("OVERRIDE_SERVER_DEFAULT".equals(rollingIntervalType)) {
            clientSetting.setRefreshTokenRollingIntervalType("OVERRIDE_SERVER_DEFAULT");
            if (this.getRefreshRollingInterval() != null) {
                clientSetting.setRefreshTokenRollingInterval(Long.valueOf(Long.parseLong(this.getRefreshRollingInterval())));
                clientSetting.setRefreshTokenRollingIntervalTimeUnit(this.getSelectedRefreshRollingIntervalTimeUnit());
            }
        }
    }

    private String getClientCertIssuerDN() {
        if (this.clientCertIssuer != null) {
            if ("Trust Any".equals(this.clientCertIssuer.getAlias())) {
                return "Trust Any";
            }
            return this.clientCertIssuer.getX509Certificate().getSubjectDN().getName();
        }
        return null;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ClientSetting clientSetting = (ClientSetting)dataToDisk;
        if (this.getParentTasklet().getOAuthDynamicClientRegistrationState().isEnableDynamicClientRegistration()) {
            this.fillDomain(clientSetting);
        } else {
            this.clearDefaultSetting(clientSetting);
        }
        return true;
    }

    private void clearDefaultSetting(ClientSetting clientSetting) {
        clientSetting.setEnforceReplayPrevention(false);
        clientSetting.setIdTokenSigningAlgorithm(null);
        clientSetting.setPolicyGroupId(null);
        clientSetting.setIdTokenSigningAlgorithm(null);
        clientSetting.setDefaultAccessTokenManagerId(null);
        clientSetting.setRefreshRolling(null);
        clientSetting.setPersistentGrantExpirationTime(null);
        clientSetting.setPersistentGrantExpirationTimeUnit(null);
        clientSetting.setPersistentGrantExpirationType("SERVER_DEFAULT");
        clientSetting.setPersistentGrantIdleTimeout(null);
        clientSetting.setPersistentGrantIdleTimeoutTimeUnit(null);
        clientSetting.setPersistentGrantIdleTimeoutType("SERVER_DEFAULT");
        clientSetting.setRequireSignedRequests(false);
        clientSetting.setClientCertIssuerDn(null);
        clientSetting.setDeviceFlowSettingType("SERVER_DEFAULT");
        clientSetting.setUserAuthzUrlOverride(null);
        clientSetting.setPendingAuthzTimeoutOverride(null);
        clientSetting.setDevicePollingIntervalOverride(null);
        clientSetting.setRequireProofKeyForCodeExchange(false);
        clientSetting.setCibaRequireSignedRequests(false);
        clientSetting.setCibaPolicyId(null);
        clientSetting.setCibaPollingInterval(3);
        clientSetting.setTokenExchangeProcessorPolicyId(null);
        clientSetting.setRefreshTokenRollingGracePeriodType("SERVER_DEFAULT");
        clientSetting.setRefreshTokenRollingGracePeriod(null);
        clientSetting.setClientSecretRetentionPeriodType("SERVER_DEFAULT");
        clientSetting.setClientSecretRetentionPeriod(null);
        clientSetting.setRequireOfflineAccessScopeToIssueRefreshTokens("SERVER_DEFAULT");
        clientSetting.setLockoutMaxMaliciousActionsType("SERVER_DEFAULT");
        clientSetting.setLockoutMaxMaliciousActions(null);
    }

    private OAuthClientTasklet getParentTasklet() {
        return (OAuthClientTasklet)this.getParent();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        OAuthClientDefaultsValidator.GrantExpirationValidator grantExpirationValidator = new OAuthClientDefaultsValidator.GrantExpirationValidator(this.getPersistentGrantExpirationType(), Long.valueOf(NumberUtils.toLong((String)this.getPersistentGrantExpirationTime(), (long)-1L)));
        grantExpirationValidator.validate();
        this.recordErrors(grantExpirationValidator.getErrors(), delegate);
        OAuthClientDefaultsValidator.GrantIdleTimeoutValidator grantIdleTimeoutValidator = new OAuthClientDefaultsValidator.GrantIdleTimeoutValidator(this.getPersistentGrantIdleTimeoutType(), Long.valueOf(NumberUtils.toLong((String)this.getPersistentGrantIdleTimeout(), (long)-1L)));
        grantIdleTimeoutValidator.validate();
        this.recordErrors(grantIdleTimeoutValidator.getErrors(), delegate);
        if (PersistentGrantLifetimeHelper.isInvalidLocalIdleTimeoutSetting((String)this.persistentGrantExpirationType, (String)this.persistentGrantExpirationTime, (String)this.selectedPersistentGrantExpirationTimeUnit, (String)this.persistentGrantIdleTimeoutType, (String)this.persistentGrantIdleTimeout, (String)this.selectedPersistentGrantIdleTimeoutTimeUnit)) {
            if ("SERVER_DEFAULT".equals(this.persistentGrantExpirationType)) {
                this.recordErrors(Collections.singletonList(ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.oauth_client_mgmt_grant_idle_timeout_greater_than_global_max_lifetime, ClientSettingsPaths.getDefaultAccessTokenManager())), delegate);
            } else {
                this.recordErrors(Collections.singletonList(ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.oauth_client_mgmt_grant_idle_timeout_greater_than_max_lifetime, ClientSettingsPaths.getDefaultAccessTokenManager())), delegate);
            }
        }
        OAuthClientDefaultsValidator.DeviceFlowFieldsValidator deviceFlowFieldsValidator = new OAuthClientDefaultsValidator.DeviceFlowFieldsValidator(this.deviceFlowSettingType, this.userAuthzUrlOverride, this.pendingAuthzTimeoutOverride, this.devicePollingIntervalOverride, this.bypassActivationCodeConfirmationOverride);
        deviceFlowFieldsValidator.validate();
        this.recordErrors(deviceFlowFieldsValidator.getErrors(), delegate);
        CIBADefaultsValidator cibaDefaultsValidator = new CIBADefaultsValidator(this.cibaPollingInterval);
        cibaDefaultsValidator.validate();
        this.recordErrors(cibaDefaultsValidator.getErrors(), delegate);
        OAuthClientDefaultsValidator.TokenExchangeSettingsValidator tokenExchangeSettingsValidator = new OAuthClientDefaultsValidator.TokenExchangeSettingsValidator(this.tokenExchangeProcessorPolicyId);
        tokenExchangeSettingsValidator.validate();
        this.recordErrors(tokenExchangeSettingsValidator.getErrors(), delegate);
        RefreshTokenRollingGracePeriodValidator refreshTokenRollingGracePeriodValidator = RefreshTokenRollingGracePeriodValidator.newClientSettingsInstance((String)this.refreshTokenRollingGracePeriodType, (String)this.refreshTokenRollingGracePeriod);
        refreshTokenRollingGracePeriodValidator.validate();
        this.recordErrors(refreshTokenRollingGracePeriodValidator.getErrors(), delegate);
        boolean validateRefreshTokenIntervalNumber = this.validateRefreshTokenIntervalNumber(delegate);
        if (validateRefreshTokenIntervalNumber) {
            RefreshTokenRollingIntervalValidator refreshTokenRollingIntervalValidator = this.getRefreshTokenRollingIntervalValidator();
            this.recordErrors(refreshTokenRollingIntervalValidator.getErrors(), delegate);
        }
        ClientSecretRetentionPeriodValidator clientSecretRetentionPeriodValidator = new ClientSecretRetentionPeriodValidator(this.clientSecretRetentionPeriodType, this.clientSecretRetentionPeriod);
        clientSecretRetentionPeriodValidator.validate();
        this.recordErrors(clientSecretRetentionPeriodValidator.getErrors(), delegate);
        ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator clientRequireOfflineAccessScopeToIssueRefreshTokensValidator = this.getClientRequireOfflineAccessScopeToIssueRefreshTokensValidator();
        this.recordErrors(clientRequireOfflineAccessScopeToIssueRefreshTokensValidator.getErrors(), delegate);
        String offlineAccessRequireConsentPromptPath = ClientSettingsPaths.getOfflineAccessRequireConsentPromptPath();
        ClientOfflineAccessRequireConsentPromptValidator clientOfflineAccessRequireConsentPromptValidator = new ClientOfflineAccessRequireConsentPromptValidator(this.offlineAccessRequireConsentPrompt, offlineAccessRequireConsentPromptPath);
        clientOfflineAccessRequireConsentPromptValidator.validate();
        this.recordErrors(clientOfflineAccessRequireConsentPromptValidator.getErrors(), delegate);
        String lockoutMaxMaliciousActionsTypePath = ClientSettingsPaths.getLockoutMaxMaliciousActionsTypePath();
        String lockoutMaxMaliciousActionsPath = ClientSettingsPaths.getLockoutMaxMaliciousActionsPath();
        LockoutMaxMaliciousActionsValidator clientLockoutMaxMaliciousActionsValidator = LockoutMaxMaliciousActionsValidator.newClientSettingsInstance((String)this.lockoutMaxMaliciousActionsType, (String)this.lockoutMaxMaliciousActions, (String)lockoutMaxMaliciousActionsTypePath, (String)lockoutMaxMaliciousActionsPath);
        clientLockoutMaxMaliciousActionsValidator.validate();
        this.recordErrors(clientLockoutMaxMaliciousActionsValidator.getErrors(), delegate);
    }

    private ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator getClientRequireOfflineAccessScopeToIssueRefreshTokensValidator() {
        String requireOfflineAccessScopeToIssueRefreshTokensPath = ClientSettingsPaths.getRequireOfflineAccessScopeToIssueRefreshTokensPath();
        ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator clientRequireOfflineAccessScopeToIssueRefreshTokensValidator = new ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator(this.requireOfflineAccessScopeToIssueRefreshTokens, requireOfflineAccessScopeToIssueRefreshTokensPath);
        clientRequireOfflineAccessScopeToIssueRefreshTokensValidator.validate();
        return clientRequireOfflineAccessScopeToIssueRefreshTokensValidator;
    }

    private RefreshTokenRollingIntervalValidator getRefreshTokenRollingIntervalValidator() {
        Long refreshTokenRollingInterval = this.getRefreshRollingInterval() != null ? Long.valueOf(Long.parseLong(this.getRefreshRollingInterval())) : null;
        RefreshTokenRollingIntervalValidator refreshTokenRollingIntervalValidator = new RefreshTokenRollingIntervalValidator(this.getRefreshRollingIntervalType(), refreshTokenRollingInterval, this.getSelectedRefreshRollingIntervalTimeUnit());
        refreshTokenRollingIntervalValidator.validate();
        return refreshTokenRollingIntervalValidator;
    }

    private void toggleDisplayAlgorithmWarning() {
        this.displayAlgorithmWarning = StringUtils.isNotBlank((String)this.selectedIdTokenSigningAlgorithm) && OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().get(this.selectedIdTokenSigningAlgorithm) == null;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String certIssuerDN;
        ClientSetting temp = new ClientSetting();
        this.fillDomain(temp);
        summaryList.add(new SummaryInfo("Private Key JWT - Replay Prevention", Boolean.toString(temp.isEnforceReplayPrevention()), this));
        summaryList.add(new SummaryInfo("Require Signed Requests", Boolean.toString(temp.isRequireSignedRequests()), this));
        summaryList.add(new SummaryInfo("Default Access Token Manager", StringUtils.isNotEmpty((String)temp.getDefaultAccessTokenManagerId()) ? this.getTokenManagerIdList().getDescription(temp.getDefaultAccessTokenManagerId()) : DEFAULT_LABEL, this));
        summaryList.add(new SummaryInfo("Restrict to Default Access Token Manager", Boolean.toString(temp.isRestrictToDefaultAccessTokenManager()), this));
        summaryList.add(new SummaryInfo("Persistent Grant Max Lifetime Setting", this.getPersistentGrantExpirationSettingTypeLabel(temp.getPersistentGrantExpirationType()), this));
        if (temp.getPersistentGrantExpirationTime() != null && temp.getPersistentGrantExpirationTime() > 0L) {
            summaryList.add(new SummaryInfo("Persistent Grant Max Lifetime", temp.getPersistentGrantExpirationTime() + " " + this.persistentGrantExpirationTimeUnitList.getDescription(temp.getPersistentGrantExpirationTimeUnit()), this));
        }
        summaryList.add(new SummaryInfo("Persistent Grant Idle Timeout Setting", this.getPersistentGrantIdleTimeoutSettingTypeLabel(temp.getPersistentGrantIdleTimeoutType()), this));
        if (temp.getPersistentGrantIdleTimeout() != null && temp.getPersistentGrantIdleTimeout() > 0L) {
            summaryList.add(new SummaryInfo("Persistent Grant Idle Timeout", temp.getPersistentGrantIdleTimeout() + " " + this.persistentGrantIdleTimeoutTimeUnitList.getDescription(temp.getPersistentGrantIdleTimeoutTimeUnit()), this));
        }
        summaryList.add(new SummaryInfo("Client Authentication Certificate Issuer DN", (certIssuerDN = this.getClientCertIssuerDN()) == null ? DEFAULT_CERT_ISSUER : certIssuerDN, this));
        summaryList.add(new SummaryInfo("Refresh Token Rolling Policy", this.getRefreshRollingLabel(temp.getRefreshRolling()), this));
        summaryList.add(new SummaryInfo("Refresh Token Rolling Interval Type", temp.getRefreshTokenRollingIntervalType() == null ? "SERVER_DEFAULT" : temp.getRefreshTokenRollingIntervalType(), this));
        summaryList.add(new SummaryInfo("Refresh Token Rolling Interval", (String)(temp.getRefreshTokenRollingInterval() == null ? " " : temp.getRefreshTokenRollingInterval() + this.getRefreshRollingIntervalTimeUnitList().getDescription(temp.getRefreshTokenRollingIntervalTimeUnit())), this));
        summaryList.add(new SummaryInfo("Refresh Token Rolling Grace Period Type", temp.getRefreshTokenRollingGracePeriodType() == null ? "SERVER_DEFAULT" : temp.getRefreshTokenRollingGracePeriodType(), this));
        summaryList.add(new SummaryInfo("Refresh Token Rolling Grace Period", temp.getRefreshTokenRollingGracePeriod() == null ? " " : Integer.toString(temp.getRefreshTokenRollingGracePeriod()), this));
        summaryList.add(new SummaryInfo("ID Token Signing Algorithm", StringUtils.isNotEmpty((String)temp.getIdTokenSigningAlgorithm()) ? this.idTokenSigningAlgorithmList.getDescription(temp.getIdTokenSigningAlgorithm()) : DEFAULT_LABEL, this));
        summaryList.add(new SummaryInfo("Policy", StringUtils.isNotEmpty((String)temp.getPolicyGroupId()) ? this.policyGroupIdList.getDescription(temp.getPolicyGroupId()) : DEFAULT_LABEL, this));
        boolean isDeviceFlowSettingsGlobal = "SERVER_DEFAULT".equals(this.deviceFlowSettingType);
        summaryList.add(new SummaryInfo("Device Flow Settings", isDeviceFlowSettingsGlobal ? "Use Global Settings" : "Override", this));
        if (!isDeviceFlowSettingsGlobal && StringUtils.isNotBlank((String)this.userAuthzUrlOverride)) {
            summaryList.add(new SummaryInfo("User Authorization URL", this.userAuthzUrlOverride, this));
        }
        if (!isDeviceFlowSettingsGlobal && StringUtils.isNotBlank((String)this.pendingAuthzTimeoutOverride)) {
            summaryList.add(new SummaryInfo("Pending Authorization Timeout", this.pendingAuthzTimeoutOverride, this));
        }
        if (!isDeviceFlowSettingsGlobal && StringUtils.isNotBlank((String)this.devicePollingIntervalOverride)) {
            summaryList.add(new SummaryInfo("Device Polling Interval", this.devicePollingIntervalOverride, this));
        }
        if (!isDeviceFlowSettingsGlobal && this.bypassActivationCodeConfirmationOverride != null) {
            summaryList.add(new SummaryInfo("Bypass Activation Code Confirmation", String.valueOf(this.bypassActivationCodeConfirmationOverride), this));
        }
        summaryList.add(new SummaryInfo("Require Proof Key For Code Exchange (PKCE)", String.valueOf(this.requireProofKeyForCodeExchange), this));
        summaryList.add(new SummaryInfo("CIBA Polling Interval", String.valueOf(this.cibaPollingInterval), this));
        summaryList.add(new SummaryInfo("CIBA Require Signed Requests", Boolean.toString(this.cibaRequireSignedRequests), this));
        summaryList.add(new SummaryInfo("CIBA Policy", StringUtils.isNotEmpty((String)temp.getCibaPolicyId()) ? this.cibaPolicyIdList.getDescription(temp.getCibaPolicyId()) : DEFAULT_LABEL, this));
        summaryList.add(new SummaryInfo("Token Exchange Processor Policy", StringUtils.isNotEmpty((String)temp.getTokenExchangeProcessorPolicyId()) ? this.tokenExchangeProcessorPolicyIdList.getDescription(temp.getTokenExchangeProcessorPolicyId()) : DEFAULT_LABEL, this));
        summaryList.add(new SummaryInfo("Lockout Max Malicious Actions Type", temp.getLockoutMaxMaliciousActionsType() == null ? "SERVER_DEFAULT" : temp.getLockoutMaxMaliciousActionsType(), this));
        summaryList.add(new SummaryInfo("Lockout Max Malicious Actions Count", temp.getLockoutMaxMaliciousActions() == null ? " " : Integer.toString(temp.getLockoutMaxMaliciousActions()), this));
    }

    private String getRefreshRollingLabel(String refreshRolling) {
        if (refreshRolling == null || refreshRolling.equalsIgnoreCase(DEFAULT)) {
            return USE_GLOBAL_SETTING;
        }
        if (refreshRolling.equalsIgnoreCase("false")) {
            return "Don't Roll";
        }
        if (refreshRolling.equalsIgnoreCase("true")) {
            return "Roll";
        }
        return "";
    }

    private String getPersistentGrantExpirationSettingTypeLabel(String persistentGrantExpirationType) {
        switch (persistentGrantExpirationType) {
            case "SERVER_DEFAULT": {
                return USE_GLOBAL_SETTING;
            }
            case "NONE": {
                return "Grants Do Not Expire";
            }
            case "OVERRIDE_SERVER_DEFAULT": {
                return "Override Server Default";
            }
        }
        return null;
    }

    private String getPersistentGrantIdleTimeoutSettingTypeLabel(String persistentGrantExpirationType) {
        switch (persistentGrantExpirationType) {
            case "SERVER_DEFAULT": {
                return USE_GLOBAL_SETTING;
            }
            case "NONE": {
                return "Grants Do Not Timeout Due To Inactivity";
            }
            case "OVERRIDE_SERVER_DEFAULT": {
                return "Override Server Default";
            }
        }
        return null;
    }

    public IPropertySelectionModel getClientCertIssuers() {
        Set trustedCAs = MgmtFactory.getTrustedCAsManager().getTrustedCAs();
        StringPairPropertySelectionModel clientCertIssuerList = new StringPairPropertySelectionModel(DEFAULT_CERT_ISSUER);
        if (!trustedCAs.isEmpty()) {
            clientCertIssuerList.add("Trust Any", this.trustAllDummyCert);
        }
        for (Cert cert : trustedCAs) {
            clientCertIssuerList.add(cert.getDescriptionForDisplay(35), cert);
        }
        return clientCertIssuerList;
    }

    public Cert getClientCertIssuer() {
        return this.clientCertIssuer;
    }

    public void setClientCertIssuer(Cert clientCertIssuer) {
        this.clientCertIssuer = clientCertIssuer;
    }

    public boolean isDisplayAlgorithmWarning() {
        return this.displayAlgorithmWarning;
    }

    public void setDisplayAlgorithmWarning(boolean displayAlgorithmWarning) {
        this.displayAlgorithmWarning = displayAlgorithmWarning;
    }

    public boolean isDeviceFlowSettingsOverride() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.deviceFlowSettingType);
    }

    public String getDeviceFlowSettingType() {
        return this.deviceFlowSettingType;
    }

    public void setDeviceFlowSettingType(String deviceFlowSettingType) {
        this.deviceFlowSettingType = deviceFlowSettingType;
    }

    public String getUserAuthzUrlOverride() {
        return this.userAuthzUrlOverride;
    }

    public void setUserAuthzUrlOverride(String userAuthzUrlOverride) {
        this.userAuthzUrlOverride = userAuthzUrlOverride;
    }

    public String getPendingAuthzTimeoutOverride() {
        return this.pendingAuthzTimeoutOverride;
    }

    public void setPendingAuthzTimeoutOverride(String pendingAuthzTimeoutOverride) {
        this.pendingAuthzTimeoutOverride = pendingAuthzTimeoutOverride;
    }

    public String getDevicePollingIntervalOverride() {
        return this.devicePollingIntervalOverride;
    }

    public void setDevicePollingIntervalOverride(String devicePollingIntervalOverride) {
        this.devicePollingIntervalOverride = devicePollingIntervalOverride;
    }

    public Boolean getBypassActivationCodeConfirmationOverride() {
        return this.bypassActivationCodeConfirmationOverride;
    }

    public void setBypassActivationCodeConfirmationOverride(Boolean bypassActivationCodeConfirmationOverride) {
        this.bypassActivationCodeConfirmationOverride = bypassActivationCodeConfirmationOverride;
    }

    public boolean isRequireProofKeyForCodeExchange() {
        return this.requireProofKeyForCodeExchange;
    }

    public void setRequireProofKeyForCodeExchange(boolean requireProofKeyForCodeExchange) {
        this.requireProofKeyForCodeExchange = requireProofKeyForCodeExchange;
    }

    public boolean isCibaRequireSignedRequests() {
        return this.cibaRequireSignedRequests;
    }

    public void setCibaRequireSignedRequests(boolean cibaRequireSignedRequests) {
        this.cibaRequireSignedRequests = cibaRequireSignedRequests;
    }

    private void createCibaPolicyIdList() {
        this.cibaPolicyIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        CibaServerPolicy policy = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy();
        for (CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy : policy.getRequestHandlingPolicies().values()) {
            this.cibaPolicyIdList.add(requestHandlingPolicy.getName(), requestHandlingPolicy.getId());
        }
    }

    public StringPairPropertySelectionModel getCibaPolicyIdList() {
        return this.cibaPolicyIdList;
    }

    public String getCibaPolicyId() {
        return this.cibaPolicyId;
    }

    public void setCibaPolicyId(String cibaPolicyId) {
        this.cibaPolicyId = cibaPolicyId;
    }

    public String getCibaPollingInterval() {
        return this.cibaPollingInterval;
    }

    public void setCibaPollingInterval(String cibaPollingInterval) {
        this.cibaPollingInterval = cibaPollingInterval;
    }

    public String getTokenExchangeProcessorPolicyId() {
        return this.tokenExchangeProcessorPolicyId;
    }

    public void setTokenExchangeProcessorPolicyId(String tokenExchangeProcessorPolicyId) {
        this.tokenExchangeProcessorPolicyId = tokenExchangeProcessorPolicyId;
    }

    public StringPairPropertySelectionModel getTokenExchangeProcessorPolicyIdList() {
        return this.tokenExchangeProcessorPolicyIdList;
    }

    private void createTokenExchangeProcessorPolicyIdList() {
        this.tokenExchangeProcessorPolicyIdList = new StringPairPropertySelectionModel(DEFAULT_LABEL);
        TokenExchangeProcessorPolicies instances = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies();
        for (TokenExchangeProcessorPolicy policy : instances.getPolicies().values()) {
            this.tokenExchangeProcessorPolicyIdList.add(policy.getName(), policy.getId());
        }
    }

    public String getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(String refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    public String getRefreshTokenRollingGracePeriodType() {
        return this.refreshTokenRollingGracePeriodType;
    }

    public void setRefreshTokenRollingGracePeriodType(String refreshTokenRollingGracePeriodType) {
        this.refreshTokenRollingGracePeriodType = refreshTokenRollingGracePeriodType;
    }

    public boolean isDefaultRefreshTokenRollingGracePeriod() {
        return "SERVER_DEFAULT".equals(this.refreshTokenRollingGracePeriodType);
    }

    public boolean isRequireJwtSecuredAuthorizationResponseMode() {
        return this.requireJwtSecuredAuthorizationResponseMode;
    }

    public void setRequireJwtSecuredAuthorizationResponseMode(boolean requireJwtSecuredAuthorizationResponseMode) {
        this.requireJwtSecuredAuthorizationResponseMode = requireJwtSecuredAuthorizationResponseMode;
    }

    public String getRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(String requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public boolean isRequireOfflineAccessScopeToIssueRefreshTokensValueYes() {
        return "Yes".equals(this.requireOfflineAccessScopeToIssueRefreshTokens);
    }

    public String getOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(String offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }

    public String getLockoutMaxMaliciousActionsType() {
        return this.lockoutMaxMaliciousActionsType;
    }

    public void setLockoutMaxMaliciousActionsType(String lockoutMaxMaliciousActionsType) {
        this.lockoutMaxMaliciousActionsType = lockoutMaxMaliciousActionsType;
    }

    public boolean isOverrideLockoutMaxMaliciousActionsServerDefault() {
        return "OVERRIDE_SERVER_DEFAULT".equals(this.lockoutMaxMaliciousActionsType);
    }

    public String getLockoutMaxMaliciousActions() {
        return this.lockoutMaxMaliciousActions;
    }

    public void setLockoutMaxMaliciousActions(String lockoutMaxMaliciousActions) {
        this.lockoutMaxMaliciousActions = lockoutMaxMaliciousActions;
    }
}

