/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.OAuthClientTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthDynamicClientRegistrationPoliciesState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 2017082401L;
    private String selectedPolicy;
    private List<PolicyItem> policies = new ArrayList<PolicyItem>();
    private final transient ClientSettingManager clientSettingManager;

    public OAuthDynamicClientRegistrationPoliciesState(IWizard owner, ClientSettingManager clientSettingManager) {
        super(owner);
        this.setMenuName("Client Registration Policies");
        this.clientSettingManager = clientSettingManager;
    }

    public List<PolicyItem> getPolicies() {
        return this.policies;
    }

    public String getSelectedPolicy() {
        return this.selectedPolicy;
    }

    public void setSelectedPolicy(String selectedPolicy) {
        this.selectedPolicy = selectedPolicy;
    }

    public StringPairPropertySelectionModel getActivePolicyList() {
        StringPairPropertySelectionModel activePolicyList = new StringPairPropertySelectionModel(true);
        activePolicyList.addAll(MgmtFactory.getOAuthDynamicClientRegistrationPluginManager().getInstances().stream().map(PolicyItem::new).filter(instance -> !this.policies.contains(instance)).map(this.toSPair()).sorted(StringPairPropertySelectionModel.SPair.ID_COMPARATOR).collect(Collectors.toList()));
        return activePolicyList;
    }

    private Function<NameValuePair, StringPairPropertySelectionModel.SPair> toSPair() {
        return nameValuePair -> new StringPairPropertySelectionModel.SPair(nameValuePair.getValue(), nameValuePair.getName());
    }

    private PolicyItem policyIdToNameValuePair(String policyId) {
        if (StringUtils.isBlank((String)policyId)) {
            return null;
        }
        return MgmtFactory.getOAuthDynamicClientRegistrationPluginManager().getInstances().stream().filter(i -> i.getId().equals(policyId)).findFirst().map(PolicyItem::new).orElse(null);
    }

    public void moveUp(int index) {
        if (index > 0) {
            PolicyItem item = this.policies.get(index);
            this.policies.set(index, this.policies.get(index - 1));
            this.policies.set(index - 1, item);
        }
    }

    public void moveDown(int index) {
        if (index < this.policies.size() - 1) {
            PolicyItem item = this.policies.get(index);
            this.policies.set(index, this.policies.get(index + 1));
            this.policies.set(index + 1, item);
        }
    }

    public void delete(int index) {
        if (index >= 0 || index < this.policies.size() - 1) {
            PolicyItem item;
            item.setMarkedForDelete(!(item = this.policies.get(index)).isMarkedForDelete());
            this.policies.set(index, item);
        }
    }

    public void add() {
        Optional<PolicyItem> selectedValue = MgmtFactory.getOAuthDynamicClientRegistrationPluginManager().getInstances().stream().map(PolicyItem::new).filter(nameValuePair -> nameValuePair.getName().equals(this.selectedPolicy)).findFirst();
        if (selectedValue.isPresent() && !this.policies.contains((Object)selectedValue.get())) {
            this.policies.add(selectedValue.get());
        } else {
            this.recordErrorMsg(this.getMessage("Common", "client_registration_policy_not_selected"));
        }
        this.selectedPolicy = null;
    }

    @Override
    public boolean populateAllStates(Object data) {
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        this.policies = clientSetting.getPolicyPlugins().stream().map(this::policyIdToNameValuePair).collect(Collectors.toList());
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    private OAuthClientTasklet getParentTasklet() {
        return (OAuthClientTasklet)this.getParent();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            if (this.getParentTasklet().getOAuthDynamicClientRegistrationState().isEnableDynamicClientRegistration()) {
                ClientSetting clientSetting = (ClientSetting)dataToDisk;
                List policyPluginIds = this.policies.stream().filter(nameValuePair -> !nameValuePair.isMarkedForDelete()).map(NameValuePair::getName).collect(Collectors.toList());
                clientSetting.setPolicyPlugins(policyPluginIds);
            } else {
                ClientSetting clientSetting = (ClientSetting)dataToDisk;
                clientSetting.setPolicyPlugins(Collections.emptyList());
            }
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        List summaryInfos = this.policies.stream().map(nameValuePair -> new SummaryInfo(nameValuePair.getPolicyType(), nameValuePair.getValue(), this)).collect(Collectors.toList());
        summaryList.addAll(summaryInfos);
    }

    public static class PolicyItem
    extends NameValuePair {
        private String policyType;

        public PolicyItem(ConfigurablePluginInstance instance) {
            super(instance.getId(), instance.getName());
            this.policyType = instance.getDescriptor().getType();
        }

        public String getPolicyType() {
            return this.policyType;
        }

        public void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PolicyItem that = (PolicyItem)((Object)o);
            return Objects.equals(this.policyType, that.policyType);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
            return result;
        }
    }
}

