/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.OAuthClientTasklet;
import com.pingidentity.util.ScopeSelectionModalUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.ScopeUtil;

public class OAuthDynamicClientRegistrationScopeConstraintsState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20200505L;
    private boolean restrictCommonScopes;
    private Set<String> restrictedScopeSet = new HashSet<String>();
    private Set<String> allowedExclusiveScopes = new HashSet<String>();
    private final transient ClientSettingManager clientSettingManager;

    public OAuthDynamicClientRegistrationScopeConstraintsState(IWizard owner, ClientSettingManager clientSettingManager) {
        super(owner);
        this.clientSettingManager = clientSettingManager;
        this.setMenuName("Scope Constraints");
    }

    public boolean isRestrictCommonScopes() {
        return this.restrictCommonScopes;
    }

    public void setRestrictCommonScopes(boolean restrictCommonScopes) {
        this.restrictCommonScopes = restrictCommonScopes;
    }

    @Override
    public boolean populateAllStates(Object data) {
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        this.restrictCommonScopes = clientSetting.isRestrictCommonScopes();
        this.restrictedScopeSet = clientSetting.getRestrictedCommonScopes();
        this.allowedExclusiveScopes = clientSetting.getAllowedExclusiveScopes();
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    private OAuthClientTasklet getParentTasklet() {
        return (OAuthClientTasklet)this.getParent();
    }

    @Override
    public boolean save(Object dataToDisk) {
        ClientSetting clientSetting = (ClientSetting)dataToDisk;
        if (this.getParentTasklet().getOAuthDynamicClientRegistrationState().isEnableDynamicClientRegistration()) {
            clientSetting.setRestrictCommonScopes(this.restrictCommonScopes);
            if (!this.restrictCommonScopes) {
                this.restrictedScopeSet = new HashSet<String>();
            }
            clientSetting.setRestrictedCommonScopes(this.restrictedScopeSet);
            clientSetting.setAllowedExclusiveScopes(this.allowedExclusiveScopes);
        } else {
            clientSetting.setRestrictedCommonScopes(new HashSet());
            clientSetting.setRestrictCommonScopes(false);
            clientSetting.setAllowedExclusiveScopes(new HashSet());
        }
        return true;
    }

    public Set<String> getScopes() {
        return ScopeUtil.getAllCommonScopeDescriptions().keySet();
    }

    public Set<String> getExclusiveScopes() {
        return ScopeUtil.getAllExclusiveScopeDescriptions().keySet();
    }

    public boolean isScopesSet() {
        return this.getScopes().size() > 0;
    }

    public boolean isExclusiveScopesSet() {
        return this.getExclusiveScopes().size() > 0;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Restrict Common Scopes", Boolean.toString(this.restrictCommonScopes), this));
        if (this.restrictCommonScopes) {
            summaryList.add(new SummaryInfo("Restricted Common Scopes", String.join((CharSequence)", ", this.restrictedScopeSet), this));
        }
        if (!this.allowedExclusiveScopes.isEmpty()) {
            summaryList.add(new SummaryInfo("Allowed Exclusive Scopes", String.join((CharSequence)", ", this.allowedExclusiveScopes), this));
        }
    }

    public Set<String> getRestrictedScopeSet() {
        return this.restrictedScopeSet;
    }

    public void setRestrictedScopeSet(Set<String> restrictedScopeSet) {
        this.restrictedScopeSet = restrictedScopeSet;
    }

    public Set<String> getAllowedExclusiveScopes() {
        return this.allowedExclusiveScopes;
    }

    public void setAllowedExclusiveScopes(Set<String> allowedExclusiveScopes) {
        this.allowedExclusiveScopes = allowedExclusiveScopes;
    }

    public String commonScopesModalJavascript() {
        return "javascript:\nvar data = {\n'eventType':'showScopesSelectionModal',\n'description':'Choose the common scope and scope groups that can be requested by a client. The rest and any common scopes and scope groups created in the future not be available to be requested.',\n'scopeType':'commonScope',\n'isIncludeScopeGroups': true,\n'selectedScopes': " + this.restrictedScopeSet.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]")) + "};\nvar origin = window.origin ? window.origin : window.location.origin;\nwindow.parent.postMessage(data, origin);\nvar idleTimerData = {'eventType': 'resetIdleTimer'};\nwindow.parent.postMessage(idleTimerData, origin);";
    }

    public String exclusiveScopesModalJavascript() {
        return "javascript:\nvar data = {\n'eventType':'showScopesSelectionModal',\n'description':'Choose the exclusive scope and scope groups that can be requested by a client. The rest and any exclusive scopes and scope groups created in the future not be available to be requested.',\n'scopeType':'exclusiveScope',\n'isIncludeScopeGroups': true,\n'selectedScopes':" + this.allowedExclusiveScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]")) + "};\nvar origin = window.origin ? window.origin : window.location.origin;\nwindow.parent.postMessage(data, origin);\nvar idleTimerData = {'eventType': 'resetIdleTimer'};\nwindow.parent.postMessage(idleTimerData, origin);";
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        ScopeSelectionModalUtil.setScopesForModal(cycle.getRequestContext(), this::setRestrictedScopeSet, this::setAllowedExclusiveScopes);
    }
}

