/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.OAuthDynamicClientRegistrationValidator;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.helper.ScopeFilterableSelectionHelper;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public class OAuthDynamicClientRegistrationState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20200505L;
    private boolean enableDynamicClientRegistration;
    private boolean requireInitialAccessToken;
    private boolean previousEnableDynamicClientReg;
    private boolean enableDynamicClientRegistrationManagement;
    private boolean rotateClientSecret;
    private boolean enableRetainClientSecret;
    private boolean allowClientDelete;
    private boolean rotateRegistrationAccessToken;
    public static final String MENU_NAME = "Dynamic Client Registration";
    private String initialAccessTokenScope;
    private FilterableSelectionFieldDescriptor.SearchableType scopeSearchableType;
    private String initialAccessTokenScopeDisplayName;
    private String initialAccessTokenScopeTypeAndId;
    private final transient ClientSettingManager clientSettingManager;

    public OAuthDynamicClientRegistrationState(IWizard owner, ClientSettingManager clientSettingManager) {
        super(owner);
        this.clientSettingManager = clientSettingManager;
        this.setMenuName(MENU_NAME);
    }

    public boolean isEnableDynamicClientRegistration() {
        return this.enableDynamicClientRegistration;
    }

    public void setEnableDynamicClientRegistration(boolean enableDynamicClientRegistration) {
        this.previousEnableDynamicClientReg = this.enableDynamicClientRegistration;
        this.enableDynamicClientRegistration = enableDynamicClientRegistration;
    }

    public boolean isEnableDynamicClientRegistrationManagement() {
        return this.enableDynamicClientRegistrationManagement;
    }

    public void setEnableDynamicClientRegistrationManagement(boolean enableDynamicClientRegistrationManagement) {
        this.enableDynamicClientRegistrationManagement = enableDynamicClientRegistrationManagement;
    }

    public boolean isRequireInitialAccessToken() {
        if (!this.requireInitialAccessToken && this.enableDynamicClientRegistration && !this.previousEnableDynamicClientReg) {
            return true;
        }
        return this.requireInitialAccessToken;
    }

    public void setRequireInitialAccessToken(boolean requireInitialAccessToken) {
        this.requireInitialAccessToken = requireInitialAccessToken;
    }

    public String getInitialAccessTokenScope() {
        return this.initialAccessTokenScope;
    }

    public void setInitialAccessTokenScope(String initialAccessTokenScope) {
        this.initialAccessTokenScope = initialAccessTokenScope;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return List.of(ScopeFilterableSelectionHelper.OAUTH_COMMON_SCOPE_GROUP_WITH_DEFAULT_OIDC, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE_GROUP, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE_GROUP);
    }

    public String getInitialAccessTokenScopeDisplayName() {
        return this.initialAccessTokenScopeDisplayName;
    }

    public void setInitialAccessTokenScopeDisplayName(String initialAccessTokenScopeDisplayName) {
        this.initialAccessTokenScopeDisplayName = initialAccessTokenScopeDisplayName;
    }

    public String getInitialAccessTokenScopeTypeAndId() {
        return this.initialAccessTokenScopeTypeAndId;
    }

    public void setInitialAccessTokenScopeTypeAndId(String initialAccessTokenScopeTypeAndId) {
        this.initialAccessTokenScopeTypeAndId = initialAccessTokenScopeTypeAndId;
        if (StringUtils.isNotEmpty((CharSequence)initialAccessTokenScopeTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(initialAccessTokenScopeTypeAndId);
            this.setInitialAccessTokenScope(option.getId());
            this.setScopeSearchableType(option.getType());
            this.setInitialAccessTokenScopeDisplayName(ScopeFilterableSelectionHelper.getScopeDisplayName(option.getId(), option.getType()));
        }
    }

    public void setScopeSearchableType(FilterableSelectionFieldDescriptor.SearchableType scopeSearchableType) {
        this.scopeSearchableType = scopeSearchableType;
    }

    public void clearScopeSelectionFilter() {
        this.initialAccessTokenScopeTypeAndId = null;
        this.setInitialAccessTokenScope(null);
        this.setScopeSearchableType(null);
        this.setInitialAccessTokenScopeDisplayName(null);
    }

    public boolean isRotateClientSecret() {
        return this.rotateClientSecret;
    }

    public void setRotateClientSecret(boolean rotateClientSecret) {
        this.rotateClientSecret = rotateClientSecret;
    }

    public boolean isEnableRetainClientSecret() {
        return this.enableRetainClientSecret;
    }

    public void setEnableRetainClientSecret(boolean enableRetainClientSecret) {
        this.enableRetainClientSecret = enableRetainClientSecret;
    }

    public boolean isAllowClientDelete() {
        return this.allowClientDelete;
    }

    public void setAllowClientDelete(boolean allowClientDelete) {
        this.allowClientDelete = allowClientDelete;
    }

    public boolean isRotateRegistrationAccessToken() {
        return this.rotateRegistrationAccessToken;
    }

    public void setRotateRegistrationAccessToken(boolean rotateRegistrationAccessToken) {
        this.rotateRegistrationAccessToken = rotateRegistrationAccessToken;
    }

    @Override
    public boolean populateAllStates(Object data) {
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        this.previousEnableDynamicClientReg = this.enableDynamicClientRegistration = clientSetting.isEnableDynamicClientRegistration();
        this.requireInitialAccessToken = clientSetting.isRequireInitialAccessToken();
        this.initialAccessTokenScope = clientSetting.getInitialAccessTokenScope();
        if (this.initialAccessTokenScope != null) {
            this.scopeSearchableType = ScopeFilterableSelectionHelper.getSearchableType(this.initialAccessTokenScope);
            this.initialAccessTokenScopeDisplayName = ScopeFilterableSelectionHelper.getScopeDisplayName(this.initialAccessTokenScope, this.scopeSearchableType);
        }
        this.enableDynamicClientRegistrationManagement = clientSetting.isEnableDynamicClientRegistrationManagement();
        this.rotateClientSecret = clientSetting.isRotateClientSecret();
        this.enableRetainClientSecret = clientSetting.isRetainClientSecret();
        this.rotateRegistrationAccessToken = clientSetting.isRotateRegistrationAccessToken();
        this.allowClientDelete = clientSetting.isAllowClientDelete();
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ClientSetting clientSetting = (ClientSetting)dataToDisk;
        clientSetting.setEnableDynamicClientRegistration(this.enableDynamicClientRegistration);
        clientSetting.setEnableDynamicClientRegistrationManagement(this.enableDynamicClientRegistrationManagement);
        clientSetting.setRequireInitialAccessToken(this.requireInitialAccessToken);
        if (this.enableDynamicClientRegistration) {
            if (this.requireInitialAccessToken) {
                clientSetting.setInitialAccessTokenScope(this.initialAccessTokenScope);
            } else {
                clientSetting.setInitialAccessTokenScope(null);
            }
            if (this.enableDynamicClientRegistrationManagement) {
                clientSetting.setRotateClientSecret(this.rotateClientSecret);
                clientSetting.setRetainClientSecret(this.enableRetainClientSecret);
                clientSetting.setRotateRegistrationAccessToken(this.rotateRegistrationAccessToken);
                clientSetting.setAllowClientDelete(this.allowClientDelete);
            } else {
                clientSetting.setRotateClientSecret(false);
                clientSetting.setRetainClientSecret(false);
                clientSetting.setRotateRegistrationAccessToken(false);
                clientSetting.setAllowClientDelete(false);
            }
        } else {
            clientSetting.setRequireInitialAccessToken(false);
            clientSetting.setInitialAccessTokenScope(null);
            clientSetting.setEnableDynamicClientRegistrationManagement(false);
            clientSetting.setRotateClientSecret(false);
            clientSetting.setRetainClientSecret(false);
            clientSetting.setRotateRegistrationAccessToken(false);
            clientSetting.setAllowClientDelete(false);
        }
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this.getParent());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.SCOPE_MANAGEMENT);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        OAuthDynamicClientRegistrationValidator validator = new OAuthDynamicClientRegistrationValidator(this.enableDynamicClientRegistration, this.requireInitialAccessToken, this.initialAccessTokenScope);
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Enable Dynamic Client Registration", Boolean.toString(this.enableDynamicClientRegistration), this));
        if (this.enableDynamicClientRegistration) {
            summaryList.add(new SummaryInfo("Enable Dynamic Client Registration Management", Boolean.toString(this.enableDynamicClientRegistrationManagement), this));
            summaryList.add(new SummaryInfo("Require Initial Access Token", Boolean.toString(this.requireInitialAccessToken), this));
            if (this.requireInitialAccessToken) {
                summaryList.add(new SummaryInfo("Initial Access Token Scope", ScopeFilterableSelectionHelper.getDescription(this.initialAccessTokenScope), this));
            }
            if (this.enableDynamicClientRegistrationManagement) {
                summaryList.add(new SummaryInfo("Rotate Client Secret", Boolean.toString(this.rotateClientSecret), this));
                summaryList.add(new SummaryInfo("Rotate Registration Access Token", Boolean.toString(this.rotateRegistrationAccessToken), this));
                summaryList.add(new SummaryInfo("Allow Client Delete", Boolean.toString(this.allowClientDelete), this));
            }
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        clientSetting.setRetainClientSecret(this.enableRetainClientSecret);
    }
}

