/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OAuthIdpAdapter2TargetMappingsState;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.List;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthIdpAdapter2TargetMappingTasklet
extends OAuthSource2TargetMappingTasklet<PluginToUserKeyAttrMapping> {
    private static final long serialVersionUID = 1L;
    IdpAdapterManager idPAdapterMgr = MgmtFactory.getIdpAdapterManager();
    AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public OAuthIdpAdapter2TargetMappingTasklet(Visit visit) {
        super("OAuthIdpAdapter2TargetMappingTasklet", "IdP Adapter Mapping", visit);
    }

    @Override
    public AttributeContract getMappingContract() {
        return this.authzServerManager.getKeyNameContract();
    }

    @Override
    public String getSourceType() {
        return "Adapter";
    }

    @Override
    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForOAuthWebRedirectFlowMapping();
    }

    @Override
    public void saveSetSelectedId(String id, PluginToUserKeyAttrMapping mapping) {
        mapping.setSourcePluginId(id);
    }

    @Override
    public String loadGetSelectedId(PluginToUserKeyAttrMapping mapping) {
        return mapping.getSourcePluginId();
    }

    @Override
    public String getDescription() {
        return "'" + this.getSelectedPlugin().getName() + "' to Persistent Grant Contract";
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.idPAdapterMgr.getInstance(this.selectedId);
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public void finish() {
        OAuthIdpAdapter2TargetMappingsState oAuthIdpAdapter2TargetMappingsState = new OAuthIdpAdapter2TargetMappingsState(this.getParentTasklet());
        PluginToUserKeyAttrMapping mappingToSave = oAuthIdpAdapter2TargetMappingsState.newEmptyMapping(this.getSelectedId());
        if (this.save(mappingToSave)) {
            this.authzServerManager.saveAdapterToUserKeyMapping(mappingToSave, this.isNewMapping());
            DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappingToSave, DependencyType.OAUTH_CLIENT_SETTINGS);
        }
        super.finish();
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.OAUTH_IDP_ADAPTER_MAPPING;
    }

    private boolean isNewMapping() {
        return this.authzServerManager.getAdapterToUserKeyMapping(this.selectedId) == null;
    }
}

