/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthMetadataUtil {
    private static final ClientSettingManager OAUTH_CLIENT_SETTINGS_MANAGER = MgmtFactory.getClientSettingManager();

    private static Set<String> getExtendedClientMetadataParams() {
        ClientSetting clientSetting = OAUTH_CLIENT_SETTINGS_MANAGER.getClientSetting();
        return OAuthMetadataUtil.getExtendedClientMetadataParams(clientSetting);
    }

    public static Set<String> getExtendedClientMetadataParams(ClientSetting clientSetting) {
        if (clientSetting != null && clientSetting.getExtendedMetadataParams().size() > 0) {
            return clientSetting.getExtendedMetadataParams().keySet();
        }
        return new HashSet<String>();
    }

    public static Set<String> getExtendedClientMetadataParamsWithPrefix(ClientSetting clientSetting) {
        HashSet<String> extendedClientMetadataSet = new HashSet<String>();
        if (clientSetting != null && clientSetting.getExtendedMetadataParams().size() > 0) {
            for (String param : clientSetting.getExtendedMetadataParams().keySet()) {
                extendedClientMetadataSet.add("extproperties." + param);
                extendedClientMetadataSet.add("extclientmetadata." + param);
            }
        }
        return extendedClientMetadataSet;
    }

    private static void setExtendedMetadataParamsAsSource(DataMap.Sources sources) {
        OAuthMetadataUtil.setExtendedMetadataParamAsSourceInternal(sources, "extproperties.");
    }

    private static void setDeprecatedExtendedMetadataParamsAsSource(DataMap.Sources sources) {
        OAuthMetadataUtil.setExtendedMetadataParamAsSourceInternal(sources, "extclientmetadata.");
    }

    private static void setExtendedMetadataParamAsSourceInternal(DataMap.Sources sources, String prefix) {
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        Set<String> metadataParamSet = OAuthMetadataUtil.getExtendedClientMetadataParams();
        for (String extendedMetaDataParam : metadataParamSet) {
            contextSelectionModel.add(extendedMetaDataParam, prefix + extendedMetaDataParam);
        }
        if (metadataParamSet.size() > 0) {
            sources.addPropertySelectionSource("Extended Properties", contextSelectionModel);
        }
    }

    public static void setExtendedMetadataParamsAsSource(DataMap.Sources sources, AttributeMapping attributeMapping) {
        if (OAuthMetadataUtil.isUsingDeprecatedExtClientMetadataPrefix(attributeMapping)) {
            OAuthMetadataUtil.setDeprecatedExtendedMetadataParamsAsSource(sources);
        } else {
            OAuthMetadataUtil.setExtendedMetadataParamsAsSource(sources);
        }
    }

    private static boolean isUsingDeprecatedExtClientMetadataPrefix(AttributeMapping attributeMapping) {
        if (attributeMapping == null || attributeMapping.getAttributeMapping() == null) {
            return false;
        }
        for (List attributeValueList : attributeMapping.getAttributeMapping().values()) {
            for (AttrMappingValue attributeMappingValue : attributeValueList) {
                if (SourceType.EXTENDED_CLIENT_METADATA != attributeMappingValue.getType() && SourceType.EXTENDED_PROPERTIES != attributeMappingValue.getType() || !attributeMappingValue.getValue().startsWith("extclientmetadata.")) continue;
                return true;
            }
        }
        return false;
    }
}

