/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnection2TargetMappingState;
import com.pingidentity.fsm.state.impl.OAuthSAML2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthSAML2TargetMappingState
extends OAuthIdpConnection2TargetMappingState
implements NeededCredentialsApi {
    private static final long serialVersionUID = 20050116L;
    private Tasklet parentTasklet;

    public OAuthSAML2TargetMappingState(Tasklet value, String name) {
        super(value, name);
        this.parentTasklet = value;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.attributeMapping = (OAuthAssertionGrantMapping)dataFromDisk;
        this.model = new SAML2MappingModel("Contract", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        OAuthAssertionGrantMapping mapping = (OAuthAssertionGrantMapping)dataToDisk;
        if (mapping == null) {
            mapping = new OAuthAssertionGrantMapping(((OAuthSAML2TargetMappingTasklet)this.parentTasklet).getSelectedTokenManagerId());
        }
        mapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        return true;
    }

    @Override
    protected IPropertySelectionModel getAssertionValues() {
        Tasklet t = this.parentTasklet.getParentTasklet();
        String[] values = new String[]{};
        if (t != null) {
            CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
            values = createAttributeContractState.getContract().getAllAttrNamesSorted().toArray(new String[0]);
        }
        return new StringPairPropertySelectionModel(true, values);
    }

    @Override
    public List<String> getTarget() {
        BearerAccessTokenMgmtPluginInstance selectedInstance = null;
        if (((OAuthSAML2TargetMappingTasklet)this.parentTasklet).getSelectedTokenManager() != null) {
            selectedInstance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(((OAuthSAML2TargetMappingTasklet)this.parentTasklet).getSelectedTokenManagerId());
        }
        if (selectedInstance != null) {
            AttributeContract copyOfAttributeContract = new AttributeContract();
            selectedInstance.getAttributeContract().getAllAttrNamesSorted().forEach(attr -> copyOfAttributeContract.addMutableAttributeName(attr));
            selectedInstance.getTokenEndpointAttributeContract().getAllAttributeNames().forEach(attr -> copyOfAttributeContract.addMutableAttributeName(attr));
            return copyOfAttributeContract.getAllAttrNamesSorted();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return false;
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return true;
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return false;
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return false;
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return false;
    }
}

