/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.ConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.ConfigureCustomSourceFiltersState;
import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnection2TargetMappingState;
import com.pingidentity.fsm.state.impl.OAuthIdpConnection2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSAML2TargetMappingState;
import com.pingidentity.fsm.state.impl.OAuthSAMLConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.OAuthSAMLConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.OAuthSAMLDatabaseTableAndColumnState;
import com.pingidentity.fsm.state.impl.OAuthSAMLSelectDataSourceData;
import com.pingidentity.fsm.state.impl.SelectCustomSourceFieldsState;
import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.state.impl.SelectTokenManagerState;
import com.pingidentity.fsm.state.issuancecriteria.impl.AbstractIssuanceCriteriaState;
import com.pingidentity.fsm.state.issuancecriteria.impl.OAuthSAML2IssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.impl.CustomAttributeSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthSAML2TargetMappingTasklet
extends OAuthIdpConnection2TargetMappingTasklet {
    private static final long serialVersionUID = 1L;
    private final SelectTokenManagerState selectTokenManagerState;

    public OAuthSAML2TargetMappingTasklet(Visit visit) {
        super(visit);
        this.setMenuName("OAuth Assertion Grant Attribute Mapping Configuration");
        this.selectTokenManagerState = new SelectTokenManagerState(this);
        this.selectTokenManagerState.addOutgoingTransition(this, this.selectDataSourceState);
        this.setInitialState(this.selectTokenManagerState);
        this.selectDataSourceState.setItClickable(false);
    }

    public String getSelectedTokenManagerId() {
        return this.selectTokenManagerState.getSelectedTokenManager().getId();
    }

    public String getSelectedTokenManagerName() {
        return this.selectTokenManagerState.getSelectedTokenManager().getName();
    }

    public BearerAccessTokenMgmtPluginInstance getSelectedTokenManager() {
        return this.selectTokenManagerState.getSelectedTokenManager();
    }

    @Override
    protected boolean isSourceTypeClaims() {
        return false;
    }

    @Override
    OAuthIdpConnection2TargetMappingState getMappingState() {
        return new OAuthSAML2TargetMappingState(this, "mapping");
    }

    @Override
    AbstractIssuanceCriteriaState getIssuanceCriteriaState() {
        return new OAuthSAML2IssuanceCriteriaState(this);
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.loadMapping((AttributeMapping)((OAuthAssertionGrantMapping)dataFromDisk));
        super.populate(dataFromDisk);
    }

    @Override
    SelectDataSourceState getSelectDataSourceState() {
        return new OAuthSAMLSelectDataSourceData(this, "idpSelectDataSource", false);
    }

    @Override
    ConfigLdapDirSearchState getConfigLdapDirSearchState() {
        return new OAuthSAMLConfigLdapDirSearchState(this, "configLdapDirSearch");
    }

    @Override
    ConfigLdapFilterState getCfgLdapFilterState() {
        return new CfgLdapFilterState(this, "idpConfigLdapFilter");
    }

    @Override
    SelectDatabaseTableAndColumnsState getSelectDatabaseTableAndColumnsState() {
        return new OAuthSAMLDatabaseTableAndColumnState(this);
    }

    @Override
    ConfigDatabaseFilterState getConfigDatabaseFilterState() {
        return new OAuthSAMLConfigDatabaseFilterState(this, "idpConfigDatabaseFilter");
    }

    @Override
    SelectCustomSourceFieldsState getOAuthSAMLSelectCustomSourceFieldsState() {
        return new OAuthSAMLSelectCustomSourceFieldsState(this);
    }

    @Override
    ConfigureCustomSourceFiltersState getOAuthSAMLConfigureCustomSourceFiltersState() {
        return new OAuthSAMLConfigureCustomSourceFiltersState(this);
    }

    @Override
    public List<String> getContractToFulfill() {
        BearerAccessTokenMgmtPluginInstance selectedInstance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.getSelectedTokenManagerId());
        if (selectedInstance != null) {
            return selectedInstance.getAttributeContract().getAllAttrNamesSorted();
        }
        return Collections.emptyList();
    }

    @Override
    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForOAuth();
    }

    @Override
    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    Object getCustomDatasourceAttributeMapping(Object diskData) {
        if (diskData instanceof IdpConnection) {
            IdpConnection tempConnection = (IdpConnection)diskData;
            OAuthAssertionGrantMapping attributeMapping = tempConnection.getOAuthSettings().getOAuthAssertionGrantMappingByTokenManagerId(this.getSelectedTokenManagerId());
            if (attributeMapping == null) {
                attributeMapping = new OAuthAssertionGrantMapping(this.getSelectedTokenManagerId());
                attributeMapping.setAttributeSource((AttributeSource)new CustomAttributeSource());
            }
            return attributeMapping;
        }
        return diskData;
    }

    public void setNewTokenManager(boolean val) {
        this.selectTokenManagerState.setNewTokenManager(val);
    }

    @Override
    public void finish() {
        OAuthAssertionGrantMapping mapping = new OAuthAssertionGrantMapping();
        this.save(mapping);
        this.setPopulateData(mapping);
        super.finish();
    }

    @Override
    public String getDescription() {
        return this.getSelectedTokenManager() != null ? this.getSelectedTokenManagerName() : "";
    }

    @Override
    public boolean setStatesToVOMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(true, this.getTaskletName() + "_OAuthSAMLSelectDataSourceDataVo");
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(true, this.getTaskletName() + "_OAuthSAMLDatabaseTableAndColumnStateVo");
            this.configDatabaseFilterState.setViewOnly(true, this.getTaskletName() + "_OAuthSAMLConfigDatabaseFilterStateVo");
            this.mappingFullfillmentState.setViewOnly(true, this.getTaskletName() + "_OAuthSAML2TargetMappingStateVo");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(true, this.getTaskletName() + "_OAuthSAMLConfigLdapDirSearchStateVo");
            this.configLdapFilterState.setViewOnly(true, this.getTaskletName() + "_CfgLdapFilterStateVo");
            this.mappingFullfillmentState.setViewOnly(true, this.getTaskletName() + "_OAuthSAML2TargetMappingStateVo");
        }
        return false;
    }

    @Override
    public boolean setStatesToEditMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(false, this.getTaskletName() + "_OAuthSAMLSelectDataSourceData");
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(false, this.getTaskletName() + "_OAuthSAMLDatabaseTableAndColumnState");
            this.configDatabaseFilterState.setViewOnly(false, this.getTaskletName() + "_OAuthSAMLConfigDatabaseFilterState");
            this.mappingFullfillmentState.setViewOnly(false, this.getTaskletName() + "_OAuthSAML2TargetMappingState");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(false, this.getTaskletName() + "_OAuthSAMLConfigLdapDirSearchState");
            this.configLdapFilterState.setViewOnly(false, this.getTaskletName() + "_CfgLdapFilterState");
            this.mappingFullfillmentState.setViewOnly(false, this.getTaskletName() + "_OAuthSAML2TargetMappingState");
        }
        return false;
    }

    private class OAuthSAMLSelectCustomSourceFieldsState
    extends SelectCustomSourceFieldsState {
        private static final long serialVersionUID = 1L;

        public OAuthSAMLSelectCustomSourceFieldsState(IWizard owner) {
            super(owner, "selectCustomSourceFields");
        }

        @Override
        public void populate(Object dataFromDisk) {
            super.populate(OAuthSAML2TargetMappingTasklet.this.getCustomDatasourceAttributeMapping(dataFromDisk));
        }

        @Override
        public boolean save(Object dataToDisk) {
            return super.save(OAuthSAML2TargetMappingTasklet.this.getCustomDatasourceAttributeMapping(dataToDisk));
        }
    }

    private class OAuthSAMLConfigureCustomSourceFiltersState
    extends ConfigureCustomSourceFiltersState {
        private static final long serialVersionUID = 1L;

        public OAuthSAMLConfigureCustomSourceFiltersState(IWizard owner) {
            super(owner);
        }

        @Override
        public void populate(Object dataFromDisk) {
            super.populate(OAuthSAML2TargetMappingTasklet.this.getCustomDatasourceAttributeMapping(dataFromDisk));
        }

        @Override
        public boolean save(Object dataToDisk) {
            return super.save(OAuthSAML2TargetMappingTasklet.this.getCustomDatasourceAttributeMapping(dataToDisk));
        }
    }

    private class CfgLdapFilterState
    extends ConfigLdapFilterState {
        private static final long serialVersionUID = 1L;

        public CfgLdapFilterState(Tasklet parent, String cardName) {
            super(parent, cardName);
        }

        @Override
        public List<String> getValues() {
            Tasklet t = OAuthSAML2TargetMappingTasklet.this.getParentTasklet();
            List values = Collections.emptyList();
            if (t != null) {
                CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
                values = createAttributeContractState.getContract().getAllAttrNamesSorted();
            }
            return values;
        }

        @Override
        public void populate(Object dataFromDisk) {
            super.populate(dataFromDisk);
        }

        @Override
        public boolean save(Object dataToDisk) {
            return super.save(dataToDisk);
        }

        @Override
        public String getValueText() {
            return super.getIsOidc() ? "Provider Claims" : "Assertion Values";
        }
    }
}

