/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import java.util.HashMap;
import java.util.HashSet;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantAttributeContract;
import org.sourceid.saml20.domain.OAuthSettings;

public class OAuthSAMLCreateAttributeContractState
extends CreateAttributeContractState {
    private static final long serialVersionUID = 20050118L;

    public OAuthSAMLCreateAttributeContractState(Tasklet value, String name) {
        super(value, name);
        this.contract = new OAuthAssertionGrantAttributeContract();
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        AttributeContract localContract = this.makeEmptyAttributeContract(false, false);
        OAuthAssertionGrantAttributeContract existingContract = connection.getOAuthSettings().getOAuthAssertionGrantAttributeContract();
        if (existingContract != null) {
            HashSet immutableAttributeNames = new HashSet(existingContract.getImmutableAttributeNames());
            localContract.setImmutableAttributeNames(immutableAttributeNames);
            HashMap<String, String> mutableAttributeInfo = new HashMap<String, String>();
            HashSet attributeNames = new HashSet(existingContract.getMutableAttributeNames());
            for (String attributeName : attributeNames) {
                mutableAttributeInfo.put(attributeName, existingContract.getMutableAttributeNameFormat(attributeName));
            }
            localContract.setMutableAttributesInfo(mutableAttributeInfo);
        }
        this.setContract(localContract);
        this.maskedAttributeNames.addAll(connection.getOAuthSettings().getOAuthAssertionGrantAttributeContract().getMaskedAttributeNames());
    }

    @Override
    public boolean populateAllStates(Object data) {
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection conn = (IdpConnection)dataToDisk;
        OAuthSettings settings = conn.getOAuthSettings();
        if (settings == null) {
            settings = new OAuthSettings();
            conn.setOAuthSettings(settings);
        }
        OAuthAssertionGrantAttributeContract oAuthSAMLBearerAttributeContact = new OAuthAssertionGrantAttributeContract();
        oAuthSAMLBearerAttributeContact.setImmutableAttributeNames(this.getContract().getImmutableAttributeNames());
        oAuthSAMLBearerAttributeContact.setMaskedAttributeNames(this.maskedAttributeNames);
        oAuthSAMLBearerAttributeContact.setMutableAttributeNames(new HashSet(this.getContract().getMutableAttributeNames()));
        oAuthSAMLBearerAttributeContact.setMutableAttributesInfo(new HashMap(this.getContract().getMutableAttributesInfo()));
        settings.setOAuthAssertionGrantAttributeContract(oAuthSAMLBearerAttributeContact);
        return true;
    }

    @Override
    protected AttributeContract makeEmptyAttributeContract(boolean includePseudonym, boolean includeTransientId) {
        return new OAuthAssertionGrantAttributeContract();
    }
}

