/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetAttributeSourcesState;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.issuancecriteria.impl.OAuthSource2TargetIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.IdentifiableTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;

public abstract class OAuthSource2TargetMappingTasklet<T extends AttributeMapping>
extends MappingTasklet
implements AttributeNamesApi,
IdentifiableTasklet {
    private static final long serialVersionUID = 1L;
    private OAuthSource2TargetMappingState mappingFullfillmentState;
    private OAuthSource2TargetIssuanceCriteriaState oAuthSource2TargetIssuanceCriteriaState;
    private SummaryCardState summaryCardState;
    protected String selectedId;
    protected String selectedTargetId;
    protected T attributeMapping;

    public OAuthSource2TargetMappingTasklet(String taskletName, String menuName, Visit visit) {
        super(taskletName, menuName);
        this.setSystemVisit(visit);
        this.mappingFullfillmentState = new OAuthSource2TargetMappingState(this, "mapping");
        this.mappingFullfillmentState.setMenuName("Contract Fulfillment");
        this.oAuthSource2TargetIssuanceCriteriaState = new OAuthSource2TargetIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.createNoDsTransitions();
        this.setInitialState(this.configAttributeSourcesState);
        this.setCancelAvailable(true);
    }

    public abstract AttributeContract getMappingContract();

    public abstract String getSourceType();

    public abstract void saveSetSelectedId(String var1, T var2);

    public abstract String loadGetSelectedId(T var1);

    public T getAttributeMapping() {
        return this.attributeMapping;
    }

    @Override
    public String getId() {
        return this.getDescription();
    }

    public void saveSetSelectedTargetId(String id, T mapping) {
    }

    public String loadGetSelectedTargetId(T mapping) {
        return null;
    }

    public String getTargetDescription() {
        return null;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.loadMapping((AttributeMapping)dataFromDisk);
        super.populate(dataFromDisk);
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping mapping = (AttributeMapping)dataToDisk;
        this.saveSetSelectedId(this.selectedId, mapping);
        this.saveSetSelectedTargetId(this.selectedTargetId, mapping);
        return super.save(mapping);
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions(curState);
    }

    protected AttributeContract getAttributes() {
        return this.getMappingContract();
    }

    public void loadMapping(T mapping) {
        this.attributeMapping = mapping;
        this.selectedId = this.loadGetSelectedId(mapping);
        this.selectedTargetId = this.loadGetSelectedTargetId(mapping);
    }

    protected void createNoDsTransitions() {
        this.configAttributeSourcesState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.oAuthSource2TargetIssuanceCriteriaState);
        this.oAuthSource2TargetIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.getAttributes().getAllAttributeNames();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.getMappingContract().getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.getAttributes().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.getAttributes().getSortedMutableAttributeNames();
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
        List srcNames = sourceInstance.getAttributeContract().getAllAttrNamesSorted();
        String type = this.getSourceType();
        if (type != null) {
            sources.addPropertySelectionSource(type, new StringPairPropertySelectionModel(true, srcNames));
        }
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : this.getContextMappingTypes()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
        OAuthMetadataUtil.setExtendedMetadataParamsAsSource(sources, this.attributeMapping);
    }

    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForOAuthAccessToken();
    }

    public boolean isRequired() {
        return false;
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new OAuthSource2TargetAttributeSourcesState(this, "configAttributeSources");
    }

    public abstract String getDescription();

    @Override
    public int compareTo(Tasklet o) {
        if (!(o instanceof OAuthSource2TargetMappingTasklet)) {
            return -1;
        }
        OAuthSource2TargetMappingTasklet other = (OAuthSource2TargetMappingTasklet)o;
        int result = this.getDescription().toLowerCase().compareTo(other.getDescription().toLowerCase());
        if (result != 0) {
            return result;
        }
        if (this.getTargetDescription() == null && other.getTargetDescription() != null) {
            return -1;
        }
        if (this.getTargetDescription() != null && other.getTargetDescription() == null) {
            return 1;
        }
        return this.getTargetDescription().toLowerCase().compareTo(other.getTargetDescription().toLowerCase());
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(String selectedId) {
        this.selectedId = selectedId;
    }

    public String getSelectedTargetId() {
        return this.selectedTargetId;
    }

    public void setSelectedTargetId(String selectedTargetId) {
        this.selectedTargetId = selectedTargetId;
    }

    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.OAUTH_SOURCE_TO_TARGET;
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.mappingFullfillmentState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.oAuthSource2TargetIssuanceCriteriaState.getIssuanceCriteriaList();
    }
}

