/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public class OAuthUserKey2AccessTokenMappingState
extends OAuthSource2TargetMappingsState<AccessTokenMapping> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CONTEXT_DESCRIPTION = "Default";
    public static final String CLIENT_CREDENTIAL_DESCRIPTION = "Client Credentials";
    private final transient ContextUtil contextUtil = new ContextUtil();
    private final transient MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final transient TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();

    public OAuthUserKey2AccessTokenMappingState(Tasklet owner) {
        super(owner);
    }

    @Override
    public Collection<AccessTokenMapping> getMappings() {
        return this.authzServerMgr.getAccessTokenMappings();
    }

    @Override
    protected Collection<StringPairPropertySelectionModel.SPair> getSourceIdNamePairs() {
        LinkedList<StringPairPropertySelectionModel.SPair> list = new LinkedList<StringPairPropertySelectionModel.SPair>();
        String id = "default";
        list.add(this.createSPair(id, OAuthUserKey2AccessTokenMappingState.getDesc(id)));
        list.add(this.createSPair("client_credentials", OAuthUserKey2AccessTokenMappingState.getDesc("client_credentials")));
        boolean isIdpRoleEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableIdP();
        for (PluginToUserKeyAttrMapping rocredsMapping : this.authzServerMgr.getPwdCredValidatorToUserKeyMappings()) {
            id = this.contextUtil.buildQualifiedId("password", new OAuthSourceId(OAuthSourceId.Type.PCV, rocredsMapping.getSourcePluginId()));
            list.add(this.createSPair(id, OAuthUserKey2AccessTokenMappingState.getDesc(id)));
        }
        if (isIdpRoleEnabled) {
            for (PluginToUserKeyAttrMapping adapterMapping : this.authzServerMgr.getAdapterToUserKeyMappings()) {
                id = this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.ADAPTER, adapterMapping.getSourcePluginId()));
                list.add(this.createSPair(id, OAuthUserKey2AccessTokenMappingState.getDesc(id)));
            }
            for (ApcToUserKeyAttrMapping apcMapping : this.authzServerMgr.getApcToUserKeyMappings()) {
                id = this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.APC, apcMapping.getApcId()));
                list.add(this.createSPair(id, OAuthUserKey2AccessTokenMappingState.getDesc(id)));
            }
        }
        if (MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSP()) {
            for (IdpConnection idp : this.metadataDirectory.getIdpConnections()) {
                if (!idp.hasSsoToOAuthAttrMapping()) continue;
                id = this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, idp.getId()));
                list.add(this.createSPair(id, OAuthUserKey2AccessTokenMappingState.getDesc(id)));
            }
        }
        if (isIdpRoleEnabled) {
            TokenExchangeProcessorPolicies policies = this.tokenExchangeProcessorPolicyManager.getTokenExchangeProcessorPolicies();
            for (String policyId : policies.getPolicies().keySet()) {
                id = this.contextUtil.buildQualifiedId("urn:ietf:params:oauth:grant-type:token-exchange", new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, policyId));
                list.add(this.createSPair(id, OAuthUserKey2AccessTokenMappingState.getDesc(id)));
            }
        }
        return list;
    }

    @Override
    protected Collection<? extends ConfigurablePluginInstance> getTargetInstances() {
        return MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
    }

    static String getDesc(String id) {
        if (id.equals("default")) {
            return DEFAULT_CONTEXT_DESCRIPTION;
        }
        if (id.equals("client_credentials")) {
            return CLIENT_CREDENTIAL_DESCRIPTION;
        }
        ContextUtil contextUtil = new ContextUtil();
        MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
        IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
        PasswordCredentialValidatorManager validatorManager = MgmtFactory.getCredentialValidatorManager();
        TokenExchangeProcessorPolicyManager teppManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
        try {
            ContextUtil.Ctx ctx = contextUtil.split(id);
            String qualifier = ctx.getQualifier();
            OAuthSourceId sourceId = ctx.getOAuthSourceId();
            if ("password".equals(qualifier)) {
                ConfigurablePluginInstance instance = validatorManager.getInstance(sourceId.getRealId());
                return "Validator: " + instance.getName();
            }
            if ("urn:ietf:params:oauth:grant-type:token-exchange".equals(qualifier)) {
                TokenExchangeProcessorPolicies tokenExchangeProcessorPolicies = teppManager.getTokenExchangeProcessorPolicies();
                TokenExchangeProcessorPolicy policy = tokenExchangeProcessorPolicies.getPolicy(sourceId.getRealId());
                return "Token Exchange Processor Policy: " + policy.getName();
            }
            if ("authz_req".equals(qualifier)) {
                if (sourceId.getType() == OAuthSourceId.Type.IDP_CONNECTION) {
                    IdpConnection idp = metadataDirectory.getIdpConnectionBySystemId(sourceId.getRealId(), false);
                    if (idp != null) {
                        return "IdP Connection: " + idp.getName();
                    }
                } else {
                    C2cContract apc;
                    if (sourceId.getType() == OAuthSourceId.Type.ADAPTER) {
                        IdpAuthnAdapterInstance idpAuthnAdapterInstance = (IdpAuthnAdapterInstance)idpAdapterManager.getInstance(sourceId.getRealId());
                        return "IdP Adapter: " + idpAuthnAdapterInstance.getName();
                    }
                    if (sourceId.getType() == OAuthSourceId.Type.APC && (apc = MgmtFactory.getC2cContractManager().getContract(sourceId.getRealId())) != null) {
                        return "Authentication Policy Contract: " + apc.getName();
                    }
                }
            }
        }
        catch (Exception e) {
            return "Unknown reference: " + id;
        }
        return "UNKNOWN";
    }

    @Override
    public String getDropDownText() {
        return "Context";
    }

    @Override
    public String getTargetDropDownText() {
        return "Access Token Manager";
    }

    private StringPairPropertySelectionModel.SPair createSPair(String id, String name) {
        StringPairPropertySelectionModel.SPair pair = new StringPairPropertySelectionModel.SPair();
        pair.setId(id);
        pair.setDesc(name);
        return pair;
    }

    @Override
    public AccessTokenMapping newEmptyMapping(String sourceId) {
        if ("client_credentials".equals(sourceId)) {
            return new ClientCredentialAccessTokenMapping();
        }
        return new UserKeyToAccessTokenMapping();
    }

    @Override
    protected void saveMappings(Collection<AccessTokenMapping> mappings) {
        this.authzServerMgr.saveAccessTokenMappings(mappings);
        for (AccessTokenMapping atm : mappings) {
            DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)atm, DependencyType.OAUTH_CLIENT_SETTINGS);
            if (!"Processor Policy".equals(atm.getContextSourceType())) continue;
            ContextUtil.Ctx ctx = this.contextUtil.split(atm.getContextId());
            OAuthSourceId sourceId = ctx.getOAuthSourceId();
            TokenExchangeProcessorPolicies tokenExchangeProcessorPolicies = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies();
            TokenExchangeProcessorPolicy policy = tokenExchangeProcessorPolicies.getPolicy(sourceId.getRealId());
            if (policy == null) continue;
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)policy, DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY);
        }
    }

    @Override
    public void delete(String mappingToDelete) {
        super.markTaskletAsDeleted(mappingToDelete);
        OAuthSource2TargetMappingTasklet mappingTasklet = (OAuthSource2TargetMappingTasklet)this.findTaskletByMappingId(mappingToDelete);
        if ("client_credentials".equals(mappingTasklet.getSelectedId())) {
            this.authzServerMgr.deleteClientCredentialToAccessTokenMapping(mappingToDelete);
        } else {
            this.authzServerMgr.deleteUserKeyToAccessTokenMapping(mappingToDelete);
        }
    }

    @Override
    public Class<? extends OAuthSource2TargetMappingTasklet<AccessTokenMapping>> getTaskletClass() {
        return OAuthUserKey2AccessTokenMappingTasklet.class;
    }

    @Override
    public String getSourceColumnTitle() {
        return "Context";
    }

    @Override
    public boolean hasConfigurableTarget() {
        return true;
    }

    @Override
    public String getMissingTargetErrorMessage() {
        return "Please select an Access Token Manager";
    }

    @Override
    public String getTargetColumnTitle() {
        return "Access Token Manager";
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            OAuthUserKey2AccessTokenMappingTasklet tasklet = (OAuthUserKey2AccessTokenMappingTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record("The mapping for context '" + tasklet.getDescription() + "' and token manager '" + tasklet.getTargetDescription() + "' has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public AdminAuditLogger.Component getAuditLogComponent() {
        return AdminAuditLogger.Component.OAUTH_ACCESS_TOKEN_MAPPING;
    }

    @Override
    public Predicate<AccessTokenMapping> getIdMapping(OAuthSource2TargetMappingTasklet<?> targetMappingTasklet) {
        return mapping -> !mapping.getContextId().equals(targetMappingTasklet.getSelectedId()) || !mapping.getTokenManagerId().equals(targetMappingTasklet.getSelectedTargetId());
    }

    public static class OAuthUserKey2AccessTokenMappingTasklet
    extends OAuthSource2TargetMappingTasklet<AccessTokenMapping> {
        private static final long serialVersionUID = 1L;
        final transient BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        final transient AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();

        public OAuthUserKey2AccessTokenMappingTasklet(Visit visit) {
            super("OAuthUserKey2AccessTokenMappingTasklet", "Access Token Mapping", visit);
        }

        @Override
        public void finish() {
            OAuthUserKey2AccessTokenMappingState oAuthUserKey2AccessTokenMappingState = new OAuthUserKey2AccessTokenMappingState(this.getParentTasklet());
            AccessTokenMapping mappingToSave = oAuthUserKey2AccessTokenMappingState.newEmptyMapping(this.getSelectedId());
            if (this.save(mappingToSave)) {
                if (mappingToSave instanceof UserKeyToAccessTokenMapping) {
                    this.authzServerMgr.saveUserKeyToAccessTokenMapping(mappingToSave.getId(), (UserKeyToAccessTokenMapping)mappingToSave);
                } else if (mappingToSave instanceof ClientCredentialAccessTokenMapping) {
                    this.authzServerMgr.saveClientCredsToAccessTokenMapping(mappingToSave.getId(), (ClientCredentialAccessTokenMapping)mappingToSave);
                }
                DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
                DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
                dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappingToSave, DependencyType.OAUTH_CLIENT_SETTINGS);
                ContextUtil contextUtil = new ContextUtil();
                OAuthSourceId sourceId = contextUtil.split(mappingToSave.getContextId()).getOAuthSourceId();
                if (sourceId != null && OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY == sourceId.getType()) {
                    dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies().getPolicy(sourceId.getRealId()), DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY);
                }
            }
            super.finish();
        }

        @Override
        public String getId() {
            if (this.attributeMapping == null) {
                return null;
            }
            return ((AccessTokenMapping)this.attributeMapping).getId();
        }

        @Override
        public AttributeContract getMappingContract() {
            BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)this.accessTokenMgmtPluginMgr.getInstance(this.selectedTargetId);
            if (instance == null) {
                return new AttributeContract();
            }
            AttributeContract copyOfAttributeContract = new AttributeContract(instance.getAttributeContract().getImmutableAttributeNames());
            instance.getAttributeContract().getMutableAttributeNames().forEach(attr -> copyOfAttributeContract.addMutableAttributeName(attr));
            instance.getTokenEndpointAttributeContract().getAllAttributeNames().forEach(attr -> copyOfAttributeContract.addMutableAttributeName(attr));
            return copyOfAttributeContract;
        }

        @Override
        public String getSourceType() {
            if (this.attributeMapping instanceof UserKeyToAccessTokenMapping) {
                return "Persistent Grant";
            }
            return null;
        }

        @Override
        public void saveSetSelectedId(String id, AccessTokenMapping mapping) {
            mapping.setContextId(id);
        }

        @Override
        public void saveSetSelectedTargetId(String id, AccessTokenMapping mapping) {
            mapping.setTokenManagerId(id);
        }

        @Override
        public String loadGetSelectedId(AccessTokenMapping mapping) {
            if (mapping != null) {
                return mapping.getContextId();
            }
            return null;
        }

        @Override
        public String loadGetSelectedTargetId(AccessTokenMapping mapping) {
            if (mapping != null) {
                return mapping.getTokenManagerId();
            }
            return null;
        }

        @Override
        public String getDescription() {
            return OAuthUserKey2AccessTokenMappingState.getDesc(this.selectedId);
        }

        @Override
        public ConfigurablePluginInstance getSelectedPlugin() {
            return this.getFakeInstance(this.selectedId, null);
        }

        private ConfigurablePluginInstance getFakeInstance(String id, String name) {
            BasePluginInstance bpi = new BasePluginInstance();
            bpi.setId(id);
            bpi.setName(name);
            Set attibuteContract = null;
            if ("client_credentials".equals(id)) {
                attibuteContract = MgmtFactory.getAuthzServerManager().getClientCredentialsContract().getAllAttributeNames();
            } else {
                attibuteContract = MgmtFactory.getAuthzServerManager().getKeyOnlyContract().getAllAttributeNames();
                attibuteContract.add("EXPIRES_AT");
            }
            bpi.setImmutableAttributeContract(attibuteContract);
            return bpi;
        }

        @Override
        public String getMappingSourceForDisplay() {
            return null;
        }

        @Override
        public String getTargetDescription() {
            if (this.selectedTargetId == null) {
                return "";
            }
            BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)this.accessTokenMgmtPluginMgr.getInstance(this.selectedTargetId);
            if (instance == null) {
                return "";
            }
            return instance.getName();
        }

        @Override
        public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
            Collection authnCtxAttributes;
            super.addStandardSourcesToPropertySelectionSources(sources);
            if (this.attributeMapping != null && ((AccessTokenMapping)this.attributeMapping).getContextSourceType() != null && !(authnCtxAttributes = ((AccessTokenMapping)this.attributeMapping).getContextAttributes()).isEmpty()) {
                StringPairPropertySelectionModel contextAttrSelectionModel = new StringPairPropertySelectionModel(true);
                for (String attr : authnCtxAttributes) {
                    contextAttrSelectionModel.add(attr, ((AccessTokenMapping)this.attributeMapping).getContextAttrPrefix() + "." + attr);
                }
                sources.addPropertySelectionSource(((AccessTokenMapping)this.attributeMapping).getContextSourceType(), contextAttrSelectionModel, null);
            }
        }

        @Override
        public Collection<String> getAdditionalInputAttributesForFilter() {
            if (this.attributeMapping != null) {
                return ((AccessTokenMapping)this.attributeMapping).getContextAttributeIds();
            }
            return Collections.emptyList();
        }

        @Override
        public AffectedItemType getAffectedItemType() {
            return AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING;
        }
    }
}

