/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.PasswordRules;

public class PasswordGenerationState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String generatedPassword = "";
    private String userName;

    public PasswordGenerationState(Tasklet value) {
        super(value);
        this.setMenuName("Password Generation");
    }

    public void generate(IRequestCycle cycle) {
        PasswordRules rules = new PasswordRules();
        this.generatedPassword = rules.randomValidPassword();
    }

    public String getGeneratedPassword() {
        return this.generatedPassword;
    }

    public void setGeneratedPassword(String generatedPassword) {
        this.generatedPassword = generatedPassword;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        PasswordValidator passwordValidator = new PasswordValidator(this.generatedPassword);
        if (StringUtils.isBlank((String)this.generatedPassword)) {
            IFormComponent ic = (IFormComponent)component.getComponent("generatedPassword");
            delegate.setFormComponent(ic);
            delegate.record(this.getMessage("Generated_password_required"), ValidationConstraint.REQUIRED);
        } else if (!passwordValidator.validate()) {
            this.recordErrors(passwordValidator.getErrors(), delegate);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUsername(String username) {
        this.userName = username;
    }
}

