/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.helper.BridgeHelper;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.setup.IdpConfigurationTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.PingIDSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.UsecasesSetupTasklet;
import com.pingidentity.pingid.PingIdInitialSetupAdminService;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.pingone.PingOneAdminServiceSettings;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.util.PluginUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneSettingsState
extends TaskletState {
    public static final String PING_ONE_SETTINGS_MENU = "PingOne for Enterprise Settings";
    public static final String PING_ONE_SETTINGS_TASKLET = "PingOneSettingsTasklet";
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private static final PingIdInitialSetupAdminService pingIdInitialSetupAdminService = MgmtFactory.getPingIdInitialSetupAdminService();
    private static final long serialVersionUID = 1L;
    private boolean enableAdminConsoleSso = false;
    private boolean enableMonitoring = false;
    private boolean ssoWasEnabled = false;
    private PkCert currentKey;
    private PkCert previousKey;
    private boolean rotated = false;
    private boolean disconnectRequested = false;
    private boolean confirmUpdatePingOne = false;
    private boolean pingOneUpdateSuccessful = false;
    private transient PingOneAdminService pingOneAdminService = MgmtFactory.getPingOneAdminService();

    public PingOneSettingsState(Tasklet parent) {
        super(parent);
        this.setMenuName("PingOne Settings");
    }

    @Override
    public String getNoteKey() {
        if (this.isUpdatePingOneVisible()) {
            return super.getNoteKey() + "_active_sp_conn";
        }
        return super.getNoteKey();
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        this.populate(dataFromDisk);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        PingOneAdminServiceSettings settings = this.pingOneAdminService.getSettings();
        this.enableAdminConsoleSso = settings.isEnableAdminConsoleSso();
        this.ssoWasEnabled = settings.isEnableAdminConsoleSso();
        this.enableMonitoring = settings.isEnableMonitoring();
        this.currentKey = this.pingOneAdminService.getClientAuthnKeyPair();
        this.previousKey = this.pingOneAdminService.getPreviousClientAuthnKeyPair();
        this.disconnectRequested = false;
        this.confirmUpdatePingOne = false;
        this.pingOneUpdateSuccessful = false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        Tasklet currentTasklet = this.getVisit().getCurrentTasklet();
        currentTasklet.setupNavMenuReload();
        if (this.disconnectRequested) {
            this.doDisconnect();
            currentTasklet.setNavMenuTarget("pingOneSetup");
            return true;
        }
        PingOneAdminServiceSettings settings = this.pingOneAdminService.getSettings();
        settings.setEnableMonitoring(this.isEnableMonitoring());
        settings.setEnableAdminConsoleSso(this.enableAdminConsoleSso);
        if (this.enableAdminConsoleSso && !this.ssoWasEnabled) {
            try {
                String adminConsoleHostname = new URI(this.getRequestContext().getRequestURL().toString()).getHost();
                settings.setAdminConsoleHostname(adminConsoleHostname);
            }
            catch (URISyntaxException e) {
                this.log.error((Object)("Failed to obtain admin console hostname from request, invalid URI: " + this.getRequestContext().getRequestURL()));
            }
        }
        this.pingOneAdminService.saveSettings(settings);
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!this.disconnectRequested) {
            if (this.getCompanyName() != null) {
                summaryList.add(new SummaryInfo(this.getMessage("Company_name"), this.getCompanyName(), this));
            }
            if (this.getSpConnectionName() != null) {
                summaryList.add(new SummaryInfo(this.getMessage("Sp_connection"), this.getSpConnectionName(), this));
            }
            summaryList.add(new SummaryInfo(this.getMessage("Enable_sso"), Boolean.toString(this.enableAdminConsoleSso), this));
            summaryList.add(new SummaryInfo(this.getMessage("Enable_monitoring"), Boolean.toString(this.enableMonitoring), this));
            if (this.currentKey != null) {
                summaryList.add(new SummaryInfo(this.getMessage("Current_key_creation_time"), this.getCurrentKeyCreationTime(), this));
            }
            if (this.previousKey != null) {
                summaryList.add(new SummaryInfo(this.getMessage("Previous_key_creation_time"), this.getPreviousKeyCreationTime(), this));
            }
        }
    }

    public String getCompanyName() {
        String companyName = this.pingOneAdminService.getMetadata().getPingOneCompanyName();
        if (StringUtils.isBlank((String)companyName)) {
            return null;
        }
        return companyName;
    }

    public String getSpConnectionName() {
        return BridgeHelper.getInstance().getSpConnectionName();
    }

    public boolean isEnableAdminConsoleSso() {
        return this.enableAdminConsoleSso;
    }

    public void setEnableAdminConsoleSso(boolean enableAdminConsoleSso) {
        this.enableAdminConsoleSso = enableAdminConsoleSso;
    }

    public boolean isEnableMonitoring() {
        return this.enableMonitoring;
    }

    public void setEnableMonitoring(boolean enableMonitoring) {
        this.enableMonitoring = enableMonitoring;
    }

    public String getLaunchPingOneAdminPortalHandler() {
        return "window.open('" + this.pingOneAdminService.getMetadata().getWebPortalUrl() + "')";
    }

    public boolean hasPreviousKey() {
        return this.previousKey != null;
    }

    public String getCurrentKeyCreationTime() {
        if (this.currentKey == null) {
            return null;
        }
        return this.currentKey.getX509Certificate().getNotBefore().toString();
    }

    public String getPreviousKeyCreationTime() {
        if (this.previousKey == null) {
            return null;
        }
        return this.previousKey.getX509Certificate().getNotBefore().toString();
    }

    public void rotateKey() {
        long activationTime;
        long activationDelay;
        Date configPublished;
        Mediator mediator = MgmtFactory.getMediator();
        if (mediator.isDistributable() && ((configPublished = mediator.getConfigPublishDate()) == null || configPublished.before(this.currentKey.getX509Certificate().getNotBefore()))) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record("Please replicate configuration changes before rotating the authentication key.", ValidationConstraint.REQUIRED);
        }
        if ((activationDelay = (activationTime = this.currentKey.getX509Certificate().getNotBefore().getTime() + (long)(this.pingOneAdminService.getClientAuthnKeyPairActivationDelaySecs() * 1000)) - System.currentTimeMillis()) > 0L) {
            int activationDelayMinutes = (int)Math.ceil((double)activationDelay / 1000.0 / 60.0);
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record("The current key may not yet be active in PingOne. Please wait " + activationDelayMinutes + " minute(s) before rotating the key.", ValidationConstraint.REQUIRED);
        }
        if (this.getDelegate().getHasErrors()) {
            return;
        }
        try {
            this.pingOneUpdateSuccessful = false;
            this.pingOneAdminService.rotateClientAuthnKeyPair();
            this.currentKey = this.pingOneAdminService.getClientAuthnKeyPair();
            this.previousKey = this.pingOneAdminService.getPreviousClientAuthnKeyPair();
            this.rotated = true;
        }
        catch (IOException e) {
            this.log.error((Object)"An error occurred while uploading a new key pair to PingOne", (Throwable)e);
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record("An error occurred while uploading the new key to PingOne. Please check your network configuration. See server logs for more details.", ValidationConstraint.REQUIRED);
        }
    }

    public boolean isKeyRotationEnabled() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        if (!user.isAdmin()) {
            return false;
        }
        if (this.disconnectRequested) {
            return false;
        }
        return !this.rotated;
    }

    public boolean isDisconnectEnabled() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        if (!user.isAdmin()) {
            return false;
        }
        return !this.disconnectRequested && !this.confirmUpdatePingOne;
    }

    public void disconnectFromPingOne() {
        AdminAuthManager adminAuthManager = AdminAuthManager.getInstance();
        if (adminAuthManager.isNative() && !adminAuthManager.hasAdminManager()) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record("Disconnecting from PingOne will disable administrative console single sign-on. Please go to Administrative Accounts and create a User Admin before disconnecting.", ValidationConstraint.REQUIRED);
        } else {
            this.disconnectRequested = true;
            this.pingOneUpdateSuccessful = false;
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        AdminAuthManager adminAuthManager;
        if (!this.enableAdminConsoleSso && (adminAuthManager = AdminAuthManager.getInstance()).isNative() && !adminAuthManager.hasAdminManager()) {
            delegate.setFormComponent(null);
            delegate.record("Please go to Administrative Accounts and create a User Admin before disabling administrative console single sign-on.", ValidationConstraint.REQUIRED);
        }
    }

    public boolean isDisconnectRequested() {
        return this.disconnectRequested;
    }

    public String getDisconnectMessage() {
        StringBuilder message = new StringBuilder("You are about to disconnect this PingFederate environment from PingOne for Enterprise");
        SpConnection spConn = this.pingOneAdminService.getSpConnectionFactory().getManagedSpConnection();
        ConnectionBase provisioningConnection = pingIdInitialSetupAdminService.getProvisioningConnection();
        PasswordCredentialValidatorInstance pcv = pingIdInitialSetupAdminService.getPCV();
        boolean componentsDeleted = false;
        StringBuilder components = new StringBuilder();
        componentsDeleted = this.addToMessage(spConn, components, " PingOne SSO connection", componentsDeleted, null);
        componentsDeleted = this.addToMessage(provisioningConnection, components, " PingID provisioning connection", componentsDeleted, pcv == null ? " and" : ",");
        if (componentsDeleted = this.addToMessage(pcv, components, " PingID PCV", componentsDeleted, " and")) {
            message.append(" which will delete the");
            message.append((CharSequence)components);
        }
        message.append(". Click Save to continue.");
        return message.toString();
    }

    private boolean addToMessage(Object object, StringBuilder existingMessage, String message, boolean componentsDeleted, String prefix) {
        if (object != null) {
            if (componentsDeleted) {
                existingMessage.append(prefix);
            }
            existingMessage.append(message);
            componentsDeleted = true;
        }
        return componentsDeleted;
    }

    public void cancelUpdatePingOne() {
        this.confirmUpdatePingOne = false;
    }

    public boolean isUpdatePingOneVisible() {
        SpConnectionFactory connFactory = this.pingOneAdminService.getSpConnectionFactory();
        SpConnection spConn = connFactory.getManagedSpConnection();
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsMgr.getLocalSettings();
        return localSettings.isEnableSamlIdP() && spConn != null && spConn.isActive();
    }

    public boolean isUpdatePingOneEnabled() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        if (!user.isAdmin()) {
            return false;
        }
        return !this.confirmUpdatePingOne && !this.disconnectRequested;
    }

    public boolean isConfirmUpdatePingOne() {
        return this.confirmUpdatePingOne;
    }

    public void requestUpdatePingOne() {
        this.confirmUpdatePingOne = true;
        this.pingOneUpdateSuccessful = false;
    }

    public void updatePingOne() {
        this.confirmUpdatePingOne = false;
        SpConnectionFactory connFactory = MgmtFactory.getPingOneAdminService().getSpConnectionFactory();
        if (MgmtFactory.getMediator().isDistributable() && !connFactory.hasSavedIdpMetadata()) {
            this.recordErrorMsg("Please replicate configuration changes before updating the identity repository.");
            return;
        }
        try {
            MgmtFactory.getPingOneAdminService().getSpConnectionFactory().uploadIdpMetadata();
            this.pingOneUpdateSuccessful = true;
        }
        catch (IOException e) {
            this.recordErrorMsg("An error occurred while updating the PingOne Identity Repository. Please check your network configuration. See server logs for more details.");
            this.log.error((Object)"An error occurred while uploading IdP metadata to PingOne", (Throwable)e);
        }
    }

    public boolean isPingOneUpdateSuccessful() {
        return this.pingOneUpdateSuccessful;
    }

    private void doDisconnect() {
        PasswordCredentialValidatorInstance pcv;
        ConnectionBase pingIdConnection;
        this.pingOneAdminService.disassociate();
        SpConnection spConn = this.pingOneAdminService.getSpConnectionFactory().getManagedSpConnection();
        if (spConn != null && spConn.isActive()) {
            connectionManager.deleteSpConnection(spConn);
        }
        if ((pingIdConnection = pingIdInitialSetupAdminService.getProvisioningConnection()) != null) {
            connectionManager.deleteSpConnection((SpConnection)pingIdConnection);
            pingIdInitialSetupAdminService.saveProvisioningConnectionId(null);
        }
        if ((pcv = pingIdInitialSetupAdminService.getPCV()) != null) {
            MgmtFactory.getCredentialValidatorManager().deleteInstance((ConfigurablePluginInstance)pcv);
            pingIdInitialSetupAdminService.savePcvId(null);
        }
        this.pingOneAdminService.getSpConnectionFactory().clearManagedSpConnection();
    }

    public void loadIdpConfigTasklet() {
        IdpConfigurationTasklet tasklet = new IdpConfigurationTasklet(this.getVisit());
        tasklet.setParentTasklet(this.getParent());
        this.loadTasklet(tasklet);
    }

    public void loadPingIDConfigTasklet() {
        PingIDSetupTasklet tasklet = new PingIDSetupTasklet(this.getVisit());
        tasklet.setParentTasklet(this.getParent());
        this.loadTasklet(tasklet);
    }

    public void loadFullWizard() {
        UsecasesSetupTasklet tasklet = new UsecasesSetupTasklet(this.getVisit());
        tasklet.setParentTasklet(this.getParent());
        this.loadTasklet(tasklet);
    }

    public String getPingIdConnectionName() {
        return BridgeHelper.getInstance().getPingIdConnectionName();
    }

    public String getPingIdPcvName() {
        return BridgeHelper.getInstance().getPingIdPcvName();
    }

    public boolean showFullWizard() {
        BridgeHelper helper = BridgeHelper.getInstance();
        return !helper.isPingIDConfigured() && !helper.isPingOneSSOConfigured();
    }

    public boolean showPingIdWizard() {
        PluginUtils<PluginDescriptor, PasswordCredentialValidatorInstance> pluginUtils = PluginUtils.newPasswordCredentialManagerUtils();
        return pluginUtils.isPluginInstalled("com.pingidentity.plugins.pcvs.pingid.PingIdPCV") && !BridgeHelper.getInstance().isPingIDConfigured();
    }

    public boolean showPingOneSsoWizard() {
        return !BridgeHelper.getInstance().isPingOneSSOConfigured();
    }

    private BridgeHelper.BridgeMode getBridgeMode() {
        return BridgeHelper.getInstance().getBridgeMode();
    }

    public boolean isP1SpConnectionCreated() {
        return this.pingOneAdminService.getSpConnectionFactory().getManagedSpConnection() != null;
    }
}

