/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigPluginContractTasklet;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.plugins.AdapterContractMappingModel;
import com.pingidentity.util.MappingUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.SourceType;

public class PluginContractFulfillmentMappingState
extends MappingState
implements Serializable {
    public PluginContractFulfillmentMappingState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Adapter Contract Fulfillment");
        this.model = new AdapterContractMappingModel("Contract", null, this.getCurrentUser());
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.attributeMapping = ((IdpAuthnAdapterInstance)dataFromDisk).getAttributeMapping();
        this.model = new AdapterContractMappingModel("Contract", this.attributeMapping, this.getCurrentUser());
        this.updateAttributeMapping();
        this.setDefaultMappingType();
    }

    private void updateAttributeMapping() {
        if (this.model.getMapping() != null) {
            Collection targetAttributes = this.getTarget();
            Set existingAttributes = this.model.getMapping().getAttributeMapping().keySet();
            for (String targetAttribute : targetAttributes) {
                if (existingAttributes.contains(targetAttribute)) continue;
                ArrayList<AttrMappingValue> attrMappingValueList = new ArrayList<AttrMappingValue>();
                attrMappingValueList.add(new AttrMappingValue(SourceType.ADAPTER, targetAttribute));
                this.model.getMapping().getAttributeMapping().put(targetAttribute, attrMappingValueList);
            }
            HashSet<String> removeTheseAttributes = new HashSet<String>();
            for (String existingAttribute : existingAttributes) {
                if (targetAttributes.contains(existingAttribute)) continue;
                removeTheseAttributes.add(existingAttribute);
            }
            for (String removeThisAttribute : removeTheseAttributes) {
                this.model.getMapping().getAttributeMapping().remove(removeThisAttribute);
            }
        }
    }

    private void setDefaultMappingType() {
        if (this.model.getMapping() != null) {
            if (!this.model.getMapping().getAttributeMapping().isEmpty()) {
                Map map = this.model.getMapping().getAttributeMapping();
                for (String attrName : map.keySet()) {
                    for (AttrMappingValue attrMappingValue : (List)map.get(attrName)) {
                        if (attrMappingValue.getType() == null || !attrMappingValue.getType().equals((Object)SourceType.ADAPTER)) continue;
                        attrMappingValue.setValue(attrName);
                    }
                }
            } else {
                HashMap attributeMap = new HashMap();
                for (String attributeName : this.getTarget()) {
                    ArrayList<AttrMappingValue> attrMappingValueList = new ArrayList<AttrMappingValue>();
                    attrMappingValueList.add(new AttrMappingValue(SourceType.ADAPTER, attributeName));
                    attributeMap.put(attributeName, attrMappingValueList);
                }
                this.model.getMapping().setAttributeMap2(attributeMap);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (((IdpAuthnAdapterInstance)dataToDisk).getAttributeMapping() != null) {
            AttributeMapping attributeMapping = ((IdpAuthnAdapterInstance)dataToDisk).getAttributeMapping();
            attributeMapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        }
        return true;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        ConfigPluginContractTasklet tasklet = this.findParent(ConfigPluginContractTasklet.class);
        tasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
        MappingUtil mappingUtil = new MappingUtil();
        mappingUtil.addExtendedPropertiesToSelectionSources(this.sources);
        this.setDefaultMappingType();
    }

    public Set<String> getTarget() {
        ConfigPluginContractTasklet parentTasklet = this.findParent(ConfigPluginContractTasklet.class);
        return new HashSet<String>(parentTasklet.getAllAttrNamesSorted());
    }

    @Override
    public AdapterContractMappingModel getModel() {
        return (AdapterContractMappingModel)super.getModel();
    }

    @Override
    public boolean onStateExit() {
        this.updateAttributeMapping();
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.updateAttributeMapping();
        super.doSummary(summaryList);
    }
}

