/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigPluginContractTasklet;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class PluginContractState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;
    private IdpAuthnAdapterInstance adapterInstance;
    private Object populateAllStatesData;
    private boolean overridingAdapterContractMapping;
    private String oldParentId = "";
    private boolean isPopulated = false;

    public PluginContractState(Tasklet value) {
        super(value);
        this.setMenuName("Adapter Contract Mapping");
    }

    @Override
    public void onStateActivated() {
        if (this.isOverridingExtendedContract()) {
            this.setOverridingAdapterContractMapping(true);
        }
        String newParentId = this.getParentInstanceId();
        if (!this.isPopulated || !newParentId.equals(this.oldParentId) && !this.isOverridingAdapterContractMapping()) {
            this.populateTasklet();
        }
        this.oldParentId = newParentId;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.adapterInstance = (IdpAuthnAdapterInstance)dataFromDisk;
        this.populateTasklet();
        if (this.getHasParentInstance()) {
            this.oldParentId = this.getParentInstanceId();
            if (this.adapterInstance != null) {
                this.setOverridingAdapterContractMapping(!this.adapterInstance.isInheritingAttributeMapping());
            }
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = ((IdpAuthnAdapterInstance)data).getAttributeMapping();
        this.populateTasklet();
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.getHasParentInstance() && !this.isOverridingAdapterContractMapping()) {
            IdpAuthnAdapterInstance plugin = (IdpAuthnAdapterInstance)dataToDisk;
            plugin.setInheritingAttributeMapping(true);
            plugin.setAttributeMapping(new AttributeMapping());
            return true;
        }
        return super.save(dataToDisk);
    }

    private void populateTasklet() {
        ConfigPluginContractTasklet tasklet = this.getTaskletToEdit(ConfigPluginContractTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(ConfigPluginContractTasklet.class);
        }
        if (this.getHasParentInstance() && !this.isAdapterMappingConfigured()) {
            PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
            PluginManager<?, ?> pluginManager = parentTasklet.getPluginManager();
            ConfigurablePluginInstance plugin = pluginManager.getInstance(parentTasklet.getParentPluginInstanceId());
            tasklet.setMode(Mode.edit);
            tasklet.populate(plugin);
        } else if (this.adapterInstance != null) {
            tasklet.setMode(Mode.edit);
            tasklet.populate(this.adapterInstance);
        }
        if (this.populateAllStatesData != null) {
            tasklet.populateAllStates(this.populateAllStatesData);
        }
        this.setTasklet(tasklet);
        this.isPopulated = true;
    }

    public String getParentInstanceId() {
        String tmp = this.getParent(PluginInstanceApi.class).getParentPluginInstanceId();
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    private boolean isAdapterMappingConfigured() {
        return this.adapterInstance != null && !this.adapterInstance.getAttributeMapping().getAttributeMapping().isEmpty();
    }

    public boolean getHasParentInstance() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        return parentTasklet.getParentPluginInstanceId() != null;
    }

    public boolean isConfigureContractDisabled() {
        return this.getHasParentInstance() && !this.isOverridingAdapterContractMapping();
    }

    public boolean isOverridingAdapterContractMapping() {
        return this.overridingAdapterContractMapping;
    }

    public void setOverridingAdapterContractMapping(boolean overridingAdapterContract) {
        this.setValidationForACM(overridingAdapterContract);
        this.overridingAdapterContractMapping = overridingAdapterContract;
    }

    private void setValidationForACM(boolean enableValidation) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet != null && tasklet instanceof ConfigPluginContractTasklet) {
            ((ConfigPluginContractTasklet)tasklet).turnOnValidation(enableValidation);
        }
    }

    public void turnOnValidation(boolean enableValidation) {
        this.setValidationForACM(enableValidation);
    }

    public boolean isOverridingAttributeContractDisabled() {
        return this.isOverridingExtendedContract();
    }

    private boolean isOverridingExtendedContract() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        PluginDescriptor descriptor = parentTasklet.getSelectedDescriptor();
        if (descriptor != null && descriptor.isSupportsExtendedContract()) {
            return !parentTasklet.isInheritingContract();
        }
        return false;
    }
}

