/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.RedirectValidationUriAllowlistEntry;
import org.sourceid.saml20.domain.RedirectValidationWhitelistEntry;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;

public class RedirectValidationState
extends TaskletState
implements TableEditor.TableEditorListener {
    private transient Object uriAllowlistEditorState;
    private static final long serialVersionUID = 3L;
    private List<TableRow> whitelist;
    private List<TableRow> uriAllowlist;
    private boolean enableTargetResourceValidationForSSO = true;
    private boolean enableTargetResourceValidationForSLOAndOther = false;
    private boolean enableTargetResourceValidationForIdpDiscovery = false;
    private boolean enableInErrorResourceValidation = false;
    private String defaultTarget;
    private transient Object componentState;
    TargetResourceValidationMgr mgr = (TargetResourceValidationMgr)GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private final SimpleFieldDescriptor REQUIRE_HTTPS = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Require HTTPS", 120, false, "true");
    private final SimpleFieldDescriptor VALID_DOMAIN_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Valid Domain Name (leading wildcard '*.' allowed)", 200);
    private final SimpleFieldDescriptor VALID_PATH_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Valid Path (leave blank to allow any path)", 275);
    private final SimpleFieldDescriptor ALLOW_QUERY_FRAGMENT_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Allow Any Query/Fragment", 120);
    private final SimpleFieldDescriptor TARGET_RESOURCE_FOR_SSO = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "TargetResource for SSO", 120){

        @Override
        public boolean isHidden() {
            return !RedirectValidationState.this.enableTargetResourceValidationForSSO;
        }
    };
    private final SimpleFieldDescriptor TARGET_RESOURCE_FOR_SLO_AND_OTHER = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "TargetResource for SLO and Other", 120){

        @Override
        public boolean isHidden() {
            return !RedirectValidationState.this.enableTargetResourceValidationForSLOAndOther;
        }
    };
    private final SimpleFieldDescriptor IN_ERROR_RESOURCE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "InErrorResource", 120){

        @Override
        public boolean isHidden() {
            return !RedirectValidationState.this.enableInErrorResourceValidation;
        }
    };
    private final SimpleFieldDescriptor IDP_DISCOVERY = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "IdP Discovery", 120){

        @Override
        public boolean isHidden() {
            return !RedirectValidationState.this.enableTargetResourceValidationForIdpDiscovery || !RedirectValidationState.this.isShowTargetResourceValidationForIdpDiscovery();
        }
    };
    private final SimpleFieldDescriptor VALID_URI_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Valid URI (Wildcards '*' allowed)", 400);
    private List<SimpleFieldDescriptor> WHITELIST_COLUMN_DESCRIPTORS;
    private List<SimpleFieldDescriptor> URI_ALLOWLIST_COLUMN_DESCRIPTORS;

    public RedirectValidationState(Tasklet parent) {
        super(parent);
        this.setMenuName("Local Redirect Validation");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.uriAllowlistEditorState = null;
        this.whitelist = new ArrayList<TableRow>();
        for (RedirectValidationWhitelistEntry entry : this.mgr.getExtendedWhitelist()) {
            if (this.mgr.isRequireHttps() != null) {
                entry.setRequireHttps(this.mgr.isRequireHttps().booleanValue());
                entry.setTargetResourceSSO(true);
            }
            this.whitelist.add(this.makeWhitelistRowFromEntry(entry));
        }
        this.uriAllowlist = new ArrayList<TableRow>();
        for (RedirectValidationWhitelistEntry entry : this.mgr.getExtendedUriAllowlist()) {
            this.uriAllowlist.add(this.makeUriAllowlistRowFromEntry((RedirectValidationUriAllowlistEntry)entry));
        }
        this.enableTargetResourceValidationForSSO = this.mgr.isEnableValidationTargetResourceSSO();
        this.enableTargetResourceValidationForSLOAndOther = this.mgr.isEnableValidationTargetResourceSLOAndOther();
        this.enableInErrorResourceValidation = this.mgr.isEnableValidationInErrorResource();
        this.enableTargetResourceValidationForIdpDiscovery = this.mgr.isEnableValidationTargetResourceIdpDiscovery();
        LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();
        LocalSettings settings = localSettingsManager.getLocalSettings();
        settings.getSpSsoSuccessUrl();
        this.defaultTarget = settings.getSpSsoSuccessUrl();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isNotBlank((String)((TableEditor.State)this.uriAllowlistEditorState).getNewItem().getFields().get(0).getValue())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Finish_editing"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.uriAllowlistEditorState = null;
        this.mgr.getConfig().clearValue("require-https");
        ArrayList<RedirectValidationWhitelistEntry> whitelistEntries = new ArrayList<RedirectValidationWhitelistEntry>();
        for (TableRow row : this.whitelist) {
            if (row.isMarkedForDelete()) continue;
            whitelistEntries.add(new RedirectValidationWhitelistEntry(this.getValidDomain(row), this.getValidPath(row), this.getAllowQueryFragment(row), this.getRequireHttps(row), this.getTargetResourceSSO(row), this.getTargetResourceSLO(row), this.getInErrorResource(row), this.getIdpDiscovery(row)));
        }
        ArrayList<RedirectValidationUriAllowlistEntry> uriAllowlistEntries = new ArrayList<RedirectValidationUriAllowlistEntry>();
        for (TableRow row : this.uriAllowlist) {
            if (row.isMarkedForDelete()) continue;
            uriAllowlistEntries.add(new RedirectValidationUriAllowlistEntry(row.getFields().get(0).getValue(), Boolean.parseBoolean(row.getFields().get(1).getValue()), Boolean.parseBoolean(row.getFields().get(2).getValue()), Boolean.parseBoolean(row.getFields().get(3).getValue()), Boolean.parseBoolean(row.getFields().get(4).getValue()), Boolean.parseBoolean(row.getFields().get(5).getValue())));
        }
        this.mgr.setExtendedWhitelist(whitelistEntries);
        this.mgr.setExtendedUriAllowlist(uriAllowlistEntries);
        this.mgr.setEnableValidationTargetResourceSSO(this.enableTargetResourceValidationForSSO);
        this.mgr.setEnableValidationTargetResourceSLOAndOther(this.enableTargetResourceValidationForSLOAndOther);
        this.mgr.setEnableValidationInErrorResource(this.enableInErrorResourceValidation);
        this.mgr.setEnableValidationTargetResourceIdpDiscovery(this.enableTargetResourceValidationForIdpDiscovery);
        return true;
    }

    public String getDefaultTargetText() {
        return StringUtils.isBlank((String)this.defaultTarget) ? this.getMessage("No_default_target") : this.getMessage("Has_default_target");
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<TableRow> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<TableRow> whitelist) {
        this.whitelist = whitelist;
    }

    public List<TableRow> getUriAllowlist() {
        return this.uriAllowlist;
    }

    public void setUriAllowlist(List<TableRow> uriAllowlist) {
        this.uriAllowlist = uriAllowlist;
    }

    @Override
    public List<String> validate(TableRow updatedRow, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        if (owner.getState().equals(this.componentState)) {
            errors.addAll(this.mgr.validateDomain(this.getValidDomain(updatedRow)));
            errors.addAll(this.mgr.validatePath(this.getValidPath(updatedRow), this.getAllowQueryFragment(updatedRow)));
        } else {
            errors.addAll(this.mgr.validateUri(updatedRow.getFields().get(0).getValue().trim()));
        }
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow newRow) {
    }

    public List<SimpleFieldDescriptor> getWhitelistColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.REQUIRE_HTTPS);
        tableList.add(this.VALID_DOMAIN_DESC);
        tableList.add(this.VALID_PATH_DESC);
        tableList.add(this.ALLOW_QUERY_FRAGMENT_DESC);
        tableList.add(this.TARGET_RESOURCE_FOR_SSO);
        tableList.add(this.TARGET_RESOURCE_FOR_SLO_AND_OTHER);
        tableList.add(this.IN_ERROR_RESOURCE);
        tableList.add(this.IDP_DISCOVERY);
        this.WHITELIST_COLUMN_DESCRIPTORS = tableList;
        return this.WHITELIST_COLUMN_DESCRIPTORS;
    }

    public List<SimpleFieldDescriptor> getUriAllowlistColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.VALID_URI_DESC);
        tableList.add(this.ALLOW_QUERY_FRAGMENT_DESC);
        tableList.add(this.TARGET_RESOURCE_FOR_SSO);
        tableList.add(this.TARGET_RESOURCE_FOR_SLO_AND_OTHER);
        tableList.add(this.IN_ERROR_RESOURCE);
        tableList.add(this.IDP_DISCOVERY);
        this.URI_ALLOWLIST_COLUMN_DESCRIPTORS = tableList;
        return this.URI_ALLOWLIST_COLUMN_DESCRIPTORS;
    }

    protected TableRow makeWhitelistRowFromEntry(RedirectValidationWhitelistEntry entry) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.REQUIRE_HTTPS, Boolean.toString(entry.isRequireHttps())));
        fields.add(new FieldItem(this.VALID_DOMAIN_DESC, entry.getValidDomain()));
        fields.add(new FieldItem(this.VALID_PATH_DESC, entry.getValidPath()));
        fields.add(new FieldItem(this.ALLOW_QUERY_FRAGMENT_DESC, Boolean.toString(entry.isAllowQueryAndFragment())));
        fields.add(new FieldItem(this.TARGET_RESOURCE_FOR_SSO, Boolean.toString(entry.isTargetResourceSSO())));
        fields.add(new FieldItem(this.TARGET_RESOURCE_FOR_SLO_AND_OTHER, Boolean.toString(entry.isTargetResourceSLO())));
        fields.add(new FieldItem(this.IN_ERROR_RESOURCE, Boolean.toString(entry.isInErrorResource())));
        fields.add(new FieldItem(this.IDP_DISCOVERY, Boolean.toString(entry.isIdpDiscovery())));
        return new TableRow(fields);
    }

    protected TableRow makeUriAllowlistRowFromEntry(RedirectValidationUriAllowlistEntry entry) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.VALID_URI_DESC, entry.getValidUri()));
        fields.add(new FieldItem(this.ALLOW_QUERY_FRAGMENT_DESC, Boolean.toString(entry.isAllowQueryAndFragment())));
        fields.add(new FieldItem(this.TARGET_RESOURCE_FOR_SSO, Boolean.toString(entry.isTargetResourceSSO())));
        fields.add(new FieldItem(this.TARGET_RESOURCE_FOR_SLO_AND_OTHER, Boolean.toString(entry.isTargetResourceSLO())));
        fields.add(new FieldItem(this.IN_ERROR_RESOURCE, Boolean.toString(entry.isInErrorResource())));
        fields.add(new FieldItem(this.IDP_DISCOVERY, Boolean.toString(entry.isIdpDiscovery())));
        return new TableRow(fields);
    }

    protected String getValidUri(TableRow row) {
        return row.getFields().get(0).getValue().trim();
    }

    protected boolean getRequireHttps(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(0).getValue().trim());
    }

    protected String getValidDomain(TableRow row) {
        return row.getFields().get(1).getValue().trim();
    }

    protected String getValidPath(TableRow row) {
        return row.getFields().get(2).getValue().trim();
    }

    protected boolean getAllowQueryFragment(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(3).getValue().trim());
    }

    protected boolean getTargetResourceSSO(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(4).getValue().trim());
    }

    protected boolean getTargetResourceSLO(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(5).getValue().trim());
    }

    protected boolean getInErrorResource(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(6).getValue().trim());
    }

    protected boolean getIdpDiscovery(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(7).getValue().trim());
    }

    public boolean isEnableTargetResourceValidationForSSO() {
        return this.enableTargetResourceValidationForSSO;
    }

    public void setEnableTargetResourceValidationForSSO(boolean enableTargetResourceValidationForSSO) {
        this.enableTargetResourceValidationForSSO = enableTargetResourceValidationForSSO;
    }

    public boolean isEnableTargetResourceValidationForSLOAndOther() {
        return this.enableTargetResourceValidationForSLOAndOther;
    }

    public void setEnableTargetResourceValidationForSLOAndOther(boolean enableTargetResourceValidationForSLOAndOther) {
        this.enableTargetResourceValidationForSLOAndOther = enableTargetResourceValidationForSLOAndOther;
    }

    public boolean isEnableInErrorResourceValidation() {
        return this.enableInErrorResourceValidation;
    }

    public void setEnableInErrorResourceValidation(boolean enableInErrorResourceValidation) {
        this.enableInErrorResourceValidation = enableInErrorResourceValidation;
    }

    public boolean isEnableTargetResourceValidationForIdpDiscovery() {
        return this.enableTargetResourceValidationForIdpDiscovery;
    }

    public void setEnableTargetResourceValidationForIdpDiscovery(boolean enableTargetResourceValidationForIdpDiscovery) {
        this.enableTargetResourceValidationForIdpDiscovery = enableTargetResourceValidationForIdpDiscovery;
    }

    public boolean isShowTargetResourceValidationForIdpDiscovery() {
        return this.mgr.isIdpDiscoveryAndCommonDomainClient();
    }

    public Object getUriAllowlistEditorState() {
        return this.uriAllowlistEditorState;
    }

    public void setUriAllowlistEditorState(Object uriAllowlistEditorState) {
        this.uriAllowlistEditorState = uriAllowlistEditorState;
    }
}

