/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeRequester;

public class RetrievableAttributesState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private AttributeContract retrievableAttributes = new AttributeContract();
    private transient Object componentState;

    public RetrievableAttributesState(Tasklet value) {
        super(value);
        this.setMenuName("Retrievable Attributes");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.componentState = null;
        AttributeRequester attributeRequester = (AttributeRequester)dataFromDisk;
        this.retrievableAttributes = new AttributeContract();
        if (attributeRequester != null) {
            HashSet attributeFilterList = new HashSet(attributeRequester.getAttributeFilterList());
            this.retrievableAttributes.setMutableAttributeNames(attributeFilterList);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeRequester tempAttributeRequester = (AttributeRequester)dataToDisk;
        tempAttributeRequester.setAttributeFilterList(new HashSet(this.retrievableAttributes.getMutableAttributeNames()));
        return true;
    }

    @Override
    public void reset() {
        this.componentState = null;
        this.retrievableAttributes = new AttributeContract();
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String item : this.retrievableAttributes.getAllAttrNamesSorted()) {
            summaryList.add(new SummaryInfo("Attribute", item, this));
        }
    }

    public AttributeContract getRetrievableAttributes() {
        return this.retrievableAttributes;
    }

    public void setRetrievableAttributes(AttributeContract retrievableAttributes) {
        this.retrievableAttributes = retrievableAttributes;
    }
}

