/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.impl.SpAuthnSourceMappingTasklet;
import com.pingidentity.util.ExtStringPropertySelectionModel;
import com.pingidentity.util.SAML2MappingModel;
import java.util.HashMap;
import java.util.List;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.AttributeMapping;

public class SPAttributeSourceMappingState
extends MappingState {
    private static final long serialVersionUID = 1L;
    private boolean validateTextField = true;

    public SPAttributeSourceMappingState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Contract Fulfillment");
        this.model.setTargetName("Attribute Contract");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.attributeMapping = (AttributeMapping)dataFromDisk;
        this.model = new SAML2MappingModel("Attribute Contract", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping outmap = (AttributeMapping)dataToDisk;
        outmap.setAttributeMap(this.model.getMapping().getAttributeMap());
        return true;
    }

    @Override
    public void onStateActivated() {
        ExpressionManager expressionManager;
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        SpAuthnSourceMappingTasklet authnSourceTasklet = this.findParent(SpAuthnSourceMappingTasklet.class);
        if (authnSourceTasklet != null) {
            authnSourceTasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        }
        if ((expressionManager = ExpressionManager.getInstance()).isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        this.sources.addTextSource("Text");
        AttributeSourceApi parent = this.findParent(AttributeSourceApi.class);
        ExtStringPropertySelectionModel propSelectionModel = null;
        propSelectionModel = parent.getType().equals("JDBC") ? new ExtStringPropertySelectionModel(parent.getSelectedColumns().toArray(new String[parent.getSelectedColumns().size()])) : (parent.getType().equals("LDAP") ? new ExtStringPropertySelectionModel(parent.getSelectedAttributes().toArray(new String[parent.getSelectedAttributes().size()])) : new ExtStringPropertySelectionModel(parent.getSelectedFields().toArray(new String[parent.getSelectedFields().size()])));
        String selectionLabel = parent.getType() + " (" + parent.getDescription() + ")";
        this.sources.addPropertySelectionSource(parent.getType(), null, selectionLabel, (IPropertySelectionModel)propSelectionModel);
        this.sources.setValidateTextField(this.validateTextField);
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
    }

    @Override
    public void reset() {
        this.model = new SAML2MappingModel(this.getCurrentUser());
    }

    public List<String> getTarget() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }

    public boolean isValidateTextField() {
        return this.validateTextField;
    }

    public void setValidateTextField(boolean validateTextField) {
        this.validateTextField = validateTextField;
    }
}

