/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.SpAuthnSourceMappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;

public class SPDefaultAttributeMappingState
extends MappingState
implements Serializable {
    private static final long serialVersionUID = 1L;

    public SPDefaultAttributeMappingState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Contract Fulfillment");
        this.model.setTargetName("Attribute Contract");
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        SpAuthnSourceMappingTasklet parent = this.findParent(SpAuthnSourceMappingTasklet.class);
        parent.addStandardSourcesToPropertySelectionSources(this.sources);
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        this.sources.addTextSource("Text");
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
    }

    @Override
    public String getHelpId() {
        SpAuthnSourceMappingTasklet parent = this.findParent(SpAuthnSourceMappingTasklet.class);
        if (parent.isUseOtherValuesWithOneMapping()) {
            return super.getHelpId();
        }
        return super.getHelpId() + "_Failsafe";
    }

    @Override
    public void populate(Object dataFromDisk) {
        AuthnSourceToAssertionMapping authnSourceToAssertionMapping = (AuthnSourceToAssertionMapping)dataFromDisk;
        this.model = new SAML2MappingModel("Attribute Contract", authnSourceToAssertionMapping.getDefaultAttributeMapping(), this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        AuthnSourceToAssertionMapping tempMapping = (AuthnSourceToAssertionMapping)dataToDisk;
        tempMapping.getDefaultAttributeMapping().setAttributeMap2(this.model.getMapping().getAttributeMapping());
        return true;
    }

    public List<String> getTarget() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }

    @Override
    public String getNoteKey() {
        SpAuthnSourceMappingTasklet spAuthnSourceMappingTasklet = this.getParent(SpAuthnSourceMappingTasklet.class);
        if (spAuthnSourceMappingTasklet.isUseOtherValuesWithOneMapping()) {
            return super.getNoteKey() + "_UseOtherValuesOneMapping";
        }
        if (spAuthnSourceMappingTasklet.isUseOtherValuesWithMultipleMappings()) {
            return super.getNoteKey() + "_UseOtherValues";
        }
        return super.getNoteKey();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return !this.model.isTestingExpression();
    }
}

