/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.BaseSelectPluginTypeState;
import com.pingidentity.fsm.state.impl.PluginMgmtState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailProcessorDescriptor;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.validation.CommonValidator;

public class SelectAdapterTypeState
extends BaseSelectPluginTypeState {
    private static final long serialVersionUID = 20050121L;
    private static final String NO_PARENT_LABEL = "None";
    private String parentPluginInstanceId;
    private String previousSelectedPluginType;

    public SelectAdapterTypeState(IWizard owner) {
        super(owner);
        this.setMenuName("Type");
    }

    public StringPairPropertySelectionModel getPluginSourceList() {
        return this.getDescriptorTypeList();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        String componentPluginName = "pluginName";
        String componentPluginId = "pluginId";
        if (component != null) {
            IFormComponent ic;
            if (this.isNewTasklet()) {
                PluginInstanceTasklet pluginInstanceTasklet;
                PluginManager<?, ?> pluginMgr;
                this.valideDescriptorRequired(delegate, component);
                if (StringUtils.isBlank((String)this.getPluginId())) {
                    ic = (IFormComponent)component.getComponent("pluginId");
                    delegate.setFormComponent(ic);
                    delegate.record(this.getMessage("Id_required"), ValidationConstraint.REQUIRED);
                }
                if (!CommonValidator.isValidAdapterInstanceId((String)this.getPluginId())) {
                    ic = (IFormComponent)component.getComponent("pluginId");
                    delegate.setFormComponent(ic);
                    int max = 33;
                    Object[] objects = new Object[]{max};
                    delegate.record(this.getMessage("Invalid_plugin_instance_id", objects), ValidationConstraint.REQUIRED);
                }
                if ((pluginMgr = (pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent()).getPluginManager()) != null && pluginMgr.isDuplicateId(this.getPluginId())) {
                    IFormComponent ic2 = (IFormComponent)component.getComponent("pluginId");
                    delegate.setFormComponent(ic2);
                    delegate.record(this.getMessage("Plugin_id_in_use"), ValidationConstraint.REQUIRED);
                }
            }
            if (StringUtils.isBlank((String)this.getPluginName())) {
                ic = (IFormComponent)component.getComponent("pluginName");
                delegate.setFormComponent(ic);
                delegate.record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            } else if (!this.getOrigPluginName().equals(this.getPluginName()) && this.isDuplicateInstanceName(this.getPluginName())) {
                ic = (IFormComponent)component.getComponent("pluginName");
                delegate.setFormComponent(ic);
                delegate.record(this.getMessage("Plugin_name_in_use"), ValidationConstraint.REQUIRED);
                this.setPluginName(this.getOrigPluginName());
            }
        }
    }

    private boolean isDuplicateInstanceName(String pluginName) {
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent();
        if (pluginInstanceTasklet.isConnectionOverrideMode()) {
            return false;
        }
        PluginMgmtState state = this.findParentState(PluginMgmtState.class);
        return state.isDuplicatePluginName(pluginName);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        PluginInstanceTasklet pluginInstanceTasklet;
        PluginManager<?, ?> pluginMgr;
        summaryList.add(new SummaryInfo(this.getMessage("Plugin_instance_name"), this.getPluginName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Plugin_instance_id"), this.getPluginId(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Plugin_type"), this.getDescriptor().getType(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Plugin_class_name"), this.getDescriptor().getPluginClassName(), this));
        if (this.isBCFIPSMode()) {
            summaryList.add(new SummaryInfo(this.getMessage("Plugin_fips_status"), this.getFipsStatus(), this));
        }
        if (this.getDescriptor() instanceof AuthorizationDetailProcessorDescriptor) {
            AuthorizationDetailProcessorDescriptor descriptor = (AuthorizationDetailProcessorDescriptor)this.getDescriptor();
            summaryList.add(new SummaryInfo(this.getMessage("Authorization_detail_processor_supported_types"), String.join((CharSequence)", ", descriptor.getSupportedAuthorizationDetailTypes()), this));
        }
        if ((pluginMgr = (pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent()).getPluginManager()) != null && pluginMgr.supportsPluginHierarchies()) {
            ConfigurablePluginInstance parentInstance;
            String parentPluginLabel = NO_PARENT_LABEL;
            if (this.getParentPluginInstanceId() != null && (parentInstance = pluginMgr.getInstance(this.parentPluginInstanceId)) != null) {
                parentPluginLabel = parentInstance.getName();
            }
            summaryList.add(new SummaryInfo(this.getMessage("Plugin_parent_name"), parentPluginLabel, this));
        }
    }

    public StringPairPropertySelectionModel getParentPluginInstanceList() {
        StringPairPropertySelectionModel parentsModel = new StringPairPropertySelectionModel(NO_PARENT_LABEL);
        PluginDescriptor selectedDescriptor = this.getDescriptor();
        if (selectedDescriptor == null) {
            this.parentPluginInstanceId = null;
            return parentsModel;
        }
        if (this.previousSelectedPluginType != null && !this.previousSelectedPluginType.equals(selectedDescriptor.getType())) {
            this.parentPluginInstanceId = null;
        }
        this.previousSelectedPluginType = selectedDescriptor.getType();
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent();
        PluginManager<?, ?> pluginMgr = pluginInstanceTasklet.getPluginManager();
        if (pluginMgr != null) {
            for (ConfigurablePluginInstance pluginInstance : pluginMgr.getInstances()) {
                String instanceId = pluginInstance.getId();
                if (!selectedDescriptor.getType().equals(pluginInstance.getDescriptor().getType()) || !this.isNewTasklet() && this.isDescendantOrSelf(pluginMgr, this.getPluginId(), instanceId) || pluginInstance.isConnectionBasedPlugin()) continue;
                parentsModel.add(pluginInstance.getName(), instanceId);
            }
        }
        parentsModel.sort();
        return parentsModel;
    }

    private boolean isDescendantOrSelf(PluginManager<?, ?> pluginMgr, String instanceId, String otherInstanceId) {
        String tmpInstanceId = otherInstanceId;
        while (tmpInstanceId != null) {
            if (tmpInstanceId.equals(instanceId)) {
                return true;
            }
            ConfigurablePluginInstance tmpInstance = pluginMgr.getInstance(tmpInstanceId);
            tmpInstanceId = tmpInstance.getParentId();
        }
        return false;
    }

    public String getParentPluginInstanceId() {
        return this.parentPluginInstanceId;
    }

    public void setParentPluginInstanceId(String parentPluginInstanceId) {
        this.parentPluginInstanceId = parentPluginInstanceId;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.parentPluginInstanceId = ((ConfigurablePluginInstance)dataFromDisk).getParentId();
        super.populate(dataFromDisk);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ((ConfigurablePluginInstance)dataToDisk).setParentId(this.parentPluginInstanceId);
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent();
        if (pluginInstanceTasklet.isConnectionOverrideMode() && connTasklet != null) {
            ((ConfigurablePluginInstance)dataToDisk).setConnectionId(connTasklet.getConnId());
        }
        return super.save(dataToDisk);
    }

    public boolean isSupportsHierarchies() {
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent();
        PluginManager<?, ?> pluginMgr = pluginInstanceTasklet.getPluginManager();
        return pluginMgr.supportsPluginHierarchies();
    }

    public boolean isNewTasklet() {
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent();
        return pluginInstanceTasklet.isNewTasklet();
    }

    @Override
    public String getNoteKey() {
        String baseKey = super.getNoteKey();
        String newTaskletNoteKey = baseKey + "_newstate";
        String editTaskletNoteKey = baseKey + "_existingstate";
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.getParent();
        if (pluginInstanceTasklet.isConnectionOverrideMode()) {
            return editTaskletNoteKey;
        }
        if (this.isNewTasklet()) {
            return newTaskletNoteKey;
        }
        return editTaskletNoteKey;
    }
}

