/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AuthnSourceListApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AssertionCreationTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigC2cMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.UserSessionCreationTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SelectC2cContractState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String selectedContractId = null;
    private String selectedContractName = null;
    private boolean newContractMapping = true;
    private List<String> attributeList = new ArrayList<String>();

    public SelectC2cContractState(Tasklet value) {
        super(value);
        this.setMenuName("Authentication Policy Contract");
    }

    @Override
    public void populate(Object dataFromDisk) {
        String contractId = null;
        if (dataFromDisk instanceof C2cContractAttributeMapping) {
            C2cContractAttributeMapping c2cAttributeMapping = (C2cContractAttributeMapping)dataFromDisk;
            contractId = c2cAttributeMapping.getContractId();
        } else if (dataFromDisk instanceof C2cContractToAssertionMapping) {
            C2cContractToAssertionMapping c2cToAssertionMapping = (C2cContractToAssertionMapping)dataFromDisk;
            contractId = c2cToAssertionMapping.getContractId();
        }
        this.setSelectedContractId(contractId);
        this.newContractMapping = false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof C2cContractAttributeMapping) {
            C2cContractAttributeMapping c2cAttributeMapping = (C2cContractAttributeMapping)dataToDisk;
            c2cAttributeMapping.setContractId(this.selectedContractId);
        } else if (dataToDisk instanceof C2cContractToAssertionMapping) {
            C2cContractToAssertionMapping c2cToAssertionMapping = (C2cContractToAssertionMapping)dataToDisk;
            c2cToAssertionMapping.setContractId(this.selectedContractId);
        }
        return true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.selectedContractId != null) {
            this.createContractAttributeList();
        } else {
            this.attributeList = null;
        }
    }

    @Override
    public void reset() {
        this.selectedContractId = null;
        this.newContractMapping = true;
        this.attributeList = null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedContractId == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("contract_required"), ValidationConstraint.REQUIRED);
        } else if (this.newContractMapping) {
            HashSet<String> mappedContracts = new HashSet<String>();
            boolean isSpConn = false;
            UserSessionCreationTasklet usct = this.findParent(UserSessionCreationTasklet.class);
            if (usct != null) {
                for (IdpC2cContractMappingTasklet idpC2cContractMappingTasklet : usct.getC2cTasklets()) {
                    mappedContracts.add(idpC2cContractMappingTasklet.getContractId());
                }
            } else {
                AssertionCreationTasklet act = this.findParent(AssertionCreationTasklet.class);
                if (act != null) {
                    isSpConn = true;
                    for (SpConfigC2cMappingTasklet t : act.getC2cTasklets()) {
                        mappedContracts.add(t.getContractId());
                    }
                }
            }
            if (!mappedContracts.isEmpty()) {
                String partnerContractId;
                HashMap<String, String> mappedConnIdsToContractId = new HashMap<String, String>();
                HashSet<String> hashSet = new HashSet<String>();
                C2cContractManager c2cMgr = MgmtFactory.getC2cContractManager();
                ConnectionManager connMgr = MgmtFactory.getConnectionManager();
                if (isSpConn) {
                    for (IdpConnection idpConn : connMgr.getAllIdpConnections()) {
                        for (C2cContractAttributeMapping partnerC2cMapping : idpConn.getC2cContractMappings()) {
                            partnerContractId = partnerC2cMapping.getContractId();
                            if (mappedContracts.contains(partnerContractId)) {
                                mappedConnIdsToContractId.put(idpConn.getEntityId(), partnerContractId);
                            }
                            if (!partnerContractId.equals(this.selectedContractId)) continue;
                            hashSet.add(idpConn.getEntityId());
                        }
                    }
                } else {
                    for (SpConnection spConn : connMgr.getAllSpConnections()) {
                        for (C2cContractAttributeMapping partnerC2cMapping : spConn.getC2cMappings()) {
                            partnerContractId = partnerC2cMapping.getContractId();
                            if (mappedContracts.contains(partnerContractId)) {
                                mappedConnIdsToContractId.put(spConn.getEntityId(), partnerContractId);
                            }
                            if (!partnerContractId.equals(this.selectedContractId)) continue;
                            hashSet.add(spConn.getEntityId());
                        }
                    }
                }
                for (String selectedPartnerConnId : hashSet) {
                    if (!mappedConnIdsToContractId.containsKey(selectedPartnerConnId)) continue;
                    String contractId = (String)mappedConnIdsToContractId.get(selectedPartnerConnId);
                    String contractName = c2cMgr.getContract(contractId).getName();
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("partner_conn_already_mapped", new Object[]{selectedPartnerConnId, contractName}), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Selected_contract"), this.selectedContractName, this));
    }

    @Override
    public String getNoteKey() {
        if (this.newContractMapping) {
            String note = this.getTaskletStateId() + "New";
            if (this.getIsOidc()) {
                note = note + "_Oidc";
            }
            return note;
        }
        return super.getNoteKey();
    }

    @Override
    public void refreshState() {
        this.setSelectedContractId(this.selectedContractId);
    }

    private void createContractAttributeList() {
        if (this.selectedContractId == null) {
            this.attributeList = new ArrayList<String>();
            return;
        }
        C2cContractManager c2cManager = MgmtFactory.getC2cContractManager();
        C2cContract contract = c2cManager.getContract(this.selectedContractId);
        if (contract != null) {
            this.attributeList = new ArrayList<String>(contract.getAllAttributeNames());
            Collections.sort(this.attributeList, String.CASE_INSENSITIVE_ORDER);
        } else {
            this.attributeList = new ArrayList<String>();
        }
    }

    public StringPairPropertySelectionModel getContractList() {
        return this.findParent(AuthnSourceListApi.class).getC2cContractList();
    }

    public String getSelectedContractId() {
        return this.selectedContractId;
    }

    public void setSelectedContractId(String newSelectedContractId) {
        if (newSelectedContractId != null) {
            C2cContract contract = MgmtFactory.getC2cContractManager().getContract(newSelectedContractId);
            if (contract != null) {
                this.selectedContractId = contract.getId();
                this.selectedContractName = contract.getName();
            } else {
                this.selectedContractId = null;
                this.selectedContractName = null;
            }
            this.createContractAttributeList();
        }
    }

    public String getSelectedContractName() {
        return this.selectedContractName;
    }

    public List<String> getAttributeList() {
        return this.attributeList;
    }

    public boolean isNewContract() {
        return this.newContractMapping;
    }

    public void setNewContract(boolean newContract) {
        this.newContractMapping = newContract;
    }

    public void refreshName() {
        if (this.selectedContractId != null) {
            C2cContract contract = MgmtFactory.getC2cContractManager().getContract(this.selectedContractId);
            if (contract != null) {
                this.selectedContractName = contract.getName();
            } else {
                this.selectedContractName = null;
                this.selectedContractId = null;
            }
        } else {
            this.selectedContractName = null;
        }
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }
}

