/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

public class SelectCertifyCertState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final String IMPORT_CSR = "importCsr";
    private static final String EXPORT_CSR = "exportCsr";
    private String selectedCsrOper = "exportCsr";
    private CertItem certItem;

    public SelectCertifyCertState(Tasklet value) {
        super(value);
        this.setMenuName("Certificate Signing");
    }

    public boolean importSelected() {
        return IMPORT_CSR.equals(this.selectedCsrOper);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        X509Certificate x509 = this.certItem.getCert().getX509Certificate();
        Principal subjectPrin = x509.getSubjectDN();
        Principal issuerPrin = x509.getIssuerDN();
        Date expiration = x509.getNotAfter();
        summaryList.add(new SummaryInfo("Subject DN", subjectPrin.getName(), this));
        summaryList.add(new SummaryInfo("Issuer DN", issuerPrin.getName(), this));
        summaryList.add(new SummaryInfo("Serial Number", this.certItem.getCert().getSerialNumberForDisplay(), this));
        summaryList.add(new SummaryInfo("Expires", expiration.toString(), this));
    }

    public String getSelectedCsrOper() {
        return this.selectedCsrOper;
    }

    public void setSelectedCsrOper(String selectedCsrOper) {
        this.selectedCsrOper = selectedCsrOper;
    }

    public CertItem getCertItem() {
        return this.certItem;
    }

    public void setCertItem(CertItem certItem) {
        this.certItem = certItem;
    }
}

