/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.JdbcTableValidator;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import com.pingidentity.util.SortUtil;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.StringPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.websso.profiles.sp.provisioning.ProvisioningProcessorManager;

public class SelectDatabaseTableAndColumnsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    protected JdbcDataSource dataSource;
    protected String selectedSchema;
    protected String previouslySelectedSchema;
    private String selectedTable;
    private String previouslySelectedTable;
    private String selectedColumn;
    protected List<String> schemas;
    private List<String> tables;
    private List<String> selectedColumns;
    private List<String> availableColumns;
    private List<String> allColumns;
    private List<ResultInfo> allColumnsWithMetadata;
    protected transient IPropertySelectionModel schemaList;
    private transient IPropertySelectionModel tableList;
    private transient StringPairPropertySelectionModel columnList;
    protected AttributeMapping mapping;
    static final String NO_SCHEMA_LIST = "<schema list not available>";
    private static final String NO_TABLE_LIST = "<table list not available>";
    static final IPropertySelectionModel NO_SCHEMA_MODEL = new StringPropertySelectionModel(new String[]{"<schema list not available>"});
    static final IPropertySelectionModel NO_TABLE_MODEL = new StringPropertySelectionModel(new String[]{"<table list not available>"});
    protected transient Map<String, Object> globalCache;
    protected boolean returnSortedColumnLists;
    private boolean populated;

    public SelectDatabaseTableAndColumnsState(Tasklet value) {
        super(value, "selectDatabaseTableAndColumns");
        this.setMenuName("Database Table and Columns");
    }

    public SelectDatabaseTableAndColumnsState(Tasklet value, String cardName, String menuName) {
        super(value, cardName);
        this.setMenuName(menuName);
    }

    @Override
    public String getNoteKey() {
        return this.getIsOidc() && this.getClass().equals(SelectDatabaseTableAndColumnsState.class) ? super.getNoteKey() + "_Oidc" : super.getNoteKey();
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    @Override
    public void onStateActivated() {
        if (!this.isViewOnly()) {
            JdbcDataSource tempDataSource = this.getSelectedDataSource();
            if (!this.populated && this.mapping != null) {
                this.prepareCaches();
                this.resetValues();
                this.populateLists();
                this.populated = true;
            }
            if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
                this.previouslySelectedTable = "";
                this.dataSource = tempDataSource;
                this.prepareCaches();
                this.resetAllValues();
                this.populateLists();
            }
            if (this.schemaList == null) {
                if (!this.schemas.isEmpty()) {
                    if (!this.schemas.contains(this.selectedSchema)) {
                        this.selectedSchema = this.schemas.get(0);
                    }
                    this.schemaList = this.createPairModel(this.schemas);
                } else {
                    this.selectedSchema = NO_SCHEMA_LIST;
                    this.previouslySelectedSchema = NO_SCHEMA_LIST;
                    this.schemaList = NO_SCHEMA_MODEL;
                }
            }
            if (this.tableList == null) {
                this.tableList = this.createPairModel(this.tables);
            }
            if (this.columnList == null) {
                this.columnList = this.createPairModel(this.availableColumns);
            }
        }
    }

    public JdbcDataSource getSelectedDataSource() {
        AttributeSourceApi attrSrcTasklet = (AttributeSourceApi)((Object)this.getWizard());
        return (JdbcDataSource)attrSrcTasklet.getSelectedDataSource();
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (this.findParent(UserProvisioningTasklet.class) != null) {
            IdpConnection tempConnection = (IdpConnection)dataFromDisk;
            this.mapping = tempConnection.getUserProvisioning();
        } else {
            this.mapping = (AttributeMapping)dataFromDisk;
        }
        this.populateSelectedValues();
    }

    protected void populateSelectedValues() {
        String string;
        List issuanceCriteria;
        AttributeSource source = this.mapping.getAttributeSource();
        this.dataSource = (JdbcDataSource)source.getDataSource();
        this.selectedTable = source.getParameter("tableName");
        this.selectedSchema = source.getParameter("schema");
        HashSet<String> temp = new HashSet<String>();
        for (Object v : this.mapping.getAttributeMap().values()) {
            if (v.getType() == SourceType.JDBC_DATA_STORE) {
                if (v.getAttributeSourceId() != null && !v.getAttributeSourceId().equals(source.getId())) continue;
                temp.add(v.getValue());
                continue;
            }
            if (v.getType() == SourceType.TEXT) {
                Set set = Substituter.parseReferences((String)v.getValue());
                for (String s : set) {
                    if (!s.startsWith(this.getPrefix())) continue;
                    temp.add(s.substring(this.getPrefix().length()));
                }
                continue;
            }
            if (v.getType() != SourceType.EXPRESSION) continue;
            this.addAttributesFromExpression(v.getValue(), temp);
        }
        Set<String> attributeSourceFilterReferences = this.getReferencesInAllAttributeSourceFiltersFromDisk();
        if (attributeSourceFilterReferences != null) {
            for (String string2 : attributeSourceFilterReferences) {
                if (!string2.startsWith(this.getPrefix())) continue;
                temp.add(string2.substring(this.getPrefix().length()));
            }
        }
        if ((issuanceCriteria = this.mapping.getTokenAuthorizationIssuanceCriteria()) != null) {
            for (TokenAuthorizationIssuanceCriterion criterion : issuanceCriteria) {
                if (criterion.getAttrSourceType() == SourceType.JDBC_DATA_STORE) {
                    if (!StringUtils.isEmpty((String)criterion.getAttrSourceId()) && !criterion.getAttrSourceId().equals(this.mapping.getAttributeSource().getId())) continue;
                    temp.add(criterion.getAttrName());
                    continue;
                }
                if (criterion.getAttrSourceType() != SourceType.EXPRESSION) continue;
                this.addAttributesFromExpression(criterion.getExpr(), temp);
            }
        }
        if ((string = source.getParameter("columnNames")) != null) {
            String[] attributes = string.split(",");
            temp.addAll(Arrays.asList(attributes));
        }
        this.selectedColumns = new ArrayList<String>(temp);
    }

    private void addAttributesFromExpression(String expression, Set<String> selectedAttrs) {
        try {
            Object parsedExpression = Ognl.parseExpression((String)expression);
            OgnlHelper oh = new OgnlHelper(this.getPrefix());
            oh.searchForDataColumns(parsedExpression);
            oh.addListToSet(selectedAttrs);
        }
        catch (OgnlException e) {
            this.log.debug((Object)e);
        }
    }

    protected void resetValues() {
        if (!this.isViewOnly()) {
            DatabaseCache cache = (DatabaseCache)this.globalCache.get(this.getDataSourceId());
            this.tables = cache.fetchTablesFromCache(this.selectedSchema);
            this.prepColumns();
            this.previouslySelectedTable = this.selectedTable;
            this.previouslySelectedSchema = this.selectedSchema;
        }
    }

    public void resetAllValues() {
        this.schemas = new ArrayList<String>();
        this.tables = new ArrayList<String>();
        if (!this.isViewOnly()) {
            this.selectedSchema = "";
            this.selectedColumns = new ArrayList<String>();
        }
        this.availableColumns = new ArrayList<String>();
        this.allColumns = new ArrayList<String>();
        this.allColumnsWithMetadata = new ArrayList<ResultInfo>();
        this.schemaList = new StringPairPropertySelectionModel();
        this.tableList = new StringPairPropertySelectionModel();
        this.columnList = new StringPairPropertySelectionModel();
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeSource source = null;
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        if (t != null) {
            IdpConnection tempConnection = (IdpConnection)dataToDisk;
            UserProvisioning userProvisioning = tempConnection.getUserProvisioning();
            if (userProvisioning != null) {
                source = userProvisioning.getAttributeSource();
            }
        } else {
            AttributeMapping tempMapping = (AttributeMapping)dataToDisk;
            source = tempMapping.getAttributeSource();
        }
        if (source != null) {
            source.setParameter("tableName", this.selectedTable);
            StringJoiner joiner = new StringJoiner(",");
            this.selectedColumns.forEach(joiner::add);
            source.setParameter("columnNames", joiner.toString());
            if (NO_SCHEMA_LIST.equals(this.selectedSchema)) {
                source.removeParameter("schema");
            } else {
                source.setParameter("schema", this.selectedSchema);
            }
        }
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void reset() {
        this.selectedColumns = new ArrayList<String>();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly() && this.selectedColumns != null && this.selectedColumns.isEmpty() && !(this.getParent() instanceof UserProvisioningTasklet)) {
            delegate.record(this.getMessage("Column_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean onStateExit() {
        if (!this.isViewOnly()) {
            JdbcTableValidator validator;
            List<ResultInfo> allColsWithMetadata = this.getAllColumnsWithMetadata();
            String tableName = this.selectedTable;
            if (NO_TABLE_LIST.equalsIgnoreCase(this.selectedTable)) {
                tableName = null;
            }
            if (!(validator = new JdbcTableValidator(this.selectedSchema, tableName, allColsWithMetadata, this.isExpressProvisioning(), "")).validate()) {
                this.recordErrors(validator.getErrors(), (IValidationDelegate)this.getDelegate());
                return false;
            }
        }
        return super.onStateExit();
    }

    @Override
    public ValidationDelegate getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
        }
        return this.delegate;
    }

    private boolean isExpressProvisioning() {
        return this.findParent(UserProvisioningTasklet.class) != null;
    }

    protected void populateLists() {
        DatabaseCache cache = (DatabaseCache)this.globalCache.get(this.getDataSourceId());
        this.schemas = new ArrayList<String>();
        this.tables = new ArrayList<String>();
        if (!this.isViewOnly()) {
            this.schemas = cache.fetchSchemasFromCache();
            if (this.schemas.isEmpty()) {
                this.tables = cache.fetchTablesFromCache(null);
            } else {
                this.schemaList = this.createPairModel(this.schemas);
                if (StringUtils.isBlank((String)this.selectedSchema)) {
                    for (String schema : this.schemas) {
                        this.tables = cache.fetchTablesFromCache(schema);
                        if (this.tables.isEmpty()) continue;
                        this.selectedSchema = schema;
                        break;
                    }
                    this.previouslySelectedSchema = this.selectedSchema;
                } else {
                    this.tables = cache.fetchTablesFromCache(this.selectedSchema);
                }
            }
            this.tableList = this.createPairModel(this.tables);
            if (!this.tables.contains(this.selectedTable) && !this.tables.isEmpty()) {
                this.selectedTable = this.tables.get(0);
            }
            if (this.schemas.isEmpty()) {
                this.selectedSchema = NO_SCHEMA_LIST;
                this.previouslySelectedSchema = NO_SCHEMA_LIST;
                this.schemaList = NO_SCHEMA_MODEL;
            }
            if (this.tables.isEmpty()) {
                this.selectedTable = NO_TABLE_LIST;
                this.tableList = NO_TABLE_MODEL;
            }
            if (!NO_TABLE_LIST.equals(this.selectedTable) && !this.selectedTable.equals(this.previouslySelectedTable)) {
                if (this.isViewOnly()) {
                    this.allColumns = new ArrayList<String>();
                    this.availableColumns = new ArrayList<String>();
                    this.allColumnsWithMetadata = new ArrayList<ResultInfo>();
                } else {
                    this.availableColumns = cache.fetchColumnsFromCache(this.returnSortedColumnLists, this.selectedSchema, this.selectedTable);
                    this.allColumns = cache.fetchColumnsFromCache(this.returnSortedColumnLists, this.selectedSchema, this.selectedTable);
                    this.allColumnsWithMetadata = cache.fetchUnsortedColumnsWithMetadataFromCache(this.selectedSchema, this.selectedTable);
                    this.setColumnList(this.createPairModel(this.availableColumns));
                }
                this.previouslySelectedTable = this.selectedTable;
            }
        }
    }

    public void addColumn() {
        this.moveAttrFromSrcToTarget(this.selectedColumn, this.availableColumns, this.selectedColumns);
        this.setColumnList(this.createPairModel(this.availableColumns));
    }

    public void deleteColumn(String columnToDelete) {
        this.moveAttrFromSrcToTarget(columnToDelete, this.selectedColumns, this.availableColumns);
        this.setColumnList(this.createPairModel(this.availableColumns));
    }

    public void refreshCache() {
        Tasklet parent;
        this.globalCache.remove(this.getDataSourceId());
        String oldSelectedSchema = this.selectedSchema;
        String oldPreviouslySelectedSchema = this.previouslySelectedSchema;
        String oldSelectedTable = this.selectedTable;
        String oldPreviouslySelectedTable = this.previouslySelectedTable;
        List<String> oldSelectedColumns = this.selectedColumns;
        this.prepareCaches();
        this.resetAllValues();
        this.populateLists();
        this.prepTables(oldSelectedSchema);
        this.selectedSchema = oldSelectedSchema;
        this.previouslySelectedSchema = oldPreviouslySelectedSchema;
        this.selectedTable = oldSelectedTable;
        this.previouslySelectedTable = oldPreviouslySelectedTable;
        this.prepColumns();
        if (oldSelectedColumns != null) {
            for (String col : oldSelectedColumns) {
                if (!this.availableColumns.contains(col)) continue;
                this.selectedColumn = col;
                this.addColumn();
            }
        }
        if ((parent = (Tasklet)this.findParent(UserProvisioningTasklet.class)) != null) {
            ProvisioningProcessorManager mgr = ProvisioningProcessorManager.getInstance();
            mgr.refresh();
        }
    }

    private void prepColumns() {
        DatabaseCache cache = (DatabaseCache)this.globalCache.get(this.getDataSourceId());
        this.allColumns = cache.fetchColumnsFromCache(this.returnSortedColumnLists, this.selectedSchema, this.selectedTable);
        this.allColumnsWithMetadata = cache.fetchUnsortedColumnsWithMetadataFromCache(this.selectedSchema, this.selectedTable);
        this.availableColumns = cache.fetchColumnsFromCache(this.returnSortedColumnLists, this.selectedSchema, this.selectedTable);
        this.cullAvailableColumns();
        this.columnList = this.createPairModel(this.availableColumns);
        if (this.tables.isEmpty()) {
            this.selectedTable = NO_TABLE_LIST;
            this.tableList = NO_TABLE_MODEL;
        }
    }

    private void prepTables(String schema) {
        DatabaseCache cache = (DatabaseCache)this.globalCache.get(this.getDataSourceId());
        this.tables = cache.fetchTablesFromCache(schema);
        this.tableList = this.createPairModel(cache.fetchTablesFromCache(schema));
    }

    private void moveAttrFromSrcToTarget(String attribute, List<String> sourceList, List<String> targetList) {
        if (sourceList.contains(attribute) && !targetList.contains(attribute)) {
            int index = sourceList.indexOf(attribute);
            targetList.add(sourceList.get(index));
            sourceList.remove(index);
            Collections.sort(targetList);
        }
    }

    private void cullAvailableColumns() {
        if (this.selectedColumns != null) {
            for (String attribute : this.selectedColumns) {
                if (!this.availableColumns.contains(attribute)) continue;
                this.availableColumns.remove(attribute);
            }
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (!this.isViewOnly()) {
            boolean changed = false;
            if (!this.selectedSchema.equals(this.previouslySelectedSchema)) {
                changed = true;
                this.selectedTable = "";
            }
            if (StringUtils.isBlank((String)this.selectedTable)) {
                this.selectedTable = NO_TABLE_LIST;
            }
            if (!this.selectedTable.equals(this.previouslySelectedTable)) {
                changed = true;
                this.selectedColumns = new ArrayList<String>();
            }
            if (changed) {
                this.resetValues();
                this.populateLists();
            }
        }
    }

    public IPropertySelectionModel getTableList() {
        return this.tableList;
    }

    public IPropertySelectionModel getSchemaList() {
        return this.schemaList;
    }

    protected StringPairPropertySelectionModel createPairModel(List<String> l) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        for (String value : l) {
            model.add(value, value);
        }
        return model;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = (JdbcDataSource)dataSource;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(ArrayList<String> schemas) {
        this.schemas = schemas;
    }

    public List<String> getSelectedColumns() {
        return this.selectedColumns;
    }

    public List<String> getSelectedColumnsCopy() {
        List<String> selectedColumnsCopy = this.selectedColumns.stream().collect(Collectors.toList());
        return selectedColumnsCopy;
    }

    public void setSelectedColumns(List<String> selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    public String getSelectedSchema() {
        return this.selectedSchema;
    }

    public void setSelectedSchema(String selectedSchema) {
        this.selectedSchema = selectedSchema;
    }

    public String getSelectedTable() {
        return this.selectedTable;
    }

    public void setSelectedTable(String selectedTable) {
        this.selectedTable = selectedTable;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public String getSelectedColumn() {
        return this.selectedColumn;
    }

    public void setSelectedColumn(String selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    public List<String> getAvailableColumns() {
        return this.availableColumns;
    }

    public void setAvailableColumns(List<String> availableColumns) {
        this.availableColumns = availableColumns;
    }

    public StringPairPropertySelectionModel getColumnList() {
        return this.columnList;
    }

    public void setColumnList(StringPairPropertySelectionModel columnList) {
        this.columnList = columnList;
    }

    public List<String> getAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(ArrayList<String> allColumns) {
        this.allColumns = allColumns;
    }

    public List<ResultInfo> getAllColumnsWithMetadata() {
        return this.allColumnsWithMetadata;
    }

    public void setAllColumnsWithMetadata(List<ResultInfo> allColumnsWithMetadata) {
        this.allColumnsWithMetadata = allColumnsWithMetadata;
    }

    public String getSchemaName() {
        return !StringUtils.isEmpty((String)this.selectedSchema) && !this.selectedSchema.equals(NO_SCHEMA_LIST) ? this.selectedSchema : "";
    }

    public boolean isPopulated() {
        return this.populated;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedSchema != null && !this.selectedSchema.equals(NO_SCHEMA_LIST)) {
            summaryList.add(new SummaryInfo("Schema", this.selectedSchema, this));
        }
        summaryList.add(new SummaryInfo("Table", this.selectedTable, this));
        if (!this.selectedColumns.isEmpty()) {
            for (String col : this.selectedColumns) {
                summaryList.add(new SummaryInfo("Column", col, this));
            }
        }
    }

    public String getLinkText() {
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            return "View " + mappingTasklet.getContractTypeForDisplay();
        }
        Tasklet tasklet = this.getParent();
        if (tasklet instanceof IdpConfigAdapterMappingTasklet) {
            return "View Adapter Contract";
        }
        return "View Attribute Contract";
    }

    @Override
    public void onResumeDraft() {
        if (this.dataSource == null) {
            this.dataSource = this.getSelectedDataSource();
        }
        this.prepareCaches();
        this.resetValues();
        this.populateLists();
        if (this.selectedColumns == null) {
            this.selectedColumns = new ArrayList<String>();
        }
    }

    protected void prepareCaches() {
        String id;
        DatabaseCache globalCacheValue;
        Tasklet t = this.getParent();
        Visit v = t.getSystemVisit();
        this.globalCache = v.getUIDataSourceCache();
        boolean bl = this.returnSortedColumnLists = !(t instanceof UserProvisioningTasklet);
        if (this.dataSource != null && (globalCacheValue = (DatabaseCache)this.globalCache.get(id = this.getDataSourceId())) == null) {
            this.globalCache.put(id, new DatabaseCache());
        }
    }

    protected String getDataSourceId() {
        return this.dataSource != null ? this.dataSource.getId() : "";
    }

    protected String getPrefix() {
        Object prefix = "ds.";
        String attrSourceId = this.getAttributeSourceId();
        if (attrSourceId != null) {
            prefix = (String)prefix + attrSourceId + ".";
        }
        return prefix;
    }

    private String getAttributeSourceId() {
        String attributeSourceId = null;
        SpAttributeSourceTasklet spAttributeSourceTasklet = this.findParent(SpAttributeSourceTasklet.class);
        if (spAttributeSourceTasklet != null) {
            attributeSourceId = spAttributeSourceTasklet.getId();
        }
        return attributeSourceId;
    }

    private Set<String> getReferencesInAllAttributeSourceFiltersFromDisk() {
        Set<String> references = null;
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            references = mappingTasklet.getReferencesInAllAttributeSourceFiltersFromDisk();
        }
        return references;
    }

    protected class DatabaseCache
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private List<String> schemaCacheList = new ArrayList<String>();
        private Map<String, List<String>> schemaToTableCache = new HashMap<String, List<String>>();
        private Map<String, List<ResultInfo>> tableToColumnCache = new HashMap<String, List<ResultInfo>>();
        private Map<String, List<String>> schemaToStoredProcCache = new HashMap<String, List<String>>();
        private Map<String, List<ResultInfo>> storedProcToColumnCache = new HashMap<String, List<ResultInfo>>();

        public DatabaseCache() {
            this.init();
        }

        private void init() {
            this.schemaCacheList = SelectDatabaseTableAndColumnsState.this.dataSource.getSchemas();
            for (String s : this.schemaCacheList) {
                this.schemaToTableCache.put(s, null);
            }
        }

        public List<String> fetchSchemasFromCache() {
            return this.schemaCacheList;
        }

        public List<String> fetchTablesFromCache(String schemaName) {
            List<String> cacheTables = this.schemaToTableCache.get(schemaName);
            if (cacheTables == null) {
                List tablesFromDatasource = SelectDatabaseTableAndColumnsState.this.dataSource.getTables(schemaName);
                this.updateStringListCache(tablesFromDatasource, this.schemaToTableCache, schemaName);
                return new ArrayList<String>(tablesFromDatasource);
            }
            return new ArrayList<String>(cacheTables);
        }

        public List<String> fetchColumnsFromCache(boolean returnSortedColumnLists, String schemaName, String tableName) {
            ArrayList<String> columnNamesOnly = new ArrayList<String>();
            for (ResultInfo info : this.fetchUnsortedColumnsWithMetadataFromCache(schemaName, tableName)) {
                columnNamesOnly.add(info.getColumnName());
            }
            return returnSortedColumnLists ? SortUtil.copyAndCaseInsensitiveSort(columnNamesOnly) : columnNamesOnly;
        }

        public List<ResultInfo> fetchUnsortedColumnsWithMetadataFromCache(String schemaName, String tableName) {
            String key = this.createKey(schemaName, tableName);
            List<ResultInfo> cacheColumns = this.tableToColumnCache.get(key);
            if (cacheColumns == null) {
                List columnsFromDatasource = SelectDatabaseTableAndColumnsState.this.dataSource.getUnsortedColumnsWithMetadata(schemaName, tableName);
                this.updateResultInfoCache(columnsFromDatasource, this.tableToColumnCache, key);
                return this.copyResultInfoList(columnsFromDatasource);
            }
            return this.copyResultInfoList(cacheColumns);
        }

        public List<ResultInfo> fetchUnsortedStoredProcedureColumnsFromCache(String schemaName, String storedProcedureName) {
            String key = this.createKey(schemaName, storedProcedureName);
            List<ResultInfo> cacheColumns = this.storedProcToColumnCache.get(key);
            if (cacheColumns == null) {
                List columnsFromDataSource = SelectDatabaseTableAndColumnsState.this.dataSource.getUnsortedStoredProcedureColumnsWithMetadata(schemaName, storedProcedureName);
                this.updateResultInfoCache(columnsFromDataSource, this.storedProcToColumnCache, key);
                return this.copyResultInfoList(columnsFromDataSource);
            }
            return this.copyResultInfoList(cacheColumns);
        }

        public List<String> fetchStoredProceduresForSchemaFromCache(String schemaName) {
            List<String> cacheStoredProcs = this.schemaToStoredProcCache.get(schemaName);
            if (cacheStoredProcs == null) {
                List storedProcsFromDatasource = SelectDatabaseTableAndColumnsState.this.dataSource.getStoredProceduresForSchema(schemaName);
                this.updateStringListCache(storedProcsFromDatasource, this.schemaToStoredProcCache, schemaName);
                return new ArrayList<String>(storedProcsFromDatasource);
            }
            return new ArrayList<String>(cacheStoredProcs);
        }

        private List<ResultInfo> copyResultInfoList(List<ResultInfo> listToCopy) {
            ArrayList<ResultInfo> newList = new ArrayList<ResultInfo>();
            for (ResultInfo result : listToCopy) {
                newList.add(new ResultInfo(result));
            }
            return newList;
        }

        private String createKey(String param1, String param2) {
            StringBuffer sb = new StringBuffer();
            if (!StringUtils.isEmpty((String)param1)) {
                sb.append(param1);
            }
            if (!StringUtils.isEmpty((String)param2)) {
                sb.append(param2);
            }
            return sb.length() > 0 ? sb.toString() : null;
        }

        private void updateResultInfoCache(List<ResultInfo> resultFromDatasource, Map<String, List<ResultInfo>> cache, String key) {
            if (resultFromDatasource == null || resultFromDatasource.isEmpty()) {
                cache.put(key, new ArrayList());
            }
            cache.put(key, resultFromDatasource);
        }

        private void updateStringListCache(List<String> resultFromDatasource, Map<String, List<String>> cache, String key) {
            if (resultFromDatasource == null || resultFromDatasource.isEmpty()) {
                cache.put(key, new ArrayList());
            }
            cache.put(key, resultFromDatasource);
        }
    }
}

