/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DecryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.websso.Protocol;

public class SelectIdpXmlAssertionEncryptionState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private ENABLE_ENCRYPTION sectionsEncryptedXml = ENABLE_ENCRYPTION.NONE;
    public static final ENABLE_ENCRYPTION enable = ENABLE_ENCRYPTION.ENABLE;
    public static final ENABLE_ENCRYPTION disable = ENABLE_ENCRYPTION.NONE;
    private boolean encryptEntireAssertion;
    private boolean encryptSamlSubject;
    private boolean encryptAttributes;
    private boolean isConfigured;
    private boolean allowEncryption = true;
    private boolean disableCheckboxes = true;
    private boolean sloEncryptSubjectNameID;
    private boolean sloSubjectNameIDEncrypted;
    private boolean showDecrypt;
    private boolean showEncrypt;
    private ConnectionBase connection;

    public SelectIdpXmlAssertionEncryptionState(IWizard owner) {
        super(owner);
        this.setMenuName("Encryption Policy");
    }

    @Override
    public void onStateActivated() {
        this.updateEncryptDecrypt();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        EncryptionSettings encryptionSettings = this.connection.getEncryptionSettings();
        DecryptionPolicy decryptionPolicy = encryptionSettings.getDecryptionPolicy();
        this.encryptEntireAssertion = decryptionPolicy.isAssertionEncrypted();
        this.encryptSamlSubject = decryptionPolicy.isSubjectNameIDEncrypted();
        this.encryptAttributes = decryptionPolicy.isAttributeEncrypted();
        this.sloSubjectNameIDEncrypted = decryptionPolicy.isSloSubjectNameIDEncrypted();
        this.sloEncryptSubjectNameID = encryptionSettings.getEncryptionPolicy().isSloEncryptSubjectNameID();
        this.sectionsEncryptedXml = this.encryptEntireAssertion || this.encryptSamlSubject || this.encryptAttributes ? ENABLE_ENCRYPTION.ENABLE : ENABLE_ENCRYPTION.NONE;
        this.disableCheckboxes = this.sectionsEncryptedXml != ENABLE_ENCRYPTION.ENABLE;
        this.updateEncryptDecrypt();
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        EncryptionSettings encryptionSettings = tempConnection.getEncryptionSettings();
        DecryptionPolicy decryptionPolicy = encryptionSettings.getDecryptionPolicy();
        if (this.sectionsEncryptedXml == ENABLE_ENCRYPTION.ENABLE) {
            decryptionPolicy.setAssertionEncrypted(this.encryptEntireAssertion);
            decryptionPolicy.setSubjectNameIDEncrypted(this.encryptSamlSubject);
            decryptionPolicy.setAttributeEncrypted(this.encryptAttributes);
        } else {
            decryptionPolicy.setAssertionEncrypted(false);
            decryptionPolicy.setSubjectNameIDEncrypted(false);
            decryptionPolicy.setAttributeEncrypted(false);
        }
        encryptionSettings.getEncryptionPolicy().setSloEncryptSubjectNameID(this.sloEncryptSubjectNameID);
        decryptionPolicy.setSloSubjectNameIDEncrypted(this.sloSubjectNameIDEncrypted);
        this.isConfigured = true;
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!(this.encryptEntireAssertion || this.encryptSamlSubject || this.encryptAttributes || this.sectionsEncryptedXml != ENABLE_ENCRYPTION.ENABLE)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Encrypt_selection_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void reset() {
        this.sectionsEncryptedXml = ENABLE_ENCRYPTION.NONE;
        this.encryptEntireAssertion = false;
        this.encryptSamlSubject = false;
        this.encryptAttributes = false;
        this.isConfigured = false;
        this.disableCheckboxes = true;
        this.sloEncryptSubjectNameID = false;
        this.sloSubjectNameIDEncrypted = false;
        this.showDecrypt = false;
        this.showEncrypt = false;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        boolean bl = this.disableCheckboxes = this.sectionsEncryptedXml != ENABLE_ENCRYPTION.ENABLE;
        if (this.disableCheckboxes) {
            this.encryptEntireAssertion = false;
            this.encryptSamlSubject = false;
            this.encryptAttributes = false;
        }
        this.updateEncryptDecrypt();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!this.isNoneSelected()) {
            if (!this.isWsFed()) {
                summaryList.add(new SummaryInfo(this.getMessage("Encrypt_assertion_summary"), new Boolean(this.encryptEntireAssertion).toString(), this));
            }
            summaryList.add(new SummaryInfo(this.getMessage("Encrypt_saml_subject_summary"), new Boolean(this.encryptSamlSubject).toString(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Encrypt_attributes_summary"), new Boolean(this.encryptAttributes).toString(), this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Common", "Encrypt_status_summary"), this.getStatus(), this));
        }
        if (this.isShowEncrypt()) {
            summaryList.add(new SummaryInfo(this.getMessage("Encrypt_saml_subject_desc"), new Boolean(this.sloEncryptSubjectNameID).toString(), this));
        }
        if (this.isShowDecrypt()) {
            summaryList.add(new SummaryInfo(this.getMessage("Decrypt_saml_subject_desc"), new Boolean(this.sloSubjectNameIDEncrypted).toString(), this));
        }
    }

    private void updateEncryptDecrypt() {
        SamlProfilesApi spa = this.findParent(SamlProfilesApi.class);
        if (spa.isSpSLOSelected() && (this.encryptEntireAssertion || this.encryptSamlSubject)) {
            this.showEncrypt = true;
        } else {
            this.showEncrypt = false;
            this.sloEncryptSubjectNameID = false;
        }
        if (spa.isIdpSLOSelected() && (this.encryptEntireAssertion || this.encryptSamlSubject)) {
            this.showDecrypt = true;
        } else {
            this.showDecrypt = false;
            this.sloSubjectNameIDEncrypted = false;
        }
    }

    public boolean isNoneSelected() {
        return this.sectionsEncryptedXml == ENABLE_ENCRYPTION.NONE;
    }

    public String getStatus() {
        return this.isNoneSelected() ? this.getMessage("Common", "Inactive_desc") : this.getMessage("Common", "Active_desc");
    }

    public boolean hasStateBeenConfigured() {
        return this.isConfigured;
    }

    public boolean getEncryptAttributes() {
        return this.encryptAttributes;
    }

    public void setEncryptAttributes(boolean encryptAttributes) {
        this.encryptAttributes = encryptAttributes;
    }

    public boolean getEncryptEntireAssertion() {
        return this.encryptEntireAssertion;
    }

    public void setEncryptEntireAssertion(boolean encryptEntireAssertion) {
        if (!this.encryptEntireAssertion && !this.encryptSamlSubject && encryptEntireAssertion) {
            this.sloEncryptSubjectNameID = true;
            this.sloSubjectNameIDEncrypted = true;
        }
        this.encryptEntireAssertion = encryptEntireAssertion;
    }

    public boolean getEncryptSamlSubject() {
        return this.encryptSamlSubject;
    }

    public void setEncryptSamlSubject(boolean encryptSamlSubject) {
        if (!this.encryptSamlSubject && !this.encryptEntireAssertion && encryptSamlSubject) {
            this.sloEncryptSubjectNameID = true;
            this.sloSubjectNameIDEncrypted = true;
        }
        this.encryptSamlSubject = encryptSamlSubject;
    }

    public ENABLE_ENCRYPTION getSectionsEncryptedXml() {
        return this.sectionsEncryptedXml;
    }

    public void setSectionsEncryptedXml(ENABLE_ENCRYPTION sectionsEncryptedXml) {
        this.sectionsEncryptedXml = sectionsEncryptedXml;
    }

    public boolean getDisableCheckboxes() {
        return this.disableCheckboxes;
    }

    public void setDisableCheckboxes(boolean disableCheckboxes) {
        this.disableCheckboxes = disableCheckboxes;
    }

    public boolean getAllowXmlEncryption() {
        return this.allowEncryption;
    }

    public void setAllowXmlEncryption(boolean allow) {
        this.allowEncryption = allow;
    }

    public boolean isShowEncrypt() {
        return this.showEncrypt;
    }

    public boolean isSloEncryptSubjectNameID() {
        if (this.isShowEncrypt()) {
            return this.sloEncryptSubjectNameID;
        }
        return false;
    }

    public void setSloEncryptSubjectNameID(boolean sloEncryptSubjectNameID) {
        this.sloEncryptSubjectNameID = sloEncryptSubjectNameID;
    }

    public boolean isShowDecrypt() {
        return this.showDecrypt;
    }

    public boolean isSloSubjectNameIDEncrypted() {
        if (this.isShowDecrypt()) {
            return this.sloSubjectNameIDEncrypted;
        }
        return false;
    }

    public void setSloSubjectNameIDEncrypted(boolean sloSubjectNameIDEncrypted) {
        this.sloSubjectNameIDEncrypted = sloSubjectNameIDEncrypted;
    }

    public boolean isWsFed() {
        boolean isWsFed = false;
        if (this.connection == null) {
            ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
            if (connectionTasklet != null) {
                isWsFed = Protocol.WSFED == connectionTasklet.getProtocolType();
            }
        } else {
            isWsFed = Protocol.WSFED == this.connection.getProtocol();
        }
        return isWsFed;
    }

    private static enum ENABLE_ENCRYPTION {
        ENABLE,
        NONE;

    }
}

