/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.EnabledProfilesValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.metadata.Role;

public class SelectSamlProfilesState
extends TaskletState
implements SamlProfilesApi {
    private static final long serialVersionUID = 20050515L;
    private EnabledProfiles enabledProfiles = new EnabledProfiles();
    private ConnectionBase connection;

    public SelectSamlProfilesState(Tasklet value) {
        super(value);
        this.setMenuName("SAML Profiles");
        this.enabledProfiles.setIdpInitiatedSSOEnabled(false);
        this.enabledProfiles.setIdpInitiatedSLOEnabled(false);
        this.enabledProfiles.setSpInitiatedSSOEnabled(false);
        this.enabledProfiles.setSpInitiatedSLOEnabled(false);
    }

    @Override
    public void onStateActivated() {
        if (this.isConnectionProtocol1x()) {
            this.enabledProfiles.setIdpInitiatedSSOEnabled(true);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        if (this.isConnectionProtocol1x()) {
            this.enabledProfiles.setIdpInitiatedSSOEnabled(true);
        } else {
            this.enabledProfiles.setIdpInitiatedSSOEnabled(this.connection.getEnabledProfiles().isIdpInitiatedSSOEnabled());
        }
        this.enabledProfiles.setIdpInitiatedSLOEnabled(this.connection.getEnabledProfiles().isIdpInitiatedSLOEnabled());
        this.enabledProfiles.setSpInitiatedSSOEnabled(this.connection.getEnabledProfiles().isSpInitiatedSSOEnabled());
        this.enabledProfiles.setSpInitiatedSLOEnabled(this.connection.getEnabledProfiles().isSpInitiatedSLOEnabled());
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        tempConnection.getEnabledProfiles().setIdpInitiatedSSOEnabled(this.enabledProfiles.isIdpInitiatedSSOEnabled());
        tempConnection.getEnabledProfiles().setIdpInitiatedSLOEnabled(this.enabledProfiles.isIdpInitiatedSLOEnabled());
        tempConnection.getEnabledProfiles().setSpInitiatedSSOEnabled(this.enabledProfiles.isSpInitiatedSSOEnabled());
        tempConnection.getEnabledProfiles().setSpInitiatedSLOEnabled(this.enabledProfiles.isSpInitiatedSLOEnabled());
        return true;
    }

    @Override
    public void reset() {
        this.enabledProfiles.setIdpInitiatedSSOEnabled(this.isConnectionProtocol1x());
        this.enabledProfiles.setIdpInitiatedSLOEnabled(false);
        this.enabledProfiles.setSpInitiatedSSOEnabled(false);
        this.enabledProfiles.setSpInitiatedSLOEnabled(false);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (!this.enabledProfiles.isIdpInitiatedSSOEnabled() && !this.enabledProfiles.isSpInitiatedSSOEnabled()) {
            this.enabledProfiles.setIdpInitiatedSLOEnabled(false);
            this.enabledProfiles.setSpInitiatedSLOEnabled(false);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Role role = this.findParent(ConnectionTasklet.class).getConnectionType() == ConnectionType.IDP ? Role.IDP : Role.SP;
        EnabledProfilesValidator validator = new EnabledProfilesValidator(this.isIdpSSOSelected(), this.enabledProfiles.isSpInitiatedSSOEnabled(), role);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!this.isConnectionProtocol1x()) {
            summaryList.add(new SummaryInfo(this.getMessage("Idp_sso"), new Boolean(this.enabledProfiles.isIdpInitiatedSSOEnabled()).toString(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Idp_slo"), new Boolean(this.enabledProfiles.isIdpInitiatedSLOEnabled()).toString(), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Sp_sso"), new Boolean(this.enabledProfiles.isSpInitiatedSSOEnabled()).toString(), this));
        if (!this.isConnectionProtocol1x()) {
            summaryList.add(new SummaryInfo(this.getMessage("Sp_slo"), new Boolean(this.enabledProfiles.isSpInitiatedSLOEnabled()).toString(), this));
        }
    }

    public EnabledProfiles getEnabledProfiles() {
        return this.enabledProfiles;
    }

    public void setEnabledProfiles(EnabledProfiles enabledProfiles) {
        this.enabledProfiles = enabledProfiles;
    }

    public boolean displaySloCheckboxes() {
        return this.enabledProfiles.isIdpInitiatedSSOEnabled() || this.enabledProfiles.isSpInitiatedSSOEnabled();
    }

    public boolean isConnectionProtocol1x() {
        return this.findParent(ConnectionTasklet.class).isConnectionProtocol1x();
    }

    public boolean isConnectionProtocol20() {
        return this.findParent(ConnectionTasklet.class).isConnectionProtocol20();
    }

    @Override
    public String getNoteKey() {
        if (this.isConnectionProtocol1x()) {
            return super.getNoteKey() + "_1x";
        }
        return super.getNoteKey();
    }

    @Override
    public boolean isAnySsoSelected() {
        return this.isIdpSSOSelected() || this.enabledProfiles.isSpInitiatedSSOEnabled();
    }

    @Override
    public boolean isAttributeQuerySelected() {
        boolean attributeQuerySelected = false;
        Tasklet parentTasklet = this.getParent();
        if (parentTasklet instanceof SpConnectionConfigTasklet) {
            attributeQuerySelected = ((SpConnectionConfigTasklet)parentTasklet).isAttributeQuerySelected();
        } else if (parentTasklet instanceof IdpConnectionConfigTasklet) {
            attributeQuerySelected = ((IdpConnectionConfigTasklet)parentTasklet).isAttributeQuerySelected();
        }
        return attributeQuerySelected;
    }

    @Override
    public boolean isAnySloSelected() {
        return this.enabledProfiles.isIdpInitiatedSLOEnabled() || this.enabledProfiles.isSpInitiatedSLOEnabled();
    }

    @Override
    public boolean isIdpSSOSelected() {
        return this.enabledProfiles.isIdpInitiatedSSOEnabled() || this.isConnectionProtocol1x();
    }

    @Override
    public boolean isIdpSLOSelected() {
        return this.enabledProfiles.isIdpInitiatedSLOEnabled();
    }

    @Override
    public boolean isSomethingOtherThanIdpInitiatedSsoSelected() {
        return this.enabledProfiles.isIdpInitiatedSLOEnabled() || this.enabledProfiles.isSpInitiatedSSOEnabled() || this.enabledProfiles.isSpInitiatedSLOEnabled();
    }

    @Override
    public boolean isSpSSOSelected() {
        return this.enabledProfiles.isSpInitiatedSSOEnabled();
    }

    @Override
    public boolean isSpSLOSelected() {
        return this.enabledProfiles.isSpInitiatedSLOEnabled();
    }

    @Override
    public boolean isOnlySpSSOSelected() {
        return this.enabledProfiles.isSpInitiatedSSOEnabled() && !this.isSomethingOtherThanSpInitiatedSsoSelected();
    }

    @Override
    public boolean onlyIdpSsoSelected() {
        return this.isIdpSSOSelected() && !this.isSomethingOtherThanIdpInitiatedSsoSelected();
    }

    @Override
    public boolean isAnySpSelected() {
        return this.enabledProfiles.isSpInitiatedSLOEnabled() || this.enabledProfiles.isSpInitiatedSSOEnabled();
    }

    @Override
    public boolean isSomethingOtherThanSpInitiatedSsoSelected() {
        return this.isIdpSSOSelected() || this.enabledProfiles.isIdpInitiatedSLOEnabled() || this.enabledProfiles.isSpInitiatedSLOEnabled();
    }

    public boolean isSpConnection() {
        return this.findParent(SpConnectionConfigTasklet.class) != null;
    }

    public boolean isIdpConnection() {
        return this.findParent(IdpConnectionConfigTasklet.class) != null;
    }
}

