/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SpProtocolSettingsTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SelectSpXmlAssertionEncryptionState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private ENCRYPT_SELECTION sectionsOfAssertionToEncrypt = ENCRYPT_SELECTION.NONE;
    private ENCRYPT_SELECTION previousSelectionOfAssertionToEncrypt = ENCRYPT_SELECTION.NONE;
    public static ENCRYPT_SELECTION assertion = ENCRYPT_SELECTION.ASSERTION;
    public static ENCRYPT_SELECTION attrs = ENCRYPT_SELECTION.ATTRIBUTES;
    public static ENCRYPT_SELECTION none = ENCRYPT_SELECTION.NONE;
    private boolean disableCheckboxes = true;
    private boolean isConfigured;
    private CheckboxModel checkboxModel;
    private boolean allowXmlEncryption = true;
    private boolean sloEncryptSubjectNameID;
    private boolean sloSubjectNameIDEncrypted;
    private boolean showDecrypt = true;
    private boolean showEncrypt = true;

    public SelectSpXmlAssertionEncryptionState(IWizard owner) {
        super(owner);
        this.setMenuName("Encryption Policy");
        this.checkboxModel = new CheckboxModel();
    }

    @Override
    public void onStateActivated() {
        this.disableCheckboxes = this.sectionsOfAssertionToEncrypt != ENCRYPT_SELECTION.ATTRIBUTES;
        this.populateCheckBoxModel(null);
        this.updateEncryptDecrypt();
    }

    private void populateCheckBoxModel(List<String> checkedList) {
        List<String> checkList = this.findParent(AttributeNamesApi.class).getSortedMutableAttributeNames();
        boolean encryptSamlSubject = this.getEncryptSamlSubject();
        this.checkboxModel.updateCheckedListInPlace(checkList, checkedList, false);
        this.checkboxModel.addFirst(AssertionMapKeys.getNameIdValueKey(), true, encryptSamlSubject);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        List encryptionAttrList = encryptionPolicy.getEncryptAttributeList();
        this.populateCheckBoxModel(encryptionAttrList);
        boolean encryptSamlSubject = encryptionPolicy.isEncryptSubjectNameID();
        if (encryptSamlSubject) {
            this.checkboxModel.setChecked(AssertionMapKeys.getNameIdValueKey());
        }
        if (encryptionPolicy.isEncryptAssertion()) {
            this.sectionsOfAssertionToEncrypt = ENCRYPT_SELECTION.ASSERTION;
            this.isConfigured = true;
        } else if (encryptionAttrList.size() > 0 || encryptSamlSubject) {
            this.sectionsOfAssertionToEncrypt = ENCRYPT_SELECTION.ATTRIBUTES;
            this.isConfigured = true;
        } else {
            this.sectionsOfAssertionToEncrypt = ENCRYPT_SELECTION.NONE;
        }
        this.disableCheckboxes = this.sectionsOfAssertionToEncrypt != ENCRYPT_SELECTION.ATTRIBUTES;
        this.sloSubjectNameIDEncrypted = encryptionSettings.getDecryptionPolicy().isSloSubjectNameIDEncrypted();
        this.sloEncryptSubjectNameID = encryptionPolicy.isSloEncryptSubjectNameID();
        this.previousSelectionOfAssertionToEncrypt = this.sectionsOfAssertionToEncrypt;
        this.updateEncryptDecrypt();
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase connection = (ConnectionBase)dataToDisk;
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        encryptionPolicy.setEncryptAssertion(this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ASSERTION);
        encryptionPolicy.setSloEncryptSubjectNameID(this.sloEncryptSubjectNameID);
        encryptionSettings.getDecryptionPolicy().setSloSubjectNameIDEncrypted(this.sloSubjectNameIDEncrypted);
        if (this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ATTRIBUTES) {
            boolean subjectIsChecked = this.getEncryptSamlSubject();
            if (subjectIsChecked) {
                this.checkboxModel.getSelectedNames().remove(AssertionMapKeys.getNameIdValueKey());
            }
            encryptionPolicy.setEncryptAttributeList(this.checkboxModel.getSelectedNames());
            encryptionPolicy.setEncryptSubjectNameID(subjectIsChecked);
        } else if (this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.NONE) {
            encryptionPolicy.setEncryptAttributeList(new ArrayList());
            encryptionPolicy.setEncryptSubjectNameID(false);
        }
        return true;
    }

    @Override
    public void onResumeDraft() {
        this.initialize();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ATTRIBUTES && this.noAttrsSelected()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Encrypt_selection_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void reset() {
        this.checkboxModel = new CheckboxModel();
        this.isConfigured = false;
        this.disableCheckboxes = true;
        this.sectionsOfAssertionToEncrypt = ENCRYPT_SELECTION.NONE;
        this.sloEncryptSubjectNameID = false;
        this.sloSubjectNameIDEncrypted = false;
        this.showDecrypt = false;
        this.showEncrypt = false;
    }

    @Override
    public void cancel(Object newData) {
        this.reset();
        super.cancel(newData);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ASSERTION) {
            summaryList.add(new SummaryInfo(this.getMessage("Encrypt_assertion_summary"), new Boolean(true).toString(), this));
        } else if (this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ATTRIBUTES) {
            List<String> selectedNames = this.checkboxModel.getSelectedNames();
            for (int i = 0; i < selectedNames.size(); ++i) {
                summaryList.add(new SummaryInfo(this.getMessage("Encrypt_attributes_summary"), selectedNames.get(i), this));
            }
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Common", "Encrypt_status_summary"), this.getStatus(), this));
        }
        if (this.displayAssertionEncryption()) {
            if (this.isShowEncrypt()) {
                summaryList.add(new SummaryInfo(this.getMessage("Encrypt_saml_subject_desc"), new Boolean(this.sloEncryptSubjectNameID).toString(), this));
            }
            if (this.isShowDecrypt()) {
                summaryList.add(new SummaryInfo(this.getMessage("Decrypt_saml_subject_desc"), new Boolean(this.sloSubjectNameIDEncrypted).toString(), this));
            }
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.sectionsOfAssertionToEncrypt != ENCRYPT_SELECTION.ATTRIBUTES) {
            this.checkboxModel.unSelectAll();
            this.disableCheckboxes = true;
        } else {
            this.disableCheckboxes = false;
        }
        this.updateEncryptDecrypt();
    }

    private void updateEncryptDecrypt() {
        SamlProfilesApi spa = this.findParent(SamlProfilesApi.class);
        if (this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ASSERTION || this.getEncryptSamlSubject()) {
            boolean isEncryptPolicyEntireAssertion;
            boolean bl = isEncryptPolicyEntireAssertion = !this.previousSelectionOfAssertionToEncrypt.equals((Object)this.sectionsOfAssertionToEncrypt);
            if (spa.isIdpSLOSelected()) {
                if (isEncryptPolicyEntireAssertion) {
                    this.sloEncryptSubjectNameID = true;
                }
                this.showEncrypt = true;
            } else if (!this.showEncrypt) {
                this.sloEncryptSubjectNameID = false;
                this.showEncrypt = true;
            }
            if (spa.isSpSLOSelected()) {
                if (isEncryptPolicyEntireAssertion) {
                    this.sloSubjectNameIDEncrypted = true;
                }
                this.showDecrypt = true;
            } else {
                this.sloSubjectNameIDEncrypted = false;
                this.showDecrypt = false;
            }
        } else {
            this.showEncrypt = false;
            this.showDecrypt = false;
            this.sloEncryptSubjectNameID = false;
            this.sloSubjectNameIDEncrypted = false;
        }
        this.previousSelectionOfAssertionToEncrypt = this.sectionsOfAssertionToEncrypt;
    }

    public boolean hasStateBeenConfigured() {
        return this.isConfigured;
    }

    private boolean noAttrsSelected() {
        return !this.checkboxModel.anySelected();
    }

    public String getStatus() {
        return this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.NONE ? this.getMessage("Common", "Inactive_desc") : this.getMessage("Common", "Active_desc");
    }

    public boolean getEncryptSamlSubject() {
        String samlSubject = AssertionMapKeys.getNameIdValueKey();
        return this.checkboxModel.getSelectedNames().contains(samlSubject);
    }

    public boolean isOneOrMoreAttributesEncrypted() {
        return this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ATTRIBUTES;
    }

    public boolean getDisableCheckboxes() {
        return this.disableCheckboxes;
    }

    public void setDisableCheckboxes(boolean disableCheckboxes) {
        this.disableCheckboxes = disableCheckboxes;
    }

    public ENCRYPT_SELECTION getSectionsOfAssertionToEncrypt() {
        return this.sectionsOfAssertionToEncrypt;
    }

    public void setSectionsOfAssertionToEncrypt(ENCRYPT_SELECTION sectionsOfAssertionToEncrypt) {
        this.sectionsOfAssertionToEncrypt = sectionsOfAssertionToEncrypt;
    }

    public boolean isEntireAssertionEncrypted() {
        return this.sectionsOfAssertionToEncrypt == ENCRYPT_SELECTION.ASSERTION;
    }

    public boolean isNoneSelected() {
        return this.getSectionsOfAssertionToEncrypt() == ENCRYPT_SELECTION.NONE;
    }

    public String getPrefixString() {
        return "&nbsp;&nbsp;";
    }

    public CheckboxModel getCheckboxModel() {
        return this.checkboxModel;
    }

    public boolean getAllowXmlEncryption() {
        return this.allowXmlEncryption;
    }

    public void setAllowXmlEncryption(boolean allowXmlEncryption) {
        this.allowXmlEncryption = allowXmlEncryption;
    }

    public boolean isShowEncrypt() {
        return this.showEncrypt;
    }

    public boolean isSloEncryptSubjectNameID() {
        if (this.isShowEncrypt()) {
            return this.sloEncryptSubjectNameID;
        }
        return false;
    }

    public void setSloEncryptSubjectNameID(boolean sloEncryptSubjectNameID) {
        this.sloEncryptSubjectNameID = sloEncryptSubjectNameID;
    }

    public boolean isShowDecrypt() {
        return this.showDecrypt;
    }

    public boolean isSloSubjectNameIDEncrypted() {
        if (this.isShowDecrypt()) {
            return this.sloSubjectNameIDEncrypted;
        }
        return false;
    }

    public void setSloSubjectNameIDEncrypted(boolean sloSubjectNameIDEncrypted) {
        this.sloSubjectNameIDEncrypted = sloSubjectNameIDEncrypted;
    }

    public boolean displayAssertionEncryption() {
        SpProtocolSettingsTasklet spConnTasklet = this.findParent(SpProtocolSettingsTasklet.class);
        if (spConnTasklet != null) {
            return WsTrustTokenType.SAML20 != spConnTasklet.getWsFedTokenType();
        }
        return true;
    }

    private static enum ENCRYPT_SELECTION {
        ASSERTION,
        ATTRIBUTES,
        NONE;

    }
}

