/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.OAuthSAMLGrantAttributeMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SelectTokenManagerState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050518L;
    private transient BearerAccessTokenMgmtPluginInstance selectedTokenManager;
    private Tasklet parentTasklet;
    private String selectedTokenManagerIdForResumeDraft;
    protected boolean newTokenManager = true;

    public SelectTokenManagerState(Tasklet value) {
        super(value);
        this.setMenuName("Access Token Manager");
        this.parentTasklet = value;
    }

    public BearerAccessTokenMgmtPluginInstance getSelectedTokenManager() {
        return this.selectedTokenManager;
    }

    public void setSelectedTokenManager(BearerAccessTokenMgmtPluginInstance selectedTokenManager) {
        this.selectedTokenManager = selectedTokenManager;
        this.selectedTokenManagerIdForResumeDraft = selectedTokenManager != null ? selectedTokenManager.getId() : null;
    }

    private String getSelectedTokenManagerId() {
        return this.selectedTokenManager != null ? this.selectedTokenManager.getId() : null;
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof OAuthAssertionGrantMapping) {
            OAuthAssertionGrantMapping oAuthSAMLBearerMapping = (OAuthAssertionGrantMapping)dataFromDisk;
            this.selectedTokenManager = this.getTokenManagerById(oAuthSAMLBearerMapping.getTokenManagerId());
            this.selectedTokenManagerIdForResumeDraft = this.selectedTokenManager.getId();
        }
        this.getParent().reconfigureTransitions();
        this.newTokenManager = false;
    }

    private BearerAccessTokenMgmtPluginInstance getTokenManagerById(String selectedTokenManagerId) {
        BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        for (BearerAccessTokenMgmtPluginInstance tokenMgmtPluginInstance : bearerAccessTokenMgmtPluginManager.getInstances()) {
            if (!tokenMgmtPluginInstance.getId().equals(selectedTokenManagerId)) continue;
            return tokenMgmtPluginInstance;
        }
        return null;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.getTaskletToEdit() != null) {
            this.setTaskletToEditToNull();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedTokenManager != null) {
            summaryList.add(new SummaryInfo(this.getMessage("Selected_token_manager"), this.selectedTokenManager.getName(), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedTokenManager == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("You_must_select_a_token_manager"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        this.selectedTokenManager = this.getTokenManagerById(this.selectedTokenManagerIdForResumeDraft);
    }

    @Override
    public void onResumeDraft() {
        if (this.selectedTokenManager == null && this.selectedTokenManagerIdForResumeDraft != null) {
            this.selectedTokenManager = this.getTokenManagerById(this.selectedTokenManagerIdForResumeDraft);
        }
    }

    @Override
    public void reset() {
        this.selectedTokenManager = null;
        this.selectedTokenManagerIdForResumeDraft = null;
        this.newTokenManager = true;
    }

    public boolean isNewTokenManager() {
        return this.newTokenManager;
    }

    public void setNewTokenManager(boolean newTokenManager) {
        this.newTokenManager = newTokenManager;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof OAuthAssertionGrantMapping) {
            OAuthAssertionGrantMapping tempMapping = (OAuthAssertionGrantMapping)dataToDisk;
            tempMapping.setTokenManagerId(this.selectedTokenManager.getId());
        }
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    public StringPairPropertySelectionModel getTokenManagerList() {
        OAuthSAMLGrantAttributeMappingTasklet t = (OAuthSAMLGrantAttributeMappingTasklet)this.parentTasklet.getParentTasklet();
        return t.getTokenManagerList();
    }

    @Override
    public String getNoteKey() {
        if (this.isNewTokenManager()) {
            return this.getTaskletStateId() + "New";
        }
        return super.getNoteKey();
    }
}

