/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.fsm.state.impl.AttributeValueMaskState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.AdapterItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AuthnAdapterInstanceTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class SelectUniqueIdValuesState
extends AttributeValueMaskState {
    private static final long serialVersionUID = 20050515L;
    public static final String UNIQUE_USER_KEY_ATTRIBUTE_NONE_DISPLAY_NAME = "None";
    private StringPairPropertySelectionModel uniqueUserKeySelectionModel = new StringPairPropertySelectionModel(false);
    private Set<String> uniqueKeyFields = new HashSet<String>();
    private String uniqueUserKeyAttribute;

    public SelectUniqueIdValuesState(Tasklet value) {
        super(value);
        this.setMenuName("Adapter Attributes");
    }

    @Override
    protected void revert(String parentId, List<String> attributes) {
        super.revert(parentId, attributes);
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        IdpAuthnAdapterInstance parentInstance = (IdpAuthnAdapterInstance)pluginMgr.getInstance(parentId);
        HashSet parentUniqueKeyFields = new HashSet();
        parentUniqueKeyFields.addAll(ConfigurationUtil.findEffectiveUniqueKeyFields((IdpAuthnAdapterInstance)parentInstance, pluginMgr));
        for (AdapterItem adapterItem : this.adapterValues.values()) {
            adapterItem.setSelected(parentUniqueKeyFields.contains(adapterItem.getItem()));
        }
        this.populateUniqueUserIdDropDown();
        this.uniqueUserKeyAttribute = parentInstance.getUniqueUserKeyAttribute();
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        if (this.uniqueUserKeyAttribute == null) {
            this.uniqueUserKeyAttribute = "pf_none";
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        IdpAuthnAdapterInstance adapterInstance = (IdpAuthnAdapterInstance)dataFromDisk;
        if (adapterInstance != null) {
            PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            this.uniqueKeyFields = new HashSet<String>();
            this.uniqueKeyFields.addAll(ConfigurationUtil.findEffectiveUniqueKeyFields((IdpAuthnAdapterInstance)adapterInstance, pluginMgr));
            this.uniqueUserKeyAttribute = adapterInstance.getUniqueUserKeyAttribute();
        }
        this.populateUniqueFieldsList();
        this.populateUniqueUserIdDropDown();
    }

    @Override
    void populateList(List<String> attributes) {
        super.populateList(attributes);
        this.populateUniqueUserIdDropDown();
    }

    private void populateUniqueUserIdDropDown() {
        this.uniqueUserKeySelectionModel.removeAll();
        this.uniqueUserKeySelectionModel.add(UNIQUE_USER_KEY_ATTRIBUTE_NONE_DISPLAY_NAME, "pf_none");
        for (String uniqueKeyStr : this.adapterValues.keySet()) {
            this.uniqueUserKeySelectionModel.add(uniqueKeyStr, uniqueKeyStr);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        super.save(dataToDisk);
        IdpAuthnAdapterInstance tempAdapterInstance = (IdpAuthnAdapterInstance)dataToDisk;
        ArrayList<String> tempUniqueKeyFields = new ArrayList<String>();
        for (AdapterItem adapterItem : this.adapterValues.values()) {
            if (adapterItem.getSelected()) {
                tempUniqueKeyFields.add(adapterItem.getItem());
            }
            tempAdapterInstance.setOwnUniqueKeyFields(tempUniqueKeyFields);
        }
        tempAdapterInstance.setUniqueUserKeyAttribute(this.uniqueUserKeyAttribute);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Configuration adapterConfiguration;
        boolean isRevokeSessionsEnabled;
        AuthnAdapterInstanceTasklet authnAdapterInstanceTasklet;
        super.appendErrors(delegate, component, fastFail);
        boolean foundOneChecked = false;
        for (AdapterItem item : this.adapterValues.values()) {
            if (!item.getSelected()) continue;
            foundOneChecked = true;
            break;
        }
        if (!foundOneChecked) {
            delegate.record(this.getMessage("One_value_required"), ValidationConstraint.REQUIRED);
        }
        if (this.getWizard() instanceof AuthnAdapterInstanceTasklet && "HTML Form IdP Adapter".equals((authnAdapterInstanceTasklet = (AuthnAdapterInstanceTasklet)this.getWizard()).getType()) && (isRevokeSessionsEnabled = (adapterConfiguration = authnAdapterInstanceTasklet.getConfiguration()).getBooleanFieldValue("Revoke Sessions After Password Change Or Reset")) && (StringUtils.isBlank((String)this.uniqueUserKeyAttribute) || "pf_none".equals(this.uniqueUserKeyAttribute))) {
            delegate.record(this.getMessage("Revoke_session_enabled_must_select_unique_user_key", new String[]{"Revoke Sessions After Password Change Or Reset"}), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        StringBuffer pseudonyms = new StringBuffer();
        for (AdapterItem item : this.adapterValues.values()) {
            if (!item.getSelected()) continue;
            pseudonyms.append(item.getItem()).append(", ");
        }
        if (pseudonyms.length() > 0) {
            pseudonyms.deleteCharAt(pseudonyms.lastIndexOf(","));
        }
        summaryList.add(new SummaryInfo("Pseudonym", pseudonyms.toString().trim(), this));
        summaryList.add(new SummaryInfo("Unique User Key Attribute", this.uniqueUserKeySelectionModel.getDescription(this.uniqueUserKeyAttribute), this));
    }

    @Override
    public void reset() {
        super.reset();
        this.uniqueKeyFields = new HashSet<String>();
    }

    private void populateUniqueFieldsList() {
        super.populateList(this.getSortedAttributes());
        HashSet<String> tempUniqueFields = new HashSet<String>();
        LinkedHashMap<String, AdapterItem> tempAdapterValues = new LinkedHashMap<String, AdapterItem>();
        for (AdapterItem adapterItem : this.adapterValues.values()) {
            if (this.uniqueKeyFields.contains(adapterItem.getItem())) {
                adapterItem.setSelected(true);
            }
            tempAdapterValues.put(adapterItem.getItem(), adapterItem);
        }
        this.uniqueKeyFields = tempUniqueFields;
        this.adapterValues = tempAdapterValues;
    }

    public StringPairPropertySelectionModel getUniqueUserKeySelectionModel() {
        return this.uniqueUserKeySelectionModel;
    }

    public String getUniqueUserKeyAttribute() {
        return this.uniqueUserKeyAttribute;
    }

    public void setUniqueUserKeyAttribute(String uniqueUserKeyAttribute) {
        this.uniqueUserKeyAttribute = uniqueUserKeyAttribute;
    }
}

