/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import java.util.HashSet;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class SelectXmlDecryptionKeyState
extends CertificateState
implements CertificateTypes {
    private static final long serialVersionUID = 20050515L;
    private ConnectionBase connection;

    public SelectXmlDecryptionKeyState(Tasklet value) {
        super(value);
        this.setMenuName("Select Decryption Keys");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        EncryptionSettings encryptionSettings = this.connection.getEncryptionSettings();
        String selectedDecryptionKeyAlias = encryptionSettings.getDecryptionKeyAlias();
        String secondaryDecryptionKeyAlias = encryptionSettings.getSecondaryDecryptionKeyAlias();
        if (selectedDecryptionKeyAlias != null) {
            this.setSelectedCert((Cert)this.getCertManager().getPkCert(selectedDecryptionKeyAlias));
        }
        if (secondaryDecryptionKeyAlias != null) {
            this.setSecondarySelectedCert((Cert)this.getCertManager().getPkCert(secondaryDecryptionKeyAlias));
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        EncryptionSettings encryptionSettings = tempConnection.getEncryptionSettings();
        Cert primaryDecryptCert = this.getSelectedCert();
        Cert secondaryDecryptCert = this.getSecondarySelectedCert();
        if (primaryDecryptCert != null) {
            encryptionSettings.setDecryptionKeyAlias(primaryDecryptCert.getAlias());
        }
        if (secondaryDecryptCert != null) {
            encryptionSettings.setSecondaryDecryptionKeyAlias(secondaryDecryptCert.getAlias());
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Cert primaryDecryptCert = this.getSelectedCert();
        Cert secondaryDecryptCert = this.getSecondarySelectedCert();
        if (this.getSelectedCert() == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Common", "Certificate_selection_required"), ValidationConstraint.REQUIRED);
        } else if (!this.getSelectedCert().getX509Certificate().getPublicKey().getAlgorithm().equals("RSA")) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("RSA_certificate_required"), ValidationConstraint.REQUIRED);
        } else if (primaryDecryptCert != null && secondaryDecryptCert != null) {
            String primaryAlias = primaryDecryptCert.getAlias();
            String secondaryAlias = secondaryDecryptCert.getAlias();
            if (primaryAlias != null && secondaryAlias != null && primaryAlias.equals(secondaryAlias)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Certs_should_not_match"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public void onResumeDraft() {
        if (this.getSelectedCert() != null) {
            this.setSelectedCert((Cert)this.getCertManager().getPkCert(this.getSelectedCert().getAlias()));
        }
    }

    public boolean hasStateBeenConfigured() {
        return this.getSelectedCert() != null;
    }

    public String getSelectedDecryptionKeyAlias() {
        return this.getSelectedCert() != null ? this.getSelectedCert().getDescriptionForDisplay() : this.getMessage("Common", "None");
    }

    public PkCertManager getCertManager() {
        return MgmtFactory.getDsigPkCertManager();
    }

    public Set<KeyAlgorithmFilter> getKeyAlgorithmFilter() {
        HashSet<KeyAlgorithmFilter> algFilters = new HashSet<KeyAlgorithmFilter>();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.RSA).build());
        return algFilters;
    }
}

