/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.EncryptAlgorithms;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.XmlEncryption;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;

public class SelectXmlEncryptionCertState
extends CertificateState {
    private static final long serialVersionUID = 20050515L;
    private boolean disableAes256;
    private EncryptAlgorithms selectedBlockEncryptAlg = EncryptAlgorithms.AES_128;
    private EncryptAlgorithms selectedKeyTransportAlg = EncryptAlgorithms.RSA_OAEP;
    private boolean disableRsaV1dot5 = true;

    public SelectXmlEncryptionCertState(Tasklet value) {
        super(value);
        this.setMenuName("Select XML Encryption Certificate");
    }

    @Override
    public void onStateActivated() {
        this.disableAes256 = !XmlEncryption.isEncryptionAlgorithmAvailable((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        this.setSelectedCert(encryptionSettings.getEncryptionCert());
        this.setBlockEncryptionAlgorithm(encryptionPolicy.getEncryptionAlgorithm());
        this.setKeyTransportAlgorithm(encryptionPolicy.getKeyTransportAlgorithm());
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase connection = (ConnectionBase)dataToDisk;
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        encryptionSettings.setEncryptionCert(this.getSelectedCert());
        encryptionPolicy.setEncryptionAlgorithm(this.getBlockEncryptionAlgorithm());
        encryptionPolicy.setKeyTransportAlgorithm(this.getKeyTransportAlgorithm());
        return true;
    }

    @Override
    public void reset() {
        this.selectedBlockEncryptAlg = EncryptAlgorithms.AES_128;
        this.selectedKeyTransportAlg = EncryptAlgorithms.RSA_OAEP;
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.setSelectedCert(tasklet.getSelectedCert());
        InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
        iuca.setDsigConnectionCerts(tasklet.getDsigVerificationCerts());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getSelectedCert() == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Common", "Certificate_selection_required"), ValidationConstraint.REQUIRED);
        } else if (!this.getSelectedCert().getX509Certificate().getPublicKey().getAlgorithm().equals("RSA")) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("RSA_certificate_required"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean hasStateBeenConfigured() {
        return this.getSelectedCert() != null;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Block_encrypt_alg_summary"), this.getMessage(this.getSelectedBlockEncryptAlgLabel()), this));
        summaryList.add(new SummaryInfo(this.getMessage("Key_transport_alg_summary"), this.getMessage(this.getKeyTransportAlgorithmLabel()), this));
        summaryList.add(new SummaryInfo(this.getMessage("Selected_cert_summary"), this.getSelectedCert().getDescriptionForDisplay(), this));
    }

    private String getBlockEncryptionAlgorithm() {
        return this.selectedBlockEncryptAlg.getMatchingXmlCipher();
    }

    private String getKeyTransportAlgorithm() {
        return this.selectedKeyTransportAlg.getMatchingXmlCipher();
    }

    private void setBlockEncryptionAlgorithm(String encryptionAlgorithm) {
        try {
            this.selectedBlockEncryptAlg = EncryptAlgorithms.fromXMLCipher((String)encryptionAlgorithm);
        }
        catch (EncryptAlgorithms.AlgorithmNotFoundException e) {
            this.log.debug((Object)e.getMessage());
        }
    }

    private void setKeyTransportAlgorithm(String transportAlgorithm) {
        if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(transportAlgorithm)) {
            this.disableRsaV1dot5 = false;
        }
        try {
            this.selectedKeyTransportAlg = EncryptAlgorithms.fromXMLCipher((String)transportAlgorithm);
        }
        catch (EncryptAlgorithms.AlgorithmNotFoundException e) {
            this.log.debug((Object)e.getMessage());
        }
    }

    public String getSelectedBlockEncryptAlgLabel() {
        return this.selectedBlockEncryptAlg.getLabel();
    }

    public String getKeyTransportAlgorithmLabel() {
        return this.selectedKeyTransportAlg.getLabel();
    }

    public String getSelectedEncryptionKeyAlias() {
        return this.getSelectedCert() != null ? this.getSelectedCert().getX509Certificate().getSubjectDN().toString() : this.getMessage("Common", "None");
    }

    public boolean getDisableAes256() {
        return this.disableAes256;
    }

    public void setDisableAes256(boolean disableAes256) {
        this.disableAes256 = disableAes256;
    }

    public EncryptAlgorithms getSelectedBlockEncryptAlg() {
        return this.selectedBlockEncryptAlg;
    }

    public void setSelectedBlockEncryptAlg(EncryptAlgorithms selectedBlockEncryptAlg) {
        this.selectedBlockEncryptAlg = selectedBlockEncryptAlg;
    }

    public EncryptAlgorithms getSelectedKeyTransportAlg() {
        return this.selectedKeyTransportAlg;
    }

    public void setSelectedKeyTransportAlg(EncryptAlgorithms selectedKeyTransportAlg) {
        this.selectedKeyTransportAlg = selectedKeyTransportAlg;
    }

    public EncryptAlgorithms getAes128() {
        return EncryptAlgorithms.AES_128;
    }

    public EncryptAlgorithms getAes256() {
        return EncryptAlgorithms.AES_256;
    }

    public EncryptAlgorithms getAes128Gcm() {
        return EncryptAlgorithms.AES_128_GCM;
    }

    public EncryptAlgorithms getAes192Gcm() {
        return EncryptAlgorithms.AES_192_GCM;
    }

    public EncryptAlgorithms getAes256Gcm() {
        return EncryptAlgorithms.AES_256_GCM;
    }

    public EncryptAlgorithms getRsaOaep() {
        return EncryptAlgorithms.RSA_OAEP;
    }

    public EncryptAlgorithms getRsaOaep256() {
        return EncryptAlgorithms.RSA_OAEP_256;
    }

    public EncryptAlgorithms getTripleDes() {
        return EncryptAlgorithms.TRIPLE_DES;
    }

    public EncryptAlgorithms getRsaV1dot5() {
        return EncryptAlgorithms.RSA_V1DOT5;
    }

    public ConnectionCerts getConnectionCerts() {
        return this.findParent(InUseCertsApi.class).getDsigConnectionCerts();
    }

    public Set<KeyAlgorithmFilter> getKeyAlgorithmFilter() {
        HashSet<KeyAlgorithmFilter> algFilters = new HashSet<KeyAlgorithmFilter>();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.RSA).build());
        return algFilters;
    }

    public String getHelpMessageP1() {
        return this.getMessage("Help_message_p1");
    }

    public String getHelpMessageP2() {
        return this.getMessage("Help_message_p2");
    }

    public boolean getDisableRsaV1dot5() {
        return this.disableRsaV1dot5;
    }

    public boolean getDisableTripleDes() {
        return PropertyInfo.isBCFIPSMode();
    }

    @Override
    public void loadTaskletToEdit() {
        CertManagementTasklet tasklet = this.createTaskletToLoad(CertManagementTasklet.class, "CertManagementTasklet", "XML Encryption Certificate Management");
        tasklet.setCertType(this.certType);
        tasklet.setSelectedCert(this.getSelectedCert());
        tasklet.setSecondarySelectedCert(this.getSecondarySelectedCert());
        tasklet.setActiveCerts(this.getActiveCerts());
        tasklet.setInactiveCerts(this.getInactiveCerts());
        tasklet.setMode(Mode.edit);
        tasklet.populate(this.getObjectForPopulate());
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
    }
}

