/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.util.DsigUtil;

public class SelectXmlFileState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String fileName;
    private long fileSize;
    private transient XmlObject xmlObject;
    private IUploadFile xmlFile;
    private String errorMessage;

    public SelectXmlFileState(Tasklet value) {
        super(value);
        this.setMenuName("Select Metadata File");
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.errorMessage = null;
        if (this.xmlFile != null && this.xmlFile.getSize() > 0L) {
            try {
                int offset;
                InputStream stream = this.xmlFile.getStream();
                this.fileSize = this.xmlFile.getSize();
                this.fileName = this.xmlFile.getFileName();
                if (this.fileSize > Integer.MAX_VALUE) {
                    // empty if block
                }
                byte[] bytes = new byte[(int)this.fileSize];
                int numRead = 0;
                for (offset = 0; offset < bytes.length && (numRead = stream.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
                if (offset < bytes.length) {
                    throw new IOException("Could not completely read file " + this.xmlFile.getFileName());
                }
                stream.close();
                this.xmlObject = DsigUtil.validateAndCheckIfSigned((String)new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IOException io) {
                this.log.debug((Object)("Importing this file caused an IOException! " + io));
                this.errorMessage = this.getMessage("Error_importing_file");
            }
            catch (XmlException e) {
                this.log.debug((Object)("Signing this file caused a XmlException! " + e));
                this.errorMessage = this.getMessage("Xml_exception");
            }
            catch (DsigUtil.AlreadySignedException e) {
                this.log.debug((Object)("Signing this file caused an AlreadySignedException! " + e));
                this.errorMessage = this.getMessage("Already_signed_exception");
            }
            catch (InvalidXmlException e) {
                this.log.debug((Object)("Signing this file caused an InvalidXmlException! " + e));
                this.errorMessage = this.getMessage("Invalid_xml_exception");
            }
        } else {
            this.fileName = null;
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.errorMessage != null) {
            delegate.setFormComponent(null);
            delegate.record(this.errorMessage, ValidationConstraint.REQUIRED);
        } else if (this.fileName == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Valid_path_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Filename"), this.fileName, this));
        summaryList.add(new SummaryInfo(this.getMessage("File_size"), Long.toString(this.fileSize), this));
    }

    public IUploadFile getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(IUploadFile xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public void setXmlObject(XmlObject xmlObject) {
        this.xmlObject = xmlObject;
    }
}

