/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AppAuthMap;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl;

public class ServiceAuthenticationState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private transient AppAuthMap attributeQueryMap;
    private transient AppAuthMap jmxMap;
    private transient AppAuthMap connectionManagementMap;
    private transient AppAuthMap ssoDirectoryServiceMap;

    public ServiceAuthenticationState(Tasklet parent) {
        super(parent);
        this.setMenuName("Service Authentication");
    }

    @Override
    public void populate(Object dataFromDisk) {
        AppAuthMapManagerImpl appAuthMapMgr = new AppAuthMapManagerImpl();
        this.attributeQueryMap = appAuthMapMgr.getAttributeQueryMap();
        this.jmxMap = appAuthMapMgr.getJmxMap();
        this.connectionManagementMap = appAuthMapMgr.getConnectionManagementMap();
        this.ssoDirectoryServiceMap = appAuthMapMgr.getSsoDirectoryServiceMap();
    }

    @Override
    public boolean save(Object dataToDisk) {
        AppAuthMapManagerImpl appAuthMapMgr = new AppAuthMapManagerImpl();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            appAuthMapMgr.saveSsoDirectoryServiceMap(this.ssoDirectoryServiceMap);
            appAuthMapMgr.saveJmxMap(this.jmxMap);
            appAuthMapMgr.saveConnectionManagementMap(this.connectionManagementMap);
            appAuthMapMgr.saveAttributeQueryMap(this.attributeQueryMap);
            appAuthMapMgr.removeLegacyConfigEntries();
            auditLoggerScope.log(AdminAuditLogger.Component.APPLICATION_AUTH, AdminAuditLogger.Event.MODIFY);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        PasswordValidator passwordValidator;
        boolean resetAttrQuerySecrets = false;
        boolean resetJmxSecrets = false;
        boolean resetConnMgmtSecrets = false;
        boolean resetSsoDirServiceSecrets = false;
        AppAuthMapManagerImpl appAuthMapMgr = new AppAuthMapManagerImpl();
        if (this.attributeQueryMap.isActive()) {
            if (StringUtils.isBlank((String)this.attributeQueryMap.getId())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("App_id_required") + " (Attribute Query)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.attributeQueryMap.getSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_required") + " (Attribute Query)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.attributeQueryMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Confirm_shared_secret_required") + " (Attribute Query)", ValidationConstraint.REQUIRED);
            }
            if (!this.attributeQueryMap.getSharedSecret().equals(this.attributeQueryMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_and_confirm_must_match") + " (Attribute Query)", ValidationConstraint.REQUIRED);
                resetAttrQuerySecrets = true;
            }
            passwordValidator = new PasswordValidator(this.attributeQueryMap.getSharedSecret(), "sharedSecret", "Shared Secret");
            if (!(appAuthMapMgr.getAttributeQueryMap().getSharedSecret() != null && appAuthMapMgr.getAttributeQueryMap().getSharedSecret().equals(this.attributeQueryMap.getSharedSecret()) || passwordValidator.validate())) {
                this.getDelegate().setFormComponent(null);
                this.recordErrors(passwordValidator.getErrors(), delegate);
                resetAttrQuerySecrets = true;
            }
            if (resetAttrQuerySecrets) {
                this.attributeQueryMap.setSharedSecret("");
                this.attributeQueryMap.setConfirmSharedSecret("");
            }
        }
        if (this.jmxMap.isActive()) {
            if (StringUtils.isBlank((String)this.jmxMap.getId())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("App_id_required") + " (JMX)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.jmxMap.getSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_required") + " (JMX)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.jmxMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Confirm_shared_secret_required") + " (JMX)", ValidationConstraint.REQUIRED);
            }
            if (!this.jmxMap.getSharedSecret().equals(this.jmxMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_and_confirm_must_match") + " (JMX)", ValidationConstraint.REQUIRED);
                resetJmxSecrets = true;
            }
            passwordValidator = new PasswordValidator(this.jmxMap.getSharedSecret(), "sharedSecret", "Shared Secret");
            if (!(appAuthMapMgr.getJmxMap().getSharedSecret() != null && appAuthMapMgr.getJmxMap().getSharedSecret().equals(this.jmxMap.getSharedSecret()) || passwordValidator.validate())) {
                this.getDelegate().setFormComponent(null);
                this.recordErrors(passwordValidator.getErrors(), delegate);
                resetJmxSecrets = true;
            }
            if (resetJmxSecrets) {
                this.jmxMap.setSharedSecret("");
                this.jmxMap.setConfirmSharedSecret("");
            }
        }
        if (this.connectionManagementMap.isActive()) {
            if (StringUtils.isBlank((String)this.connectionManagementMap.getId())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("App_id_required") + " (Connection Management)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.connectionManagementMap.getSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_required") + " (Connection Management)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.connectionManagementMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Confirm_shared_secret_required") + " (Connection Management)", ValidationConstraint.REQUIRED);
            }
            if (!this.connectionManagementMap.getSharedSecret().equals(this.connectionManagementMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_and_confirm_must_match") + " (Connection Management)", ValidationConstraint.REQUIRED);
                resetConnMgmtSecrets = true;
            }
            passwordValidator = new PasswordValidator(this.connectionManagementMap.getSharedSecret(), "sharedSecret", "Shared Secret");
            if (!(appAuthMapMgr.getConnectionManagementMap().getSharedSecret() != null && appAuthMapMgr.getConnectionManagementMap().getSharedSecret().equals(this.connectionManagementMap.getSharedSecret()) || passwordValidator.validate())) {
                this.getDelegate().setFormComponent(null);
                this.recordErrors(passwordValidator.getErrors(), delegate);
                resetConnMgmtSecrets = true;
            }
            if (resetConnMgmtSecrets) {
                this.connectionManagementMap.setSharedSecret("");
                this.connectionManagementMap.setConfirmSharedSecret("");
            }
        }
        if (!(!this.ssoDirectoryServiceMap.isActive() || StringUtils.isBlank((String)this.ssoDirectoryServiceMap.getId()) && StringUtils.isBlank((String)this.ssoDirectoryServiceMap.getSharedSecret()) && StringUtils.isBlank((String)this.ssoDirectoryServiceMap.getConfirmSharedSecret()))) {
            if (StringUtils.isBlank((String)this.ssoDirectoryServiceMap.getId())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("App_id_required") + " (SSO Directory Service)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.ssoDirectoryServiceMap.getSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_required") + " (SSO Directory Service)", ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.ssoDirectoryServiceMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Confirm_shared_secret_required") + " (SSO Directory Service)", ValidationConstraint.REQUIRED);
            }
            if (!this.ssoDirectoryServiceMap.getSharedSecret().equals(this.ssoDirectoryServiceMap.getConfirmSharedSecret())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Shared_secret_and_confirm_must_match") + " (SSO Directory Service)", ValidationConstraint.REQUIRED);
                resetSsoDirServiceSecrets = true;
            }
            passwordValidator = new PasswordValidator(this.ssoDirectoryServiceMap.getSharedSecret(), "sharedSecret", "Shared Secret");
            if (!(appAuthMapMgr.getSsoDirectoryServiceMap().getSharedSecret() != null && appAuthMapMgr.getSsoDirectoryServiceMap().getSharedSecret().equals(this.ssoDirectoryServiceMap.getSharedSecret()) || passwordValidator.validate())) {
                this.getDelegate().setFormComponent(null);
                this.recordErrors(passwordValidator.getErrors(), delegate);
                resetSsoDirServiceSecrets = true;
            }
            if (resetSsoDirServiceSecrets) {
                this.ssoDirectoryServiceMap.setSharedSecret("");
                this.ssoDirectoryServiceMap.setConfirmSharedSecret("");
            }
        }
    }

    public AppAuthMap getSsoDirectoryServiceMap() {
        return this.ssoDirectoryServiceMap;
    }

    public AppAuthMap getJmxMap() {
        return this.jmxMap;
    }

    public AppAuthMap getConnectionManagementMap() {
        return this.connectionManagementMap;
    }

    public AppAuthMap getAttributeQueryMap() {
        return this.attributeQueryMap;
    }

    public void setSsoDirectoryServiceMap(AppAuthMap appAuthMap) {
        this.ssoDirectoryServiceMap = appAuthMap;
    }

    public void setJmxMap(AppAuthMap appAuthMap) {
        this.jmxMap = appAuthMap;
    }

    public void setConnectionManagementMap(AppAuthMap appAuthMap) {
        this.connectionManagementMap = appAuthMap;
    }

    public void setAttributeQueryMap(AppAuthMap appAuthMap) {
        this.attributeQueryMap = appAuthMap;
    }

    public boolean isAuthorizedForConnectionManagement() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isAdmin() && user.isCryptoManager() && (!MgmtFactory.getAdminUserManager().allowAddUser() || user.isAdminManager());
    }
}

