/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.MessageCustomizationCard;
import com.pingidentity.fsm.state.impl.ServiceEndpointState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ServiceEndpointItem;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;

public class ServiceUrlConfigState
extends ServiceEndpointState {
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idp;
    private LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> messageHooks = new LinkedHashMap();
    private final Map<String, String> name2ContextMap;
    private final StringPairPropertySelectionModel hookTypes = new StringPairPropertySelectionModel();
    private boolean isEditingHook;
    private String selectedHookType;
    private String selectedHookExpr;
    private String linkContextName;

    public ServiceUrlConfigState(Tasklet value) {
        super(value);
        super.setBaseBindings(new String[]{"POST", "Artifact", "Redirect"});
        this.setMenuName("SSO Service URLs");
        super.setShowBindingField(true);
        super.setShowEndpointUrlField(true);
        this.name2ContextMap = MessageCustomizationCard.getVarNameToContextMap(this.getIsWsFed(), this.getIsIdpConn());
    }

    @Override
    public void onStateActivated() {
        if (this.hookTypes.getOptionCount() == 0) {
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        IdpConnection idp = (IdpConnection)dataFromDisk;
        EndpointGroup ssoServices = idp.getSingleSignOnServices();
        this.populate(ssoServices);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idp = (IdpConnection)dataFromDisk;
        EndpointGroup ssoServices = this.idp.getSingleSignOnServices();
        this.populate(ssoServices);
        if (this.getAllowAdvanced()) {
            this.isEditingHook = false;
            this.selectedHookType = null;
            this.selectedHookExpr = null;
            this.linkContextName = null;
            this.messageHooks.clear();
            MessageCustomizationCard.populateMsgHooks((ConnectionBase)this.idp, this.name2ContextMap, this.messageHooks);
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    public void populate(EndpointGroup ssoServices) {
        if (ssoServices != null) {
            this.setEndpoints(new ArrayList<ServiceEndpointItem>());
            for (Endpoint endpoint : ssoServices.getEndpoints()) {
                ServiceEndpointItem item = new ServiceEndpointItem(endpoint.getLocation(), this.bindingURIToDropdown(endpoint.getBinding()));
                this.getEndpoints().add(item);
            }
        }
    }

    @Override
    public boolean save(Object dataToSave) {
        ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
        for (ServiceEndpointItem item : this.getEndpoints()) {
            allEndpoints.add(new Endpoint(this.dropdownToBindingURI(item.getBinding()), item.getEndpointUrl()));
        }
        EndpointGroup ssoServices = new EndpointGroup();
        ssoServices.setEndpoints(allEndpoints);
        IdpConnection idp = (IdpConnection)dataToSave;
        idp.setSingleSignOnServices(ssoServices);
        if (this.allowExpressionSave()) {
            MessageCustomizationCard.saveMsgHooks((ConnectionBase)idp, this.name2ContextMap, this.messageHooks);
        }
        return true;
    }

    @Override
    public void cancel(Object newData) {
        super.cancelEdit();
        super.cancel(newData);
    }

    @Override
    public void reset() {
        super.cancelEdit();
        this.resetAll();
        this.messageHooks.clear();
    }

    @Override
    public LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> getMessageHooks() {
        return this.messageHooks;
    }

    @Override
    public boolean getIsIdpConn() {
        return true;
    }

    @Override
    public boolean getIsWsFed() {
        return false;
    }

    @Override
    public String getAdvancedNote() {
        return this.getMessageWithFullKey("ServiceUrlConfigState_advancedNote");
    }

    @Override
    public Map<String, String> getName2ContextMap() {
        return this.name2ContextMap;
    }

    @Override
    public boolean getIsEditingHook() {
        return this.isEditingHook;
    }

    @Override
    public void setIsEditingHook(boolean editing) {
        this.isEditingHook = editing;
    }

    @Override
    public StringPairPropertySelectionModel getHookTypes() {
        return this.hookTypes;
    }

    @Override
    public String getSelectedHookType() {
        return this.selectedHookType;
    }

    @Override
    public void setSelectedHookType(String selectedHookType) {
        this.selectedHookType = selectedHookType;
    }

    @Override
    public String getSelectedHookExpression() {
        return this.selectedHookExpr;
    }

    @Override
    public void setSelectedHookExpression(String selectedHookExpr) {
        this.selectedHookExpr = selectedHookExpr;
    }

    @Override
    public String getLinkContextName() {
        return this.linkContextName;
    }

    @Override
    public void setLinkContextName(String linkName) {
        this.linkContextName = linkName;
    }
}

