/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.SignatureVerificationTasklet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;

public class SignatureVerificationSettingsState
extends SingleTaskletState {
    private static final long serialVersionUID = 2L;
    private SpConnection spConnection;
    private IdpConnection idpConnection;
    private Object populateAllStatesData;

    public SignatureVerificationSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Signature Verification Settings");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof IdpConnection) {
            this.idpConnection = (IdpConnection)dataFromDisk;
        } else if (dataFromDisk instanceof SpConnection) {
            this.spConnection = (SpConnection)dataFromDisk;
        }
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        SignatureVerificationTasklet tasklet = this.getTaskletToEdit(SignatureVerificationTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(SignatureVerificationTasklet.class);
            if (this.spConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.spConnection);
            } else if (this.idpConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.idpConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Not_configured"), ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    public List<String> getActiveSignatureVerificationCertStrings() {
        SignatureVerificationTasklet t = this.getTaskletToEdit(SignatureVerificationTasklet.class);
        return t != null ? t.getActiveSignatureVerificationCertStrings() : Collections.emptyList();
    }

    public LinkedHashSet<Cert> getInUseVerificationCerts() {
        SignatureVerificationTasklet tasklet = this.getTaskletToEdit(SignatureVerificationTasklet.class);
        return tasklet != null ? tasklet.getInUseVerificationCerts() : new LinkedHashSet<Cert>();
    }

    public boolean isAnchored() {
        SignatureVerificationTasklet t = this.getTaskletToEdit(SignatureVerificationTasklet.class);
        return t != null ? t.isAnchored() : false;
    }

    public String getSubjectDn() {
        SignatureVerificationTasklet t = this.getTaskletToEdit(SignatureVerificationTasklet.class);
        return t != null ? t.getSubjectDn() : null;
    }

    public void metaDataReset() {
        SignatureVerificationTasklet tasklet = this.getTaskletToEdit(SignatureVerificationTasklet.class);
        if (tasklet != null) {
            tasklet.metaDataReset();
        }
    }
}

