/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.fsm.state.impl.GenericDsigCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;

public class SigningCertState
extends GenericDsigCertState {
    private static final long serialVersionUID = 20050515L;
    private static final DSignRotationSettingsManager dSignRotationManager = MgmtFactory.getDSignRotationSettingsManager();
    private IPropertySelectionModel rsaSignatureAlgsModel;
    private IPropertySelectionModel dsaSignatureAlgsModel;
    private IPropertySelectionModel ecSignatureAlgsModel;
    private boolean selectedCertKeyAlgChanged = false;

    public SigningCertState(Tasklet value) {
        super(value);
        this.certType = CertificateTypes.ValidTypes.dsigSigningCert;
        this.setMenuName("Digital Signature Settings");
        this.setIncludeKeyInfoVisible(true);
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.selectedCertKeyAlgChanged = false;
        if (this.connection.getSigningKeyAlias() != null) {
            this.setRawSelectedCert((Cert)this.getCertManager().getPkCert(this.connection.getSigningKeyAlias()));
        }
        if (this.connection.getSecondarySigningKeyAlias() != null) {
            this.setRawSecondarySelectedCert((Cert)this.getCertManager().getPkCert(this.connection.getSecondarySigningKeyAlias()));
        }
        this.setIncludeKeyInfo(this.connection.isIncludeCertInXmlSigs());
        this.setIncludeKeyValue(this.connection.isIncludeRawKeyInXmlSigs());
        String signingAlg = this.connection.getSigningAlgorithm();
        if (signingAlg != null) {
            this.setSelectedSigningAlgType(signingAlg);
        } else {
            this.setSelectedSigningAlgType(this.getDefaultSigningAlgorithm());
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        summaryList.add(new SummaryInfo(this.getMessage("Signing_algorithm"), this.getSelectedSigningAlgTypeForSummary(), this));
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.getSelectedCert() != null) {
            ((ConnectionBase)dataToDisk).setSigningKeyAlias(this.getSelectedCert().getAlias());
            if (this.getSecondarySelectedCert() != null && this.isShowSecondaryCertDropDown()) {
                ((ConnectionBase)dataToDisk).addAltSigningKeyAlias(this.getSecondarySelectedCert().getAlias(), null);
            } else {
                ((ConnectionBase)dataToDisk).setAltSigningKeyAliasToCertMap(null);
            }
            ((ConnectionBase)dataToDisk).setIncludeCertInXmlSigs(this.isIncludeKeyInfo());
            ((ConnectionBase)dataToDisk).setIncludeRawKeyInXmlSigs(this.isIncludeKeyValue());
            ((ConnectionBase)dataToDisk).setSigningAlgorithm(this.getSelectedSigningAlgType());
        }
        return true;
    }

    @Override
    public void setSelectedCert(Cert selectedCert) {
        String newKeyAlg;
        Cert oldCert = this.getSelectedCert();
        this.setRawSelectedCert(selectedCert);
        if (!(selectedCert == null || (newKeyAlg = this.getPubKeyAlgType()) == null || oldCert != null && newKeyAlg.equals(oldCert.getX509Certificate().getPublicKey().getAlgorithm()))) {
            this.selectedCertKeyAlgChanged = true;
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        if (this.selectedCertKeyAlgChanged) {
            String newKeyAlg = this.getPubKeyAlgType();
            if (newKeyAlg != null) {
                this.setDefaultSigningAlgOnNewKeyType(newKeyAlg);
            }
            this.selectedCertKeyAlgChanged = false;
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        Cert selectedSingingCert = super.getSelectedCert();
        if (selectedSingingCert != null) {
            Cert selectedSecondarySigningCert;
            String signingAlgName;
            SignatureAlgorithms signingAlgUtil = SignatureAlgorithms.getInstance();
            boolean isSigningAlgSupported = signingAlgUtil.isSignatureAlgorithmSupported(signingAlgName = selectedSingingCert.getPublicKeyAlgorithm());
            if (!isSigningAlgSupported) {
                Object[] errorParams = new Object[]{signingAlgName};
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Unsupported_signing_algorithm", errorParams), ValidationConstraint.DISALLOWED_PROTOCOL);
            }
            if ((selectedSecondarySigningCert = super.getSecondarySelectedCert()) != null) {
                if (selectedSecondarySigningCert.getAlias().equals(selectedSingingCert.getAlias())) {
                    delegate.record(this.getMessage("Primary_signing_cert_same_as_secondary_signing_cert", new Object[]{selectedSecondarySigningCert.getDescriptionForDisplay(35)}), ValidationConstraint.CONSISTENCY);
                } else {
                    DSignRotationSetting secondaryCertRotationSettings = dSignRotationManager.getRotationSetting(selectedSecondarySigningCert.getAlias());
                    if (secondaryCertRotationSettings != null && secondaryCertRotationSettings.isEnableCertRotation()) {
                        delegate.record(this.getMessage("Secondary_signing_cert_cannot_have_rotation_enabled"), ValidationConstraint.CONSISTENCY);
                    }
                }
            }
        }
    }

    protected void setDefaultSigningAlgOnNewKeyType(String newKeyAlg) {
        SignatureAlgorithm defaultSignatureAlg = SignatureAlgorithms.getInstance().getDefaultSignatureAlgorithmOfType(newKeyAlg);
        if (defaultSignatureAlg != null) {
            this.setSelectedSigningAlgType(defaultSignatureAlg.getUri());
        } else {
            this.setSelectedSigningAlgType(null);
        }
    }

    protected String getSelectedSigningAlgTypeForSummary() {
        return this.removeUnderscoreForDisplay(SignatureAlgorithms.getInstance().algUriToName(this.selectedSigningAlgType));
    }

    protected String getDefaultSigningAlgorithm() {
        SignatureAlgorithm algorithm = SignatureAlgorithms.getInstance().getDefaultSignatureAlgorithmOfType(this.getPubKeyAlgType());
        if (algorithm == null) {
            return null;
        }
        return algorithm.getUri();
    }

    @Override
    public String getKeyInfoText() {
        return this.getMessage("Key_info_text");
    }

    @Override
    public String getKeyValueText() {
        return this.getMessage("Key_value_text");
    }

    @Override
    public void onResumeDraft() {
        if (this.getSelectedCert() != null) {
            this.setRawSelectedCert((Cert)this.getCertManager().getPkCert(this.getSelectedCert().getAlias()));
        }
    }

    @Override
    protected void serializeSelectedCert(ObjectOutputStream out) throws IOException {
        Cert selCert = this.getSelectedCert();
        if (selCert == null) {
            out.writeObject(null);
        } else {
            out.writeObject(selCert.getAlias());
        }
    }

    @Override
    protected void serializeSecondarySelectedCert(ObjectOutputStream out) throws IOException {
    }

    @Override
    protected void deserializeSelectedCert(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object tmp = in.readObject();
        if (tmp != null) {
            this.setRawSelectedCert((Cert)this.getCertManager().getPkCert((String)tmp));
        }
    }

    @Override
    protected void deserializeSecondarySelectedCert(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    @Override
    public IPropertySelectionModel getRSASigningAlgTypeList() {
        if (this.rsaSignatureAlgsModel == null) {
            this.rsaSignatureAlgsModel = this.getSigningAlgModel("RSA");
        }
        return this.rsaSignatureAlgsModel;
    }

    @Override
    public IPropertySelectionModel getDSASigningAlgTypeList() {
        if (this.dsaSignatureAlgsModel == null) {
            this.dsaSignatureAlgsModel = this.getSigningAlgModel("DSA");
        }
        return this.dsaSignatureAlgsModel;
    }

    @Override
    public IPropertySelectionModel getECSigningAlgTypeList() {
        if (this.ecSignatureAlgsModel == null) {
            this.ecSignatureAlgsModel = this.getSigningAlgModel("EC");
        }
        return this.ecSignatureAlgsModel;
    }

    protected IPropertySelectionModel getSigningAlgModel(String prefix) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        for (SignatureAlgorithm sigAlg : SignatureAlgorithms.getInstance().getSupportedSignatureAlgorithms(prefix)) {
            model.add(this.removeUnderscoreForDisplay(sigAlg.getName()), sigAlg.getUri());
        }
        return model;
    }

    private String removeUnderscoreForDisplay(String stringWithUnderscore) {
        return stringWithUnderscore != null ? stringWithUnderscore.replaceAll("_", " ") : "";
    }

    @Override
    public boolean isShowRSASigningAlgorithm() {
        return "RSA".equals(this.getPubKeyAlgType()) && this.getRSASigningAlgTypeList().getOptionCount() > 0;
    }

    @Override
    public boolean isShowDSASigningAlgorithm() {
        return "DSA".equals(this.getPubKeyAlgType()) && this.getDSASigningAlgTypeList().getOptionCount() > 0;
    }

    @Override
    public boolean isShowECSigningAlgorithm() {
        return "EC".equals(this.getPubKeyAlgType()) && this.getECSigningAlgTypeList().getOptionCount() > 0;
    }

    @Override
    public String getSelectedSigningAlgType() {
        if (this.selectedSigningAlgType == null) {
            this.selectedSigningAlgType = this.getDefaultSigningAlgorithm();
        }
        return this.selectedSigningAlgType;
    }

    @Override
    public boolean isShowSecondaryCertDropDown() {
        String certAlias;
        Cert selectedCert = this.getSelectedCert();
        String string = certAlias = selectedCert != null ? selectedCert.getAlias() : null;
        if (certAlias != null) {
            boolean isShowSecondaryCert = MetadataImportExportUtil.allowAlternativeSigningCert((String)certAlias, (DSignRotationSettingsManager)dSignRotationManager);
            if (!isShowSecondaryCert) {
                this.setSecondarySelectedCert(null);
            }
            return isShowSecondaryCert;
        }
        return true;
    }
}

