/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.MessageCustomizationCard;
import com.pingidentity.fsm.state.impl.ServiceEndpointState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ServiceEndpointItem;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;

public class SloServiceUrlConfigState
extends ServiceEndpointState {
    private static final long serialVersionUID = 20050515L;
    private ConnectionBase connection;

    public SloServiceUrlConfigState(Tasklet value) {
        super(value);
        super.setBaseBindings(new String[]{"POST", "Artifact", "Redirect", "SOAP"});
        this.setMenuName("SLO Service URLs");
    }

    @Override
    public void onStateActivated() {
        super.setShowBindingField(true);
        super.setShowEndpointUrlField(true);
        super.setShowResponseUrlField(true);
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        EndpointGroup sloServices = connection.getSingleLogoutServices();
        this.populate(sloServices);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        EndpointGroup sloServices = this.connection.getSingleLogoutServices();
        this.populate(sloServices);
    }

    public void populate(EndpointGroup sloServices) {
        if (sloServices != null) {
            this.setEndpoints(new ArrayList<ServiceEndpointItem>());
            for (Endpoint endpoint : sloServices.getEndpoints()) {
                ServiceEndpointItem item = new ServiceEndpointItem(endpoint.getLocation(), this.bindingURIToDropdown(endpoint.getBinding()));
                if (endpoint.hasResponseLocation()) {
                    item.setResponseUrl(endpoint.getResponseLocation());
                }
                this.getEndpoints().add(item);
            }
        }
    }

    @Override
    public boolean save(Object dataToSave) {
        ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
        for (ServiceEndpointItem item : this.getEndpoints()) {
            if (StringUtils.isBlank((String)item.getResponseUrl())) {
                allEndpoints.add(new Endpoint(this.dropdownToBindingURI(item.getBinding()), item.getEndpointUrl()));
                continue;
            }
            allEndpoints.add(new Endpoint(this.dropdownToBindingURI(item.getBinding()), item.getEndpointUrl(), item.getResponseUrl()));
        }
        EndpointGroup sloServices = new EndpointGroup();
        sloServices.setEndpoints(allEndpoints);
        ConnectionBase conn = (ConnectionBase)dataToSave;
        conn.setSingleLogoutServices(sloServices);
        return true;
    }

    @Override
    public void cancel(Object newData) {
        super.cancelEdit();
        super.cancel(newData);
    }

    @Override
    public void reset() {
        super.cancelEdit();
        super.resetAll();
    }

    @Override
    public boolean getAllowAdvanced() {
        return false;
    }

    @Override
    public LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> getMessageHooks() {
        return null;
    }

    @Override
    public boolean getIsIdpConn() {
        return false;
    }

    @Override
    public boolean getIsWsFed() {
        return false;
    }

    @Override
    public boolean getIsEditingHook() {
        return false;
    }

    @Override
    public void setIsEditingHook(boolean editing) {
    }

    @Override
    public Map<String, String> getName2ContextMap() {
        return null;
    }

    @Override
    public StringPairPropertySelectionModel getHookTypes() {
        return null;
    }

    @Override
    public String getSelectedHookType() {
        return null;
    }

    @Override
    public void setSelectedHookType(String selectedHookType) {
    }

    @Override
    public String getSelectedHookExpression() {
        return null;
    }

    @Override
    public void setSelectedHookExpression(String selectedHookExpr) {
    }

    @Override
    public String getLinkContextName() {
        return null;
    }

    @Override
    public void setLinkContextName(String linkName) {
    }
}

