/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.PluginMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.SessionCreationAdapterTasklet;
import java.util.Collection;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;

public class SpAdapterManagementState
extends PluginMgmtState<AuthnAdapterDescriptor, AuthnAdapterInstance> {
    private static final long serialVersionUID = 20050515L;
    private final SpAdapterManager spAdapterManager;

    public SpAdapterManagementState(Tasklet value) {
        super(value);
        this.setMenuName("SP Adapters");
        this.spAdapterManager = MgmtFactory.getSpAdapterManager();
        this.setPluginManager(this.spAdapterManager);
    }

    @Override
    protected void buildTaskletList() {
        Collection spAdapterInstances = this.spAdapterManager.getInstances();
        for (AuthnAdapterInstance authnAdapterInstance : spAdapterInstances) {
            if (!authnAdapterInstance.isConnectionBasedPlugin()) {
                SessionCreationAdapterTasklet tasklet = this.createTasklet(this.getTaskletClass());
                tasklet.setMode(Mode.edit);
                tasklet.setPluginType(this.getPluginType());
                tasklet.setAuditLoggerComponent(this.getAuditLoggerComponent());
                tasklet.setPluginManager((PluginManager<?, ?>)this.spAdapterManager);
                tasklet.populate(authnAdapterInstance);
                tasklet.setFinishLabel("Save");
                if (this.getParent().showFinishButtonIfAuditor()) {
                    tasklet.setDisabled(true);
                }
                this.addTasklet(tasklet);
            }
            this.addToPlugin2Instance(authnAdapterInstance.getId(), authnAdapterInstance);
        }
        for (Tasklet t : this.getTasklets()) {
            PluginInstanceTasklet pit = (PluginInstanceTasklet)t;
            pit.setPluginManager(this);
        }
        this.sort();
    }

    @Override
    public String getTaskletMenuName() {
        return "Create Adapter Instance";
    }

    @Override
    protected Class<SessionCreationAdapterTasklet> getTaskletClass() {
        return SessionCreationAdapterTasklet.class;
    }

    public int getAdapterCount() {
        return this.getInstances().size();
    }

    @Override
    public boolean isDuplicateId(String id) {
        ConfigurablePluginInstance instance = MgmtFactory.getIdpAdapterManager().getInstance(id);
        return instance != null || super.isDuplicateId(id);
    }

    @Override
    public PluginManagementSupport.PluginManagementType getPluginType() {
        return PluginManagementSupport.PluginManagementType.SP_ADAPTER;
    }

    @Override
    public AdminAuditLogger.Component getAuditLoggerComponent() {
        return AdminAuditLogger.Component.SP_ADAPTER;
    }
}

