/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpProtocolSettingsTasklet;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.SpConnection;

public class SpProtocolSettingsState
extends SingleTaskletState
implements NeededCredentialsApi,
WebSsoApi {
    private static final long serialVersionUID = 20050515L;
    private SpConnection spConnection;
    private Object populateAllStatesData;

    public SpProtocolSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Protocol Settings");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.spConnection = (SpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        SpProtocolSettingsTasklet tasklet = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        if (tasklet == null) {
            tasklet = this.createTasklet(SpProtocolSettingsTasklet.class);
            tasklet.configureTasklet();
            if (this.spConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.spConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            Tasklet parentTasklet = this.getParent();
            if (!parentTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    @Override
    public void reset() {
        SpProtocolSettingsTasklet tasklet = this.getTaskletToEdit(SpProtocolSettingsTasklet.class);
        if (tasklet != null) {
            tasklet.resetAllStates();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Not_configured"), ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isBackChannelAuthenticationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureVerificationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureNeeded() : false;
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isEncryptionCertificateNeeded() : false;
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDecryptionKeyNeeded() : false;
    }

    @Override
    public boolean isInboundArtifact() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isInboundArtifact() : false;
    }

    @Override
    public boolean isSoapSlo() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isSoapSlo() : false;
    }

    @Override
    public boolean isArtifactSsoSlo() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isArtifactSsoSlo() : false;
    }

    @Override
    public boolean isInboundSoap() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isInboundSoap() : false;
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        WebSsoApi wsa = this.getTaskletToEdit(WebSsoApi.class);
        return wsa != null ? wsa.isAnyOutboundSoapNotUsingHttps() : false;
    }

    public boolean showOutboundSsoBinding() {
        SpConnectionConfigTasklet t = this.findParent(SpConnectionConfigTasklet.class);
        return t.isConnectionProtocol20() && t.isSpSSOSelected();
    }

    public boolean showOutboundSloBinding() {
        SpConnectionConfigTasklet t = this.findParent(SpConnectionConfigTasklet.class);
        return t.isAnySloSelected();
    }

    public boolean showArtifactLifetime() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getOutboundSsoBindingList().contains("Artifact") || t.getOutboundSloBindingList().contains("Artifact");
    }

    public boolean showEncriptionPolicy() {
        SpConnectionConfigTasklet t = this.findParent(SpConnectionConfigTasklet.class);
        return t.isConnectionProtocol20();
    }

    public String getOutboundSsoBindingListAsString() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getOutboundSsoBindingList());
    }

    public String getOutboundSloBindingListAsString() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getOutboundSloBindingList());
    }

    public String getInboundBindingListAsString() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getInboundBindingList());
    }

    public String getArtifactLifetime() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getArtifactLifetime();
    }

    public String getSignaturePolicyAsString() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getSignaturePolicyList());
    }

    public boolean showSignaturePolicy() {
        SpConnectionConfigTasklet t = this.findParent(SpConnectionConfigTasklet.class);
        return t.isSamlProtocol();
    }

    public String getEncryptionPolicyAsString() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return Util.listToCommaDelimString(t.getEncryptionPolicyList());
    }

    public boolean isConnectionProtocol20() {
        return this.findParent(MultiProtocolTasklet.class).isConnectionProtocol20();
    }

    public boolean showDefaultTargetUrl() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.isConnectionProtocol1x();
    }

    public String getDefaultTargetUrl() {
        SpProtocolSettingsTasklet t = (SpProtocolSettingsTasklet)this.getTaskletToEdit();
        return t.getDefaultTargetUrl();
    }
}

