/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.cert.X509Certificate;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class SslCertAuthState
extends CertificateState {
    private static final long serialVersionUID = 20050515L;

    public SslCertAuthState(Tasklet value) {
        super(value);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        SoapAuthInfo soapAuthOut = connection.getSoapAuthOut();
        SoapAuthInfo.CertAuthInfo certAuthInfo = soapAuthOut.getCertAuthInfo();
        String alias = certAuthInfo.getAlias();
        this.setSelectedCert((Cert)MgmtFactory.getSslAuthPkCertManager().getPkCert(alias));
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        SoapAuthInfo soapAuthOut = tempConnection.getSoapAuthOut();
        String alias = this.getSelectedCert().getAlias();
        X509Certificate x509Cert = this.getSelectedCert().getX509Certificate();
        soapAuthOut.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(null, null, x509Cert, alias));
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getSelectedCert() == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Cert_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void onResumeDraft() {
        if (this.getSelectedCert() != null) {
            this.setSelectedCert((Cert)this.getCertManager().getPkCert(this.getSelectedCert().getAlias()));
        }
    }

    public PkCertManager getCertManager() {
        return MgmtFactory.getSslAuthPkCertManager();
    }

    @Override
    protected void serializeSelectedCert(ObjectOutputStream out) throws IOException {
        Cert selCert = this.getSelectedCert();
        if (selCert == null) {
            out.writeObject(null);
        } else {
            out.writeObject(selCert.getAlias());
        }
    }

    @Override
    protected void serializeSecondarySelectedCert(ObjectOutputStream out) throws IOException {
    }

    @Override
    protected void deserializeSelectedCert(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object tmp = in.readObject();
        if (tmp != null) {
            this.setSelectedCert((Cert)this.getCertManager().getPkCert((String)tmp));
        }
    }

    @Override
    protected void deserializeSecondarySelectedCert(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

