/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.EnumPropertySelectionModel;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SystemOptionsState
extends SingleTaskletState {
    public static final IPropertySelectionModel FORWARDED_HEADER_INDEX_MODEL = new EnumPropertySelectionModel((Enum[])LocalSettings.ForwardedHeaderIndex.values());
    public static final IPropertySelectionModel CLIENT_CERT_ENCODING_FORMAT_MODEL = new EnumPropertySelectionModel((Enum[])LocalSettings.ClientCertEncodingFormat.values());
    private static final long serialVersionUID = 2L;
    private final transient LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();
    private String customGlobalHttpHeaderName;
    private LocalSettings.ForwardedHeaderIndex clientIpHeaderIndex = LocalSettings.ForwardedHeaderIndex.LAST;
    private String forwardedHostHeaderName;
    private LocalSettings.ForwardedHeaderIndex forwardedHostHeaderIndex = LocalSettings.ForwardedHeaderIndex.LAST;
    private boolean proxyTerminatesHttpsConns = false;
    private boolean enableClientCertHeaderAuth = false;
    private LocalSettings.ClientCertEncodingFormat clientCertEncodingFormat;
    private String clientCertSSLHeaderName;
    private String clientCertChainSSLHeaderName;

    public SystemOptionsState(Tasklet value) {
        super(value);
        this.setMenuName("System Options");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = this.localSettingsManager.getLocalSettings();
        this.customGlobalHttpHeaderName = localSettings.getCustomGlobalHttpHeaderName();
        this.clientIpHeaderIndex = localSettings.getClientIpHeaderIndex();
        this.forwardedHostHeaderName = localSettings.getForwardedHostHeaderName();
        this.forwardedHostHeaderIndex = localSettings.getForwardedHostHeaderIndex();
        this.proxyTerminatesHttpsConns = localSettings.isProxyTerminatesHttpsConns();
        this.enableClientCertHeaderAuth = localSettings.isEnableClientCertAuth();
        this.clientCertEncodingFormat = localSettings.getClientCertEncodingFormat();
        this.clientCertSSLHeaderName = localSettings.getClientCertSSLHeaderName();
        this.clientCertChainSSLHeaderName = localSettings.getClientCertChainSSLHeaderName();
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = this.localSettingsManager.getLocalSettings();
        localSettings.setCustomGlobalHttpHeaderName(StringUtils.defaultString((String)this.customGlobalHttpHeaderName).trim());
        localSettings.setClientIpHeaderIndex(this.clientIpHeaderIndex);
        localSettings.setForwardedHostHeaderName(StringUtils.defaultString((String)this.forwardedHostHeaderName).trim());
        localSettings.setForwardedHostHeaderIndex(this.forwardedHostHeaderIndex);
        localSettings.setProxyTerminatesHttpsConns(this.proxyTerminatesHttpsConns);
        localSettings.setEnableClientCertAuth(this.enableClientCertHeaderAuth);
        localSettings.setClientCertEncodingFormat(this.clientCertEncodingFormat);
        localSettings.setClientCertSSLHeaderName(StringUtils.defaultString((String)this.clientCertSSLHeaderName).trim());
        localSettings.setClientCertChainSSLHeaderName(StringUtils.defaultString((String)this.clientCertChainSSLHeaderName).trim());
        this.localSettingsManager.saveLocalSettings(localSettings);
        return true;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        this.doSummary(summaryList);
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet != null) {
            tasklet.getSummary(summaryList);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMenuName(), "", this, true));
        if (StringUtils.isNotBlank((String)this.customGlobalHttpHeaderName)) {
            summaryList.add(new SummaryInfo(this.getMessage("Custom_global_http_header_name"), this.customGlobalHttpHeaderName, this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Custom_global_http_header_name"), "None", this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Client_ip_header_index"), this.clientIpHeaderIndex.toString(), this));
        if (StringUtils.isNotBlank((String)this.forwardedHostHeaderName)) {
            summaryList.add(new SummaryInfo(this.getMessage("Forwarded_host_header_name"), this.forwardedHostHeaderName, this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Forwarded_host_header_name"), "None", this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Enable_client_cert_header_auth"), Boolean.valueOf(this.enableClientCertHeaderAuth).toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Client_cert_encoding_format"), this.clientCertEncodingFormat.toString(), this));
        if (StringUtils.isNotBlank((String)this.clientCertSSLHeaderName)) {
            summaryList.add(new SummaryInfo(this.getMessage("Client_cert_header_name"), this.clientCertSSLHeaderName, this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Client_cert_header_name"), "None", this));
        }
        if (StringUtils.isNotBlank((String)this.clientCertChainSSLHeaderName)) {
            summaryList.add(new SummaryInfo(this.getMessage("Client_cert_chain_header_name"), this.clientCertChainSSLHeaderName, this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Client_cert_chain_header_name"), "None", this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Forwarded_host_header_index"), this.forwardedHostHeaderIndex.toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Proxy_terminates_https_conns"), Boolean.valueOf(this.proxyTerminatesHttpsConns).toString(), this));
    }

    public String getCustomGlobalHttpHeaderName() {
        return this.customGlobalHttpHeaderName;
    }

    public void setCustomGlobalHttpHeaderName(String customGlobalHttpHeaderName) {
        this.customGlobalHttpHeaderName = customGlobalHttpHeaderName;
    }

    public LocalSettings.ForwardedHeaderIndex getClientIpHeaderIndex() {
        return this.clientIpHeaderIndex;
    }

    public void setClientIpHeaderIndex(LocalSettings.ForwardedHeaderIndex clientIpHeaderIndex) {
        this.clientIpHeaderIndex = clientIpHeaderIndex;
    }

    public String getForwardedHostHeaderName() {
        return this.forwardedHostHeaderName;
    }

    public void setForwardedHostHeaderName(String forwardedHostHeaderName) {
        this.forwardedHostHeaderName = forwardedHostHeaderName;
    }

    public LocalSettings.ForwardedHeaderIndex getForwardedHostHeaderIndex() {
        return this.forwardedHostHeaderIndex;
    }

    public void setForwardedHostHeaderIndex(LocalSettings.ForwardedHeaderIndex forwardedHostHeaderIndex) {
        this.forwardedHostHeaderIndex = forwardedHostHeaderIndex;
    }

    public boolean isProxyTerminatesHttpsConns() {
        return this.proxyTerminatesHttpsConns;
    }

    public void setProxyTerminatesHttpsConns(boolean proxyTerminates) {
        this.proxyTerminatesHttpsConns = proxyTerminates;
    }

    public boolean isEnableClientCertHeaderAuth() {
        return this.enableClientCertHeaderAuth;
    }

    public void setEnableClientCertHeaderAuth(boolean enableClientCertHeaderAuth) {
        this.enableClientCertHeaderAuth = enableClientCertHeaderAuth;
    }

    public LocalSettings.ClientCertEncodingFormat getClientCertEncodingFormat() {
        return this.clientCertEncodingFormat;
    }

    public void setClientCertEncodingFormat(LocalSettings.ClientCertEncodingFormat clientCertEncodingFormat) {
        this.clientCertEncodingFormat = clientCertEncodingFormat;
    }

    public String getClientCertSSLHeaderName() {
        return this.clientCertSSLHeaderName;
    }

    public void setClientCertSSLHeaderName(String clientCertSSLHeaderName) {
        this.clientCertSSLHeaderName = clientCertSSLHeaderName;
    }

    public String getClientCertChainSSLHeaderName() {
        return this.clientCertChainSSLHeaderName;
    }

    public void setClientCertChainSSLHeaderName(String clientCertChainSSLHeaderName) {
        this.clientCertChainSSLHeaderName = clientCertChainSSLHeaderName;
    }
}

