/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SpProtocolSettingsTasklet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;

public class TargetApplicationInfoState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private String applicationName;
    private URL applicationIconUrl;
    private String applicationIconUrlStr;

    public TargetApplicationInfoState(Tasklet parent) {
        super(parent);
        this.setMenuName("Target App Info");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof Direct2SpAdapterMapping) {
            Direct2SpAdapterMapping a2aMapping = (Direct2SpAdapterMapping)dataFromDisk;
            this.applicationName = a2aMapping.getApplicationName();
            if (a2aMapping.getApplicationIconUrl() != null) {
                this.applicationIconUrlStr = a2aMapping.getApplicationIconUrl().toExternalForm();
            }
        }
    }

    @Override
    public boolean save(Object dataToSave) {
        if (dataToSave instanceof Direct2SpAdapterMapping) {
            Direct2SpAdapterMapping a2aMapping = (Direct2SpAdapterMapping)dataToSave;
            a2aMapping.setApplicationName(this.applicationName);
            a2aMapping.setApplicationIconUrl(this.applicationIconUrl);
        }
        return true;
    }

    @Override
    public void reset() {
        this.applicationName = "";
        this.applicationIconUrlStr = "";
        this.applicationIconUrl = null;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (StringUtils.isNotBlank((String)this.applicationName)) {
            summaryList.add(new SummaryInfo("Application Name", this.applicationName, this));
        }
        if (StringUtils.isNotBlank((String)this.applicationIconUrlStr)) {
            summaryList.add(new SummaryInfo("Application Icon URL", this.applicationIconUrlStr, this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        HttpUrlValidator validator = new HttpUrlValidator(this.applicationIconUrlStr, true, null);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
        this.applicationIconUrl = this.getUrl(this.applicationIconUrlStr);
    }

    protected URL getUrl(String urlStr) {
        if (!StringUtils.isBlank((String)urlStr)) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                this.log.debug((Object)(urlStr + " is an invalid URL: " + e));
            }
        }
        return null;
    }

    public boolean isRequired() {
        Tasklet parent = this.findParent(SpProtocolSettingsTasklet.class);
        return parent != null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = StringUtils.stripToEmpty((String)applicationName);
    }

    public String getApplicationIconUrlStr() {
        return this.applicationIconUrlStr;
    }

    public void setApplicationIconUrlStr(String applicationIconUrlStr) {
        this.applicationIconUrlStr = applicationIconUrlStr;
    }

    public URL getApplicationIconUrl() {
        return this.applicationIconUrl;
    }
}

