/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.TargetUrlMappingItem;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.UrlToTargetMappings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceOneStarImpl;
import org.sourceid.saml20.service.TargetSessionId;

@AutoSaveState
public class TargetUrlMappingState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
    private String urlToAdd;
    private TargetSessionId.TargetSessionType targetTypeToAdd;
    private String targetIdToAdd;
    private String urlToEdit;
    private TargetSessionId.TargetSessionType targetTypeToEdit;
    private String targetIdToEdit;
    private ArrayList<TargetUrlMappingItem> urlMappingList;
    private int lastIndex = -1;
    private List<UrlToTargetMapping> newMapping;
    private boolean stateActivated;
    private final boolean fedHubEnabled;
    private String selectedTargetSessionToAddDisplayName;
    private String selectedTargetSessionToAddTypeAndId;
    private String selectedTargetSessionToEditDisplayName;
    private String selectedTargetSessionToEditTypeAndId;

    public TargetUrlMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Target URL Mappings");
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        this.fedHubEnabled = localSettings.isEnableFederationHub();
    }

    @Override
    public void onStateActivated() {
        if (this.urlMappingList == null) {
            LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
            LocalSettings localSettings = localSettingsMgr.getLocalSettings();
            UrlToTargetMappings urlToAdapterMapping = localSettingsMgr.getUrlToAdapterMapping();
            this.newMapping = urlToAdapterMapping.getMappings();
            this.urlMappingList = new ArrayList();
            for (UrlToTargetMapping item : this.newMapping) {
                TargetUrlMappingItem temp;
                TargetSessionId.TargetSessionType targetType = item.getTargetType();
                if (targetType != TargetSessionId.TargetSessionType.ADAPTER && (!this.fedHubEnabled || targetType != TargetSessionId.TargetSessionType.SP_CONN)) continue;
                String url = item.getUrl();
                try {
                    url = Util.getUrlWithLowercaseHostname((String)url);
                }
                catch (URISyntaxException e) {
                    this.log.warn((Object)String.format("Target Resource URL %s is not a valid URI: " + e.getMessage(), url));
                }
                if (targetType == TargetSessionId.TargetSessionType.ADAPTER) {
                    temp = new TargetUrlMappingItem(url, this.getAdapterName(item.getTargetId()), targetType, item.getTargetId());
                } else {
                    ConnectionDbEntry entry = connectionDb.getEntry(item.getTargetId());
                    if (!localSettings.isEnableProtocolIdP(entry.getProtocol())) continue;
                    temp = new TargetUrlMappingItem(url, entry.getName(), targetType, item.getTargetId());
                }
                if (this.getParent().showFinishButtonIfAuditor()) {
                    temp.setDisabled(true);
                }
                this.urlMappingList.add(temp);
            }
        }
        this.stateActivated = true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.urlMappingList = null;
        this.onStateActivated();
    }

    @Override
    public void reset() {
        this.urlMappingList = null;
        this.urlToAdd = null;
        this.targetTypeToAdd = null;
        this.targetIdToAdd = null;
        this.urlToEdit = null;
        this.targetTypeToEdit = null;
        this.targetIdToEdit = null;
        this.lastIndex = -1;
        this.newMapping = new ArrayList<UrlToTargetMapping>();
        this.selectedTargetSessionToAddDisplayName = null;
        this.selectedTargetSessionToAddTypeAndId = null;
        this.selectedTargetSessionToEditDisplayName = null;
        this.selectedTargetSessionToEditTypeAndId = null;
        this.onStateActivated();
    }

    private String getAdapterName(String targetId) {
        String name = "";
        for (AuthnAdapterInstance adapterInstance : MgmtFactory.getSpAdapterManager().getNonConnectionBasedInstances()) {
            if (!adapterInstance.getId().equals(targetId)) continue;
            name = adapterInstance.getName();
            break;
        }
        return name;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.urlMappingList != null) {
            LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
            this.newMapping = new ArrayList<UrlToTargetMapping>();
            for (TargetUrlMappingItem item : this.urlMappingList) {
                this.newMapping.add(new UrlToTargetMapping(item.getUrl(), item.getSelectedType(), item.getSelectedTarget()));
            }
            UrlToTargetMappings urlToAdapterMapping = localSettingsMgr.getUrlToAdapterMapping();
            urlToAdapterMapping.setMappings(this.newMapping);
            localSettingsMgr.saveUrlToAdapterMapping(urlToAdapterMapping);
        }
        this.getParent().checkForClusterReplication();
        return true;
    }

    private boolean validateUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            this.delegate.record(this.getMessage("Url_required"), ValidationConstraint.REQUIRED);
            return false;
        }
        UrlMatchingServiceOneStarImpl uriMatcher = new UrlMatchingServiceOneStarImpl();
        if (!uriMatcher.isValidURIPattern(url)) {
            this.delegate.record(this.getMessage("Malformed_url"), ValidationConstraint.URL_FORMAT);
            return false;
        }
        return true;
    }

    private boolean validateTargetTypeId(TargetSessionId.TargetSessionType type, String targetIdToCheck) {
        if (type == null || targetIdToCheck == null) {
            this.delegate.record(this.getMessage("Type_required"), ValidationConstraint.REQUIRED);
            return false;
        }
        return true;
    }

    public void addUrlMapping() {
        try {
            this.urlToAdd = Util.getUrlWithLowercaseHostname((String)this.urlToAdd);
        }
        catch (URISyntaxException e) {
            this.log.warn((Object)String.format("Target Resource URL %s is not a valid URI: " + e.getMessage(), this.urlToAdd));
        }
        if (!this.validateUrl(this.urlToAdd)) {
            return;
        }
        if (!this.validateTargetTypeId(this.targetTypeToAdd, this.targetIdToAdd)) {
            return;
        }
        TargetUrlMappingItem newItem = new TargetUrlMappingItem(this.urlToAdd, this.selectedTargetSessionToAddDisplayName, this.targetTypeToAdd, this.targetIdToAdd);
        this.add(newItem);
        this.save(null);
    }

    public void updateUrlMapping() {
        if (!this.validateUrl(this.urlToEdit)) {
            return;
        }
        try {
            this.urlToEdit = Util.getUrlWithLowercaseHostname((String)this.urlToEdit);
        }
        catch (URISyntaxException e) {
            this.log.warn((Object)String.format("Target Resource URL %s is not a valid URI: " + e.getMessage(), this.urlToEdit));
        }
        if (!this.validateTargetTypeId(this.targetTypeToEdit, this.targetIdToEdit)) {
            return;
        }
        TargetUrlMappingItem item = this.urlMappingList.get(this.lastIndex);
        SelectedOption option = SelectionFilterList.parseSelectedOptionString(this.selectedTargetSessionToEditTypeAndId);
        this.setTargetTypeToEdit(this.translateSearchableType(option.getType()));
        this.setTargetIdToEdit(option.getId());
        TargetSessionId.TargetSessionType type = this.translateSearchableType(option.getType());
        item.setSelectedType(type);
        item.setSelectedTarget(this.getCorrectedId(option.getId(), type));
        item.setTargetName(this.selectedTargetSessionToEditDisplayName);
        item.setUrl(this.urlToEdit);
        item.setMappingToEdit(false);
        this.lastIndex = -1;
        this.save(null);
    }

    public void editUrlMapping(int index, String urlToEdit) {
        this.urlToEdit = StringUtils.trim((String)urlToEdit);
        this.lastIndex = index;
        TargetUrlMappingItem item = this.urlMappingList.get(index);
        this.targetTypeToEdit = item.getSelectedType();
        this.targetIdToEdit = item.getSelectedTarget();
        SelectedOption option = TargetSessionId.TargetSessionType.SP_CONN.equals((Object)this.targetTypeToEdit) ? new SelectedOption(this.translateTargetSessionType(this.targetTypeToEdit), this.getEntityIdFromId(this.targetIdToEdit)) : new SelectedOption(this.translateTargetSessionType(this.targetTypeToEdit), this.targetIdToEdit);
        this.selectedTargetSessionToEditDisplayName = item.getTargetName();
        this.selectedTargetSessionToEditTypeAndId = option.toString();
        item.setMappingToEdit(true);
    }

    public void deleteUrlMapping(int index) {
        this.urlMappingList.remove(index);
        this.save(null);
    }

    private void add(TargetUrlMappingItem newItem) {
        if (this.urlMappingList == null) {
            this.urlMappingList = new ArrayList();
        }
        this.urlMappingList.add(newItem);
        this.setUrlToAdd(null);
        if (this.fedHubEnabled) {
            this.setTargetTypeToAdd(null);
        }
        this.setTargetIdToAdd(null);
        this.selectedTargetSessionToAddDisplayName = null;
        this.selectedTargetSessionToAddTypeAndId = null;
    }

    public void moveUp(int index) {
        if (index > 0) {
            TargetUrlMappingItem item = this.urlMappingList.get(index);
            this.urlMappingList.set(index, this.urlMappingList.get(index - 1));
            this.urlMappingList.set(index - 1, item);
        }
        this.save(null);
    }

    public void moveDown(int index) {
        if (index < this.urlMappingList.size() - 1) {
            TargetUrlMappingItem item = this.urlMappingList.get(index);
            this.urlMappingList.set(index, this.urlMappingList.get(index + 1));
            this.urlMappingList.set(index + 1, item);
        }
        this.save(null);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.lastIndex != -1) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Finish_editing"), ValidationConstraint.REQUIRED);
        }
    }

    public void cancelEdit() {
        if (this.lastIndex > -1) {
            TargetUrlMappingItem item = this.urlMappingList.get(this.lastIndex);
            item.setMappingToEdit(false);
            this.lastIndex = -1;
        }
    }

    public String getClassType() {
        if (this.lastIndex == -1) {
            return "plain";
        }
        return "disabled";
    }

    public List<TargetUrlMappingItem> getUrlMappings() {
        return this.urlMappingList;
    }

    public List<TargetUrlMappingItem> getUrlMappingsCopy() {
        return new ArrayList<TargetUrlMappingItem>(this.urlMappingList);
    }

    public TargetSessionId.TargetSessionType getTargetTypeToAdd() {
        return this.targetTypeToAdd;
    }

    public void setTargetTypeToAdd(TargetSessionId.TargetSessionType targetTypeToAdd) {
        this.targetTypeToAdd = targetTypeToAdd;
    }

    public String getTargetIdToAdd() {
        return this.targetIdToAdd;
    }

    public void setTargetIdToAdd(String targetIdToAdd) {
        this.targetIdToAdd = targetIdToAdd;
    }

    public String getUrlToAdd() {
        return this.urlToAdd;
    }

    public void setUrlToAdd(String urlToAdd) {
        this.urlToAdd = StringUtils.trim((String)urlToAdd);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(int lastIndex) {
        this.lastIndex = lastIndex;
    }

    public String getUrlToEdit() {
        return this.urlToEdit;
    }

    public void setUrlToEdit(String urlToEdit) {
        this.urlToEdit = StringUtils.trim((String)urlToEdit);
    }

    public TargetSessionId.TargetSessionType getTargetTypeToEdit() {
        return this.targetTypeToEdit;
    }

    public void setTargetTypeToEdit(TargetSessionId.TargetSessionType targetTypeToEdit) {
        this.targetTypeToEdit = targetTypeToEdit;
    }

    public String getTargetIdToEdit() {
        return this.targetIdToEdit;
    }

    public void setTargetIdToEdit(String targetIdToEdit) {
        this.targetIdToEdit = targetIdToEdit;
    }

    public String getSelectedTargetSessionToEditDisplayName() {
        return this.selectedTargetSessionToEditDisplayName;
    }

    public void setSelectedTargetSessionToEditDisplayName(String selectedTargetSessionToEditDisplayName) {
        this.selectedTargetSessionToEditDisplayName = selectedTargetSessionToEditDisplayName;
    }

    public String getSelectedTargetSessionToEditTypeAndId() {
        return this.selectedTargetSessionToEditTypeAndId;
    }

    public void setSelectedTargetSessionToEditTypeAndId(String selectedTargetSessionToEditTypeAndId) {
        this.selectedTargetSessionToEditTypeAndId = selectedTargetSessionToEditTypeAndId;
        SelectedOption option = SelectionFilterList.parseSelectedOptionString(selectedTargetSessionToEditTypeAndId);
        this.setTargetTypeToEdit(this.translateSearchableType(option.getType()));
        this.setTargetIdToEdit(this.getCorrectedId(option.getId(), this.targetTypeToEdit));
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypesToEdit() {
        return this.getSearchableTypesToAdd();
    }

    public String getSelectedTargetSessionToAddDisplayName() {
        return this.selectedTargetSessionToAddDisplayName;
    }

    public void setSelectedTargetSessionToAddDisplayName(String selectedTargetSessionToAddDisplayName) {
        this.selectedTargetSessionToAddDisplayName = selectedTargetSessionToAddDisplayName;
    }

    public String getSelectedTargetSessionToAddTypeAndId() {
        return this.selectedTargetSessionToAddTypeAndId;
    }

    public void setSelectedTargetSessionToAddTypeAndId(String selectedTargetSessionToAddTypeAndId) {
        this.selectedTargetSessionToAddTypeAndId = selectedTargetSessionToAddTypeAndId;
        if (StringUtils.isNotEmpty((String)selectedTargetSessionToAddTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(selectedTargetSessionToAddTypeAndId);
            this.setTargetTypeToAdd(this.translateSearchableType(option.getType()));
            this.setTargetIdToAdd(this.getCorrectedId(option.getId(), this.targetTypeToAdd));
        }
    }

    private String getCorrectedId(String id, TargetSessionId.TargetSessionType type) {
        if (TargetSessionId.TargetSessionType.SP_CONN.equals((Object)type)) {
            return this.getConnectionIdFromEntityId(id);
        }
        return id;
    }

    private String getEntityIdFromId(String id) {
        ConnectionDbEntry conn = connectionDb.getEntry(id);
        return conn.getEntityId();
    }

    private String getConnectionIdFromEntityId(String entityId) {
        ConnectionDbEntry conn = connectionDb.getEntryByEntityId(Role.SP, entityId);
        return conn.getId();
    }

    private TargetSessionId.TargetSessionType translateSearchableType(FilterableSelectionFieldDescriptor.SearchableType searchableType) {
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.SP_ADAPTER)) {
            return TargetSessionId.TargetSessionType.ADAPTER;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION)) {
            return TargetSessionId.TargetSessionType.SP_CONN;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT)) {
            return TargetSessionId.TargetSessionType.AUTHN_POLICY;
        }
        this.log.error((Object)("No targetSessionType found for " + searchableType.name()));
        return null;
    }

    private FilterableSelectionFieldDescriptor.SearchableType translateTargetSessionType(TargetSessionId.TargetSessionType sessionType) {
        switch (sessionType) {
            case ADAPTER: {
                return FilterableSelectionFieldDescriptor.SearchableType.SP_ADAPTER;
            }
            case SP_CONN: {
                return FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION;
            }
            case AUTHN_POLICY: {
                return FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT;
            }
        }
        this.log.error((Object)("No SearchableType found for " + sessionType.name()));
        return null;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypesToAdd() {
        if (this.fedHubEnabled) {
            FilterableSelectionFieldDescriptor.SearchableTypeConfig spConns = new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION, Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("hasC2cMappings", "true")));
            return Arrays.asList(FilterableSelectionFieldDescriptor.SearchableTypeConfig.SP_ADAPTER, spConns);
        }
        return Collections.singletonList(FilterableSelectionFieldDescriptor.SearchableTypeConfig.SP_ADAPTER);
    }

    public boolean isStateActivated() {
        return this.stateActivated;
    }

    public boolean isFedHubEnabled() {
        return this.fedHubEnabled;
    }

    public String getDisabledClass() {
        return "disabled";
    }
}

