/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.fsm.state.impl.PluginMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenPluginManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.plugin.process.TokenPluginDescriptor;

public class TokenPluginMgmtState<T extends TokenPluginInstance>
extends PluginMgmtState<TokenPluginDescriptor, T> {
    private static final long serialVersionUID = 20050515L;
    public static final String TASKLET_NAME_TOKEN_PROCESSOR = "TokenProcessorInstanceTasklet";
    public static final String TASKLET_NAME_TOKEN_GENERATOR = "TokenGeneratorInstanceTasklet";
    private PluginManagementSupport.PluginManagementType pluginType;

    public TokenPluginMgmtState(Tasklet value, Class<? extends TokenPluginManager> tpmClass) {
        super(value);
        this.pluginManager = (PluginManager)GlobalRegistry.getService(tpmClass);
        if (this.pluginManager instanceof TokenProcessorManager) {
            this.pluginType = PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR;
        } else if (this.pluginManager instanceof TokenGeneratorManager) {
            this.pluginType = PluginManagementSupport.PluginManagementType.TOKEN_GENERATOR;
        }
    }

    @Override
    protected Class<PluginInstanceTasklet> getTaskletClass() {
        return PluginInstanceTasklet.class;
    }

    @Override
    public String getTaskletClassName() {
        String taskletName = "UNKNOWN_TASKLET_NAME";
        if (this.pluginManager instanceof TokenProcessorManager) {
            taskletName = TASKLET_NAME_TOKEN_PROCESSOR;
        } else if (this.pluginManager instanceof TokenGeneratorManager) {
            taskletName = TASKLET_NAME_TOKEN_GENERATOR;
        }
        return taskletName;
    }

    @Override
    public String getTaskletMenuName() {
        String taskletMenuName = "UNKNOWN_MENU_NAME";
        if (this.pluginManager instanceof TokenProcessorManager) {
            taskletMenuName = "Create Token Processor Instance";
        } else if (this.pluginManager instanceof TokenGeneratorManager) {
            taskletMenuName = "Create Token Generator Instance";
        }
        return taskletMenuName;
    }

    @Override
    public boolean showCheckUsageLink() {
        return false;
    }

    @Override
    public PluginManagementSupport.PluginManagementType getPluginType() {
        return this.pluginType;
    }

    @Override
    public boolean save(Object nullData) {
        if (this.pluginType == PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR) {
            ((TokenProcessorManager)this.pluginManager).reload();
        } else if (this.pluginType == PluginManagementSupport.PluginManagementType.TOKEN_GENERATOR) {
            ((TokenGeneratorManager)this.pluginManager).reload();
        }
        return super.save(nullData);
    }

    @Override
    public AdminAuditLogger.Component getAuditLoggerComponent() {
        if (this.pluginType == PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR) {
            return AdminAuditLogger.Component.TOKEN_PROCESSOR;
        }
        return AdminAuditLogger.Component.TOKEN_GENERATOR;
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        Tasklet tasklet = this.getTasklet(taskletToDelete);
        PluginInstanceApi pluginInstanceApi = (PluginInstanceApi)((Object)tasklet);
        String pluginId = pluginInstanceApi.getPluginId();
        super.deleteTasklet(taskletToDelete);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.updateProtocolSettingsDepsForWsTrustConfig(pluginId, this.pluginType);
    }
}

