/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.PingOneSettingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import java.io.IOException;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class UpdatePingOneIdentityRepositoryState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private boolean updateSuccessful = false;
    private boolean confirmUpdatePingOne = false;

    public UpdatePingOneIdentityRepositoryState(IWizard owner) {
        super(owner);
    }

    public void requestUpdatePingOne() {
        this.confirmUpdatePingOne = true;
    }

    public void openPingOneSettings(IRequestCycle cycle) {
        Tasklet currentTasklet = this.getParent();
        while (currentTasklet.getParentTasklet() != null) {
            Tasklet parentTasklet = currentTasklet.getParentTasklet();
            currentTasklet.onCancel(cycle);
            currentTasklet = parentTasklet;
        }
        Tasklet portalTasklet = currentTasklet;
        SingleStateTasklet pingOneSettingsTasklet = this.createTaskletToLoad(SingleStateTasklet.class, "PingOneSettingsTasklet", "PingOne for Enterprise Settings");
        pingOneSettingsTasklet.setFinishAvailable(!this.getCurrentUser().isAuditor());
        pingOneSettingsTasklet.setCycle(cycle);
        pingOneSettingsTasklet.setInitialState(new PingOneSettingsState(pingOneSettingsTasklet));
        pingOneSettingsTasklet.setMode(Mode.edit);
        pingOneSettingsTasklet.populateAllStates(MgmtFactory.getLocalSettingsManager().getLocalSettings());
        portalTasklet.loadTasklet(pingOneSettingsTasklet);
    }

    public void updatePingOne() {
        this.confirmUpdatePingOne = false;
        try {
            MgmtFactory.getPingOneAdminService().getSpConnectionFactory().uploadIdpMetadata();
            this.updateSuccessful = true;
        }
        catch (IOException e) {
            this.recordErrorMsg("An error occurred while updating the PingOne Identity Repository. Please check your network configuration. See server logs for more details.");
            this.log.error((Object)"An error occurred while uploading IdP metadata to PingOne", (Throwable)e);
        }
    }

    public void cancelUpdatePingOne() {
        this.confirmUpdatePingOne = false;
    }

    public boolean isUpdatePingOneEnabled() {
        return !this.confirmUpdatePingOne && !this.updateSuccessful;
    }

    public boolean isUpdateSuccessful() {
        return this.updateSuccessful;
    }

    public boolean isConfirmUpdatePingOne() {
        return this.confirmUpdatePingOne;
    }
}

