/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.UsersTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustUsersTasklet;
import com.pingidentity.util.AdminBaseUrlUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class UserMgmtState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String userName;
    private String currentPassword;
    private String newPassword;
    private String newPasswordConfirm;

    public UserMgmtState(IWizard owner) {
        super(owner);
        this.setMenuName("Change Password");
    }

    public UserMgmtState(IWizard owner, String value) {
        super(owner, value);
    }

    @Override
    public void onStateActivated() {
        this.userName = this.getParent().getSystemVisit().getCurrentUser().getUserName();
    }

    @Override
    public boolean save(Object dataToDisk) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            AdminUserManager adminUserManager = MgmtFactory.getAdminUserManager();
            adminUserManager.changePassword(this.userName, this.newPassword, false);
            auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.PASSWORD_CHANGE);
        }
        AdministrativeUser adminUser = this.getVisit().getCurrentUser();
        adminUser.setPassword(this.newPassword);
        adminUser.setChangeRequired(false);
        this.sendPwdChangeEmail();
        if (this.getWizard() != null) {
            boolean isLoginState;
            UsersTasklet wizard = (UsersTasklet)this.getWizard();
            boolean bl = isLoginState = wizard.getParentTasklet() == null;
            if (isLoginState) {
                if (wizard.getCycle() == null || wizard.getCycle().getRequestContext() == null) {
                    this.log.debug((Object)"Could not redirect after user set password. No context found.");
                } else {
                    StringBuilder baseUrl = AdminBaseUrlUtil.getAdminBaseUrlFromServletRequest((HttpServletRequest)wizard.getCycle().getRequestContext().getRequest());
                    throw new RedirectException(baseUrl + "/pingfederate/app");
                }
            }
        }
        return true;
    }

    private void sendPwdChangeEmail() {
        AdministrativeUser userMakingRequest = this.getVisit().getCurrentUser();
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        if (settings.isEnableAccountChangesNotification()) {
            notificationSupportHelper.sendPasswordChangeEmail(userMakingRequest, userMakingRequest, settings);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getParent().getSystemVisit().getCurrentUser().matches(this.currentPassword)) {
            PasswordValidator passwordValidator = new PasswordValidator(this.newPassword);
            if (StringUtils.isBlank((String)this.newPassword.trim())) {
                delegate.record(this.getMessage("Password_required"), ValidationConstraint.REQUIRED);
            } else if (!passwordValidator.validate()) {
                this.recordErrors(passwordValidator.getErrors(), delegate);
            } else if (!this.newPassword.equals(this.newPasswordConfirm)) {
                delegate.record(this.getMessage("Passwords_dont_match"), ValidationConstraint.REQUIRED);
            } else if (this.newPassword.equals(this.currentPassword)) {
                delegate.record(this.getMessage("Password_must_change"), ValidationConstraint.REQUIRED);
            }
        } else {
            delegate.record(this.getMessage("Current_password_invalid"), ValidationConstraint.REQUIRED);
            AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.PASSWORD_CHANGE, (String)this.getMessage("Current_password_doesnt_match"));
        }
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirm() {
        return this.newPasswordConfirm;
    }

    public void setNewPasswordConfirm(String newPasswordConfirm) {
        this.newPasswordConfirm = newPasswordConfirm;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public boolean displayCurrentPassword() {
        return true;
    }

    public boolean displayUsernameTextField() {
        return false;
    }

    public String getPasswordLabel() {
        Tasklet t = this.findParent(WsTrustUsersTasklet.class);
        return t != null ? "Password" : "New Password";
    }

    public String getConfirmPasswordLabel() {
        Tasklet t = this.findParent(WsTrustUsersTasklet.class);
        return t != null ? "Confirm Password" : "Confirm New Password";
    }
}

