/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.InboundProvisioningOperationState;
import com.pingidentity.fsm.state.impl.UserProvisioningAdapterContractMappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningOperationTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.UserProvisioning;

public class UserProvisioningAttributesState
extends ConfigLdapDirSearchState {
    private static final long serialVersionUID = 20050515L;

    public UserProvisioningAttributesState(Tasklet value) {
        super(value);
        this.setMenuName("Attributes");
    }

    @Override
    protected Collection<String> getAvailableSubstitutionAttributes() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }

    @Override
    public void onStateActivated() {
        AttributeSourceApi tasklet = this.findParent(AttributeSourceApi.class);
        LdapDataSource temp = (LdapDataSource)tasklet.getSelectedDataSource();
        super.initDataSource(temp);
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeSource source;
        IdpConnection connection = (IdpConnection)dataFromDisk;
        if (this.isInboundProvisioningTasklet()) {
            AttributeMapping mapping;
            if (this.getOperationType() == InboundProvisioningOperationState.OperationType.WRITE_USERS) {
                mapping = connection.getInboundProvisioning().getWriteUsersAttributeMapping();
                this.selectedAttributes = this.getSelectedAttributeNameListFromKeys(mapping.getAttributeMapping());
            } else if (this.getOperationType() == InboundProvisioningOperationState.OperationType.WRITE_GROUPS) {
                mapping = connection.getInboundProvisioning().getWriteGroupsAttributeMapping();
                this.selectedAttributes = this.getSelectedAttributeNameListFromKeys(mapping.getAttributeMapping());
            } else if (this.getOperationType() == InboundProvisioningOperationState.OperationType.READ_GROUPS) {
                mapping = connection.getInboundProvisioning().getReadGroupsAttributeMapping();
                this.selectedAttributes = this.getSelectedAttributeNameListFromValues(mapping.getAttributeMapping());
            } else {
                mapping = connection.getInboundProvisioning().getReadUsersAttributeMapping();
                this.selectedAttributes = this.getSelectedAttributeNameListFromValues(mapping.getAttributeMapping());
            }
            source = mapping.getAttributeSource();
        } else {
            UserProvisioning mapping = connection.getUserProvisioning();
            this.selectedAttributes = this.getSelectedAttributeNameListFromKeys(mapping.getAttributeMapping());
            source = mapping.getAttributeSource();
        }
        if (source != null) {
            this.dataSource = (LdapDataSource)source.getDataSource();
            this.baseDN = source.getParameter("search_base");
            this.selectedSearchScope = "ONELEVEL_SCOPE";
            if (this.supportNestedGroup()) {
                this.populateMemberOf(source);
            }
        }
        this.populate();
    }

    @Override
    public String getNoteKey() {
        Object noteKey = super.getNoteKey();
        Tasklet parent = this.getParent();
        if (parent instanceof InboundProvisioningOperationTasklet) {
            InboundProvisioningOperationState.OperationType operationType = this.getOperationType();
            if (operationType == InboundProvisioningOperationState.OperationType.WRITE_USERS) {
                noteKey = (String)noteKey + "_WriteUsers";
            } else if (operationType == InboundProvisioningOperationState.OperationType.WRITE_GROUPS) {
                noteKey = (String)noteKey + "_WriteGroups";
            } else if (operationType == InboundProvisioningOperationState.OperationType.READ_GROUPS) {
                noteKey = (String)noteKey + "_ReadGroups";
            } else if (operationType == InboundProvisioningOperationState.OperationType.READ_USERS) {
                noteKey = (String)noteKey + "_ReadUsers";
            }
        }
        return noteKey;
    }

    private List<String> getSelectedAttributeNameListFromKeys(Map<String, List<AttrMappingValue>> attributeMapping) {
        ArrayList<String> attibNameList = new ArrayList<String>();
        if (attributeMapping != null && !attributeMapping.isEmpty()) {
            for (String attribName : attributeMapping.keySet()) {
                List<AttrMappingValue> valueList = attributeMapping.get(attribName);
                for (AttrMappingValue val : valueList) {
                    attibNameList.add(attribName);
                }
            }
        }
        return attibNameList;
    }

    private List<String> getSelectedAttributeNameListFromValues(Map<String, List<AttrMappingValue>> attributeMapping) {
        ArrayList<String> attibNameList = new ArrayList<String>();
        if (attributeMapping != null && !attributeMapping.isEmpty()) {
            for (String attribName : attributeMapping.keySet()) {
                List<AttrMappingValue> valueList = attributeMapping.get(attribName);
                for (AttrMappingValue val : valueList) {
                    if (val.getType() != SourceType.LDAP_DATA_STORE) continue;
                    attibNameList.add(val.getValue());
                }
            }
        }
        return attibNameList;
    }

    @Override
    public void populate() {
        if (!this.isViewOnly() && this.dataSource != null) {
            this.initializeSearchScope();
            this.selectedRootClass = "";
            this.availableAttributes = this.getAvailableAttrs();
            this.cullAvailableAttributes();
            this.availableAttrList = this.createPairModel(this.availableAttributes);
        }
        if (StringUtils.isBlank((String)this.selectedAvailableAttr)) {
            this.selectedAvailableAttr = null;
        }
    }

    @Override
    public void addAttribute() {
        if (this.validate(this.selectedRootClass, this.selectedAvailableAttr)) {
            super.addAttribute();
        }
    }

    @Override
    public void deleteAttribute(String attributeToRemove) {
        super.deleteAttribute(attributeToRemove);
        UserProvisioningAdapterContractMappingState nextState = (UserProvisioningAdapterContractMappingState)this.getOutgoingTransition().getTarget();
        Map mapping = nextState.getModel().getMapping().getAttributeMapping();
        if (mapping.containsKey(attributeToRemove)) {
            int mappingSize = ((List)mapping.get(attributeToRemove)).size();
            if (mappingSize > 1) {
                ((List)mapping.get(attributeToRemove)).remove(mappingSize - 1);
            } else {
                nextState.getModel().getMapping().removeAttributeMapping(attributeToRemove);
            }
        }
    }

    private boolean validate(String selectedRootObjClass, String selectedAttribute) {
        this.delegate.clearErrors();
        if (StringUtils.isBlank((String)selectedRootObjClass)) {
            this.delegate.record(this.getMessage("Root_obj_class_required_for_add"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)selectedAttribute)) {
            this.delegate.record(this.getMessage("Attribute_required_for_add"), ValidationConstraint.REQUIRED);
        }
        return !this.delegate.getHasErrors();
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        if (this.isInboundProvisioningTasklet()) {
            AttributeSource attributeSource = connection.getInboundProvisioning().getWriteUsersAttributeMapping().getAttributeSource();
            if (attributeSource != null) {
                attributeSource.setParameter("search_scope", "ONELEVEL_SCOPE");
                this.saveMemberOfNestedGroup(attributeSource);
            }
        } else {
            AttributeSource attributeSource = connection.getUserProvisioning().getAttributeSource();
            attributeSource.setParameter("search_scope", "ONELEVEL_SCOPE");
            this.saveMemberOfNestedGroup(attributeSource);
        }
        return true;
    }

    @Override
    protected void saveMemberOfNestedGroup(AttributeSource source) {
        if (this.supportNestedGroup()) {
            super.saveMemberOfNestedGroup(source);
        }
    }

    private InboundProvisioningOperationState.OperationType getOperationType() {
        if (this.isInboundProvisioningTasklet()) {
            InboundProvisioningOperationTasklet parent = (InboundProvisioningOperationTasklet)this.getParent();
            return parent.getOperationType();
        }
        return null;
    }

    @Override
    public void reset() {
        this.resetAllValues();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String attribName : this.selectedAttributes) {
            summaryList.add(new SummaryInfo("instance of", this.getMemberOfSummaryDescription(attribName), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedAttributes == null || this.selectedAttributes.size() < 1) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_attr_required"), ValidationConstraint.REQUIRED);
        }
    }

    private boolean isInboundProvisioningTasklet() {
        return this.findParent(InboundProvisioningTasklet.class) != null;
    }

    @Override
    public String getLinkText() {
        return this.isInboundProvisioningTasklet() ? "SCIM Request Attributes" : "JIT Request Attributes";
    }

    @Override
    public boolean showNestedGroup() {
        return this.supportNestedGroup() && super.showNestedGroup();
    }

    public boolean supportNestedGroup() {
        return this.getOperationType() == InboundProvisioningOperationState.OperationType.READ_USERS;
    }

    @Override
    protected boolean isAttributeOptionsSupported() {
        return false;
    }
}

