/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigLdapFilterState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import java.util.List;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LdapDataSource;

public class UserProvisioningConfigLdapFilterState
extends ConfigLdapFilterState {
    private static final long serialVersionUID = 20050515L;

    public UserProvisioningConfigLdapFilterState(Tasklet parent, String cardName) {
        super(parent, cardName);
        this.setMenuName("Unique User ID");
    }

    @Override
    public List<String> getValues() {
        List<String> items = this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
        return items;
    }

    @Override
    public void onStateActivated() {
        UserProvisioningTasklet tasklet = this.findParent(UserProvisioningTasklet.class);
        LdapDataSource tempDataSource = (LdapDataSource)tasklet.getSelectedDataSource();
        if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
            this.dataSource = tempDataSource;
            this.origFilter = new String("");
            this.filter = new String("");
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        AttributeSource source = this.isInboundProvisioningTasklet() ? connection.getInboundProvisioning().getWriteUsersAttributeMapping().getAttributeSource() : connection.getUserProvisioning().getAttributeSource();
        this.dataSource = (LdapDataSource)source.getDataSource();
        this.filter = this.origFilter = source.getParameter("filter");
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        if (this.isInboundProvisioningTasklet()) {
            connection.getInboundProvisioning().getWriteUsersAttributeMapping().getAttributeSource().setParameter("filter", this.filter);
            connection.getInboundProvisioning().getReadUsersAttributeMapping().getAttributeSource().setParameter("filter", this.filter);
        } else {
            connection.getUserProvisioning().getAttributeSource().setParameter("filter", this.filter);
        }
        return true;
    }

    private boolean isInboundProvisioningTasklet() {
        return this.findParent(InboundProvisioningTasklet.class) != null;
    }

    @Override
    public void reset() {
        this.filter = "";
        this.origFilter = "";
    }

    @Override
    public String getValueText() {
        return this.isInboundProvisioningTasklet() ? "SCIM Attributes" : "JIT Attributes";
    }

    @Override
    public String getNoteKey() {
        return this.getIsOidc() && this.getClass().equals(UserProvisioningConfigLdapFilterState.class) ? super.getNoteKey() + "_Oidc" : super.getNoteKey();
    }
}

