/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.handlers.SqlServerDataTypeCoersionHandler;

public class UserProvisioningJdbcUniqueIdState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String selectedColumn;
    private transient StringPairPropertySelectionModel columnList;

    public UserProvisioningJdbcUniqueIdState(Tasklet value) {
        super(value);
        this.setMenuName("Unique ID");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        UserProvisioning userProvisioning = connection.getUserProvisioning();
        AttributeSource as = userProvisioning.getAttributeSource();
        String uniqueIdColumn = as.getParameter("filter");
        if (!StringUtils.isEmpty((String)uniqueIdColumn)) {
            this.selectedColumn = uniqueIdColumn;
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        UserProvisioning outmap = connection.getUserProvisioning();
        AttributeSource as = outmap.getAttributeSource();
        as.setParameter("filter", this.selectedColumn);
        return true;
    }

    @Override
    public void onStateActivated() {
        this.columnList = new StringPairPropertySelectionModel(true);
        for (ResultInfo info : this.getAllColumnsWithMetadata()) {
            String columnName = info.getColumnName();
            this.columnList.add(columnName, columnName);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly()) {
            boolean errorFound = false;
            if (StringUtils.isEmpty((String)this.selectedColumn)) {
                errorFound = true;
            } else {
                List<String> columnNameList;
                UserProvisioningTasklet t = (UserProvisioningTasklet)this.getParent();
                if (t.isTableSqlMethod() && t.isDatabaseTableAndColumnStatePopulated() && !(columnNameList = this.getAllColumnNames()).contains(this.selectedColumn)) {
                    errorFound = true;
                }
            }
            if (errorFound) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Selected_column_required"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedColumn != null) {
            summaryList.add(new SummaryInfo("Unique ID", this.selectedColumn, this));
        }
    }

    private List<ResultInfo> getAllColumnsWithMetadata() {
        ArrayList<ResultInfo> freshResultInfoList = new ArrayList<ResultInfo>();
        UserProvisioningTasklet t = (UserProvisioningTasklet)this.getParent();
        List<ResultInfo> columnsWithMetadata = t.getAllColumnsWithMetadata();
        if (columnsWithMetadata != null) {
            for (ResultInfo info : columnsWithMetadata) {
                SqlServerDataTypeCoersionHandler handler;
                if (!this.showTypeUIDisplay(info) || !(handler = new SqlServerDataTypeCoersionHandler(null, JdbcExpressProvisioningProcessor.OPERATION.INSERT, true)).doesResultInfoHaveSupportedType(info, new ArrayList())) continue;
                freshResultInfoList.add(new ResultInfo(info));
            }
        }
        return freshResultInfoList;
    }

    private List<String> getAllColumnNames() {
        ArrayList<String> selectedColumns = new ArrayList<String>();
        for (ResultInfo info : this.getAllColumnsWithMetadata()) {
            selectedColumns.add(info.getColumnName());
        }
        return selectedColumns;
    }

    private boolean showTypeUIDisplay(ResultInfo info) {
        switch (info.getDataType()) {
            case -7: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public String getSelectedColumn() {
        return this.selectedColumn;
    }

    public void setSelectedColumn(String selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    public StringPairPropertySelectionModel getColumnList() {
        return this.columnList;
    }

    public void setColumnList(StringPairPropertySelectionModel columnList) {
        this.columnList = columnList;
    }
}

