/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UserProvisioning;

public class UserProvisioningSqlMethodState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final String TABLE = "Table";
    private static final String STORED_PROCEDURE = "StoredProcedure";
    private String selectedSqlMethod = "Table";

    public UserProvisioningSqlMethodState(Tasklet value) {
        super(value);
        this.setMenuName("SQL Method");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        this.selectedSqlMethod = UserProvisioning.SqlMethodType.Table.equals((Object)connection.getUserProvisioning().getSqlMethod()) ? TABLE : STORED_PROCEDURE;
        this.getParent().reconfigureTransitions(this);
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
            this.getParent().reconfigureTransitions(this);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("SQL Method", this.getSelectedSqlMethodForDisplay(), this));
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        UserProvisioning userProvisioning = connection.getUserProvisioning();
        if (UserProvisioning.SqlMethodType.Table.toString().equals(this.selectedSqlMethod)) {
            userProvisioning.setSqlMethod(UserProvisioning.SqlMethodType.Table);
        } else {
            userProvisioning.setSqlMethod(UserProvisioning.SqlMethodType.StoredProcedure);
        }
        return true;
    }

    @Override
    public void reset() {
        this.selectedSqlMethod = TABLE;
    }

    public String getSelectedSqlMethod() {
        return this.selectedSqlMethod;
    }

    public void setSelectedSqlMethod(String selectedSqlMethod) {
        if (!this.selectedSqlMethod.equals(selectedSqlMethod)) {
            this.selectedSqlMethod = selectedSqlMethod;
            this.getParent().reconfigureTransitions(this);
        }
    }

    public String getSelectedSqlMethodForDisplay() {
        return this.selectedSqlMethod.equalsIgnoreCase(TABLE) ? TABLE : "Stored Procedure";
    }

    public boolean isTableSqlMethod() {
        return TABLE.equalsIgnoreCase(this.selectedSqlMethod);
    }
}

