/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigAdapterMappingState;
import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.SelectIdpAccountLinkingState;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.UserSessionCreationTasklet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.IdpConnection;

public class UserSessionCreationState
extends SingleTaskletState
implements AttributeNamesApi {
    private static final long serialVersionUID = 20050515L;
    private static final String ACCT_MAPPING = "Account Mapping";
    private static final String ACCT_LINKING = "Account Linking";
    private static final String NOT_CONFIGURED = "Not Configured";
    private static final String SAML_SUBJECT = "SAML_SUBJECT";
    private IdpConnection idpConnection;
    private Object populateAllStatesData;

    public UserSessionCreationState(Tasklet value) {
        super(value);
        this.setMenuName("User-Session Creation");
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
        UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
        CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
        if (createAttributeContractState != null) {
            createAttributeContractState.onStateActivated();
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idpConnection = (IdpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    public String getIdentityMapping() {
        UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
        SelectIdpAccountLinkingState selectIdpAccountLinkingState = (SelectIdpAccountLinkingState)t.findState("selectIdpAccountLinking");
        if (this.getAdapterCount() < 1) {
            return NOT_CONFIGURED;
        }
        return selectIdpAccountLinkingState.isLinking() ? ACCT_LINKING : ACCT_MAPPING;
    }

    public List<String> getAttributeContractItems() {
        UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
        CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
        ArrayList<String> attributeContractList = new ArrayList<String>();
        if (createAttributeContractState != null) {
            AttributeContract attributeContract = createAttributeContractState.getContract();
            Util.populateAttributeContractList(attributeContractList, (AttributeContract)attributeContract);
        } else {
            String subject = this.getIsOidcEnabled() ? "sub" : SAML_SUBJECT;
            attributeContractList.add(subject);
        }
        return attributeContractList;
    }

    public int getAdapterCount() {
        UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
        ConfigAdapterMappingState configAdapterMappingState = (ConfigAdapterMappingState)t.findState("configAdapterMapping");
        return configAdapterMappingState != null ? configAdapterMappingState.getAdapterTasklets().size() : 0;
    }

    public int getC2cCount() {
        if (this.getIsC2cEnabled()) {
            UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
            ConfigAdapterMappingState configAdapterMappingState = (ConfigAdapterMappingState)t.findState("configAdapterMapping");
            return configAdapterMappingState != null ? configAdapterMappingState.getC2cTasklets().size() : 0;
        }
        return 0;
    }

    public List<IdpConfigAdapterMappingTasklet> getAdapterTasklets() {
        UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
        ConfigAdapterMappingState configAdapterMappingState = (ConfigAdapterMappingState)t.findState("configAdapterMapping");
        return configAdapterMappingState != null ? configAdapterMappingState.getAdapterTasklets() : null;
    }

    public List<IdpC2cContractMappingTasklet> getC2cTasklets() {
        UserSessionCreationTasklet t = (UserSessionCreationTasklet)this.getTaskletToEdit();
        ConfigAdapterMappingState configAdapterMappingState = (ConfigAdapterMappingState)t.findState("configAdapterMapping");
        return configAdapterMappingState != null ? configAdapterMappingState.getC2cTasklets() : null;
    }

    private void populateTasklet() {
        UserSessionCreationTasklet tasklet = this.getTaskletToEdit(UserSessionCreationTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(UserSessionCreationTasklet.class);
            tasklet.configureTasklet();
            if (this.idpConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.idpConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            Tasklet parentTasklet = this.getParent();
            if (!parentTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Not_configured"), ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public Set<String> getAllAttributeNames() {
        Set<String> attributeContractSet = new HashSet<String>();
        UserSessionCreationTasklet t = this.getTaskletToEdit(UserSessionCreationTasklet.class);
        CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
        if (createAttributeContractState != null) {
            AttributeContract attributeContract = createAttributeContractState.getContract();
            attributeContractSet = attributeContract.getAllAttributeNames();
        }
        return attributeContractSet;
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        UserSessionCreationTasklet t = this.getTaskletToEdit(UserSessionCreationTasklet.class);
        return t.getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        List<String> attributeContractList = new ArrayList<String>();
        UserSessionCreationTasklet t = this.getTaskletToEdit(UserSessionCreationTasklet.class);
        CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
        if (createAttributeContractState != null) {
            AttributeContract attributeContract = createAttributeContractState.getContract();
            attributeContractList = attributeContract.getSortedImmutableAttributeNames();
        }
        return attributeContractList;
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        List<String> attributeContractList = new ArrayList<String>();
        UserSessionCreationTasklet t = this.getTaskletToEdit(UserSessionCreationTasklet.class);
        CreateAttributeContractState createAttributeContractState = (CreateAttributeContractState)t.findState("createAttributeContract");
        if (createAttributeContractState != null) {
            AttributeContract attributeContract = createAttributeContractState.getContract();
            attributeContractList = attributeContract.getSortedMutableAttributeNames();
        }
        return attributeContractList;
    }

    public boolean getIsC2cEnabled() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        return connTasklet.isC2cEnabled();
    }

    public boolean getIsOidcEnabled() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }
}

